/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.gui;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.gui.KeymanController;
import com.ibm.gsk.ikeyman.command.gui.KeymanView;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.CertificateDetailsDialog;
import com.ibm.gsk.ikeyman.gui.panels.MainPanel;
import com.ibm.gsk.ikeyman.io.Logger;
import com.ibm.gsk.ikeyman.keystore.entry.Entry;
import com.ibm.gsk.ikeyman.keystore.ext.DatabaseDescriptorFactory;
import com.ibm.gsk.ikeyman.keystore.ext.Displayable;
import com.ibm.gsk.ikeyman.keystore.ext.KeyStoreInfo;
import com.ibm.gsk.ikeyman.messages.ControlNames;
import com.ibm.gsk.ikeyman.messages.Messages;
import com.ibm.gsk.ikeyman.util.KeymanUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeymanFrame
extends JFrame
implements KeymanView {
    private static final String WIN_LOOK_AND_FEEL = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String MAC_LOOK_AND_FEEL = "com.sun.java.swing.plaf.mac.MacLookAndFeel";
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JMenuBar mainMenuBar = null;
    private JMenu fileMenu = null;
    private JMenu createMenu = null;
    private JMenu viewMenu = null;
    private JMenu helpMenu = null;
    private JMenuItem newMenuItem = null;
    private JMenuItem openMenuItem = null;
    private JMenuItem newProviderMenuItem = null;
    private JMenuItem closeMenuItem = null;
    private JMenuItem saveAsMenuItem = null;
    private JMenuItem changePasswordMenuItem = null;
    private JMenuItem stashPasswordMenuItem = null;
    private JMenuItem displayPasswordExpiryMenuItem = null;
    private JMenuItem exitMenuItem = null;
    private JMenuItem newCertRequestMenuItem = null;
    private JMenuItem newSelfSignedMenuItem = null;
    private JToolBar toolBar = null;
    private JButton newBtn = null;
    private JButton openBtn = null;
    private JButton saveBtn = null;
    private JButton newProviderBtn = null;
    private JButton newCertRequestBtn = null;
    private JButton newSelfsignedBtn = null;
    private JPanel statusBar = null;
    private JLabel statusLabel = null;
    private MainPanel mainPanel = null;
    private JPanel centrePanel = null;
    private KeymanController controller;
    private NewDatabaseAction newDatabaseAction;
    private OpenDatabaseAction openDatabaseAction;
    private CreateCertRequestAction createCertRequestAction;
    private CreateSelfsignedCertAction createSelfSignedCertAction;
    private SaveAsAction saveAsAction;
    private AddProviderAction addProviderAction;
    private KeyStoreInfo keyStore;
    private JMenuItem aboutMenu = null;
    private JCheckBoxMenuItem toolbarMenuItem = null;
    private JCheckBoxMenuItem statusbarMenuItem = null;
    private JCheckBoxMenuItem tooltipsMenuItem = null;
    private JRadioButtonMenuItem metalLnFMenu = null;
    private JRadioButtonMenuItem windowsLnFMenu = null;
    private JRadioButtonMenuItem macLnFMenu = null;
    private CheckboxMenuItemActionListener checkboxMenuItemListener = new CheckboxMenuItemActionListener();

    public KeymanFrame() {
        this((KeymanController)null);
    }

    public KeymanFrame(KeymanController c) {
        UIManager.put("OptionPane.okButtonMnemonic", new Integer(79).toString());
        UIManager.put("OptionPane.cancelButtonMnemonic", new Integer(67).toString());
        this.controller = c == null ? new KeymanController(this, this) : c;
        this.newDatabaseAction = new NewDatabaseAction(this.controller);
        this.openDatabaseAction = new OpenDatabaseAction(this.controller);
        this.createCertRequestAction = new CreateCertRequestAction(this.controller);
        this.createSelfSignedCertAction = new CreateSelfsignedCertAction(this.controller);
        this.saveAsAction = new SaveAsAction(this.controller);
        this.addProviderAction = new AddProviderAction(this.controller);
        this.initialize();
    }

    private void initialize() {
        this.setSize(916, 611);
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/com/ibm/gsk/ikeyman/data/ikeyman.gif")));
        this.setDefaultCloseOperation(3);
        this.setJMenuBar(this.getMainMenuBar());
        this.setContentPane(this.getJContentPane());
        this.setName(ControlNames.KeymanFrame.toString());
        this.updateTitle(null);
        this.centerFrame();
        this.updateDatabase(null);
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        this.updateMainActions(true);
    }

    private void setActionsEnabled(boolean value) {
        this.createCertRequestAction.setEnabled(value);
        this.createSelfSignedCertAction.setEnabled(value);
        this.closeMenuItem.setEnabled(value);
        if (this.keyStore != null) {
            DatabaseDescriptorFactory.DatabaseDescriptor descriptor = this.keyStore.getDescriptor();
            this.saveAsAction.setEnabled(descriptor.allowsAction(Constants.CommandType.ConvertDB) ? value : false);
            this.changePasswordMenuItem.setEnabled(descriptor.allowsAction(Constants.CommandType.ChangeDBPassword) ? value : false);
            this.stashPasswordMenuItem.setEnabled(descriptor.allowsAction(Constants.CommandType.StashDBPassword) ? value : false);
            this.displayPasswordExpiryMenuItem.setEnabled(descriptor.allowsAction(Constants.CommandType.DisplayDBPasswordExpiry) ? value : false);
        } else {
            this.saveAsAction.setEnabled(value);
            this.changePasswordMenuItem.setEnabled(value);
            this.stashPasswordMenuItem.setEnabled(value);
            this.displayPasswordExpiryMenuItem.setEnabled(value);
        }
    }

    private void setMainActionsEnabled(boolean value) {
        this.newDatabaseAction.setEnabled(value);
        this.openDatabaseAction.setEnabled(value);
    }

    private void centerFrame() {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((screen.getWidth() - (double)this.getWidth()) / 2.0);
        int y = (int)((screen.getHeight() - (double)this.getHeight()) / 2.0);
        this.setLocation(x, y);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getToolBar(), "North");
            this.jContentPane.add((Component)this.getStatusBar(), "South");
            this.jContentPane.add((Component)this.getCentrePanel(), "Center");
        }
        return this.jContentPane;
    }

    private JMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.mainMenuBar = new JMenuBar();
            this.mainMenuBar.add(this.getFileMenu());
            this.mainMenuBar.add(this.getCreateMenu());
            this.mainMenuBar.add(this.getViewMenu());
            this.mainMenuBar.add(this.getHelpMenu());
        }
        return this.mainMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.File"), this.fileMenu);
            this.fileMenu.add(this.getNewMenuItem());
            this.fileMenu.add(this.getOpenMenuItem());
            this.fileMenu.add(this.getNewProviderMenuItem());
            this.fileMenu.add(this.getCloseMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getSaveAsMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getChangePasswordMenuItem());
            this.fileMenu.add(this.getStashPasswordMenuItem());
            this.fileMenu.add(this.getDisplayPasswordExpiryMenuItem());
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.getExitMenuItem());
            this.fileMenu.setName(ControlNames.KeymanFrameFileMenu.toString());
        }
        return this.fileMenu;
    }

    private JMenu getCreateMenu() {
        if (this.createMenu == null) {
            this.createMenu = new JMenu();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Create"), this.createMenu);
            this.createMenu.add(this.getNewCertRequestMenuItem());
            this.createMenu.add(this.getNewSelfSignedMenuItem());
            this.createMenu.setName(ControlNames.KeymanFrameCreateMenu.toString());
        }
        return this.createMenu;
    }

    private JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu();
            this.viewMenu.add(this.getMetalLnFMenu());
            this.viewMenu.add(this.getWindowsLnFMenu());
            this.viewMenu.add(this.getMacLnFMenu());
            ButtonGroup lookAndFeelBtnGroup = new ButtonGroup();
            lookAndFeelBtnGroup.add(this.getMetalLnFMenu());
            lookAndFeelBtnGroup.add(this.getWindowsLnFMenu());
            lookAndFeelBtnGroup.add(this.getMacLnFMenu());
            this.viewMenu.addSeparator();
            this.viewMenu.add(this.getToolbarMenuItem());
            this.viewMenu.add(this.getStatusbarMenuItem());
            this.viewMenu.add(this.getTooltipsMenuItem());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.View"), this.viewMenu);
            this.viewMenu.setName(ControlNames.KeymanFrameViewMenu.toString());
        }
        return this.viewMenu;
    }

    private JMenu getHelpMenu() {
        if (this.helpMenu == null) {
            this.helpMenu = new JMenu();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Help"), this.helpMenu);
            this.helpMenu.add(this.getAboutMenu());
            this.helpMenu.setName(ControlNames.KeymanFrameHelpMenu.toString());
        }
        return this.helpMenu;
    }

    private JMenuItem getNewMenuItem() {
        if (this.newMenuItem == null) {
            this.newMenuItem = new JMenuItem();
            this.newMenuItem.setAction(this.newDatabaseAction);
            this.newMenuItem.setName(ControlNames.KeymanFrameNewMenuItem.toString());
        }
        return this.newMenuItem;
    }

    private JMenuItem getOpenMenuItem() {
        if (this.openMenuItem == null) {
            this.openMenuItem = new JMenuItem();
            this.openMenuItem.setAction(this.openDatabaseAction);
            this.openMenuItem.setName(ControlNames.KeymanFrameOpenMenuItem.toString());
        }
        return this.openMenuItem;
    }

    private JMenuItem getNewProviderMenuItem() {
        if (this.newProviderMenuItem == null) {
            this.newProviderMenuItem = new JMenuItem();
            this.newProviderMenuItem.setAction(this.addProviderAction);
            this.newProviderMenuItem.setName(ControlNames.KeymanFrameNewProviderMenuItem.toString());
        }
        return this.newProviderMenuItem;
    }

    private JMenuItem getCloseMenuItem() {
        if (this.closeMenuItem == null) {
            this.closeMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Close"), this.closeMenuItem);
            this.closeMenuItem.addActionListener(this.controller);
            this.closeMenuItem.setActionCommand(Constants.CommandType.CloseDb.toString());
            this.closeMenuItem.setToolTipText(Messages.getString("Tooltip.CloseDb"));
            this.closeMenuItem.setName(ControlNames.KeymanFrameCloseMenuItem.toString());
        }
        return this.closeMenuItem;
    }

    private JMenuItem getSaveAsMenuItem() {
        if (this.saveAsMenuItem == null) {
            this.saveAsMenuItem = new JMenuItem();
            this.saveAsMenuItem.setAction(this.saveAsAction);
            this.saveAsMenuItem.setName(ControlNames.KeymanFrameSaveAsMenuItem.toString());
        }
        return this.saveAsMenuItem;
    }

    private JMenuItem getChangePasswordMenuItem() {
        if (this.changePasswordMenuItem == null) {
            this.changePasswordMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.ChangePassword"), this.changePasswordMenuItem);
            this.changePasswordMenuItem.addActionListener(this.controller);
            this.changePasswordMenuItem.setActionCommand(Constants.CommandType.ChangeDBPassword.toString());
            this.changePasswordMenuItem.setToolTipText(Messages.getString("Tooltip.ChangePassword"));
            this.changePasswordMenuItem.setName(ControlNames.KeymanFrameChangePasswordMenuItem.toString());
        }
        return this.changePasswordMenuItem;
    }

    private JMenuItem getStashPasswordMenuItem() {
        if (this.stashPasswordMenuItem == null) {
            this.stashPasswordMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.StashPassword"), this.stashPasswordMenuItem);
            this.stashPasswordMenuItem.addActionListener(this.controller);
            this.stashPasswordMenuItem.setActionCommand(Constants.CommandType.StashDBPassword.toString());
            this.stashPasswordMenuItem.setToolTipText(Messages.getString("Tooltip.StashPassword"));
            this.stashPasswordMenuItem.setName(ControlNames.KeymanFrameStashPasswordMenuItem.toString());
        }
        return this.stashPasswordMenuItem;
    }

    private JMenuItem getDisplayPasswordExpiryMenuItem() {
        if (this.displayPasswordExpiryMenuItem == null) {
            this.displayPasswordExpiryMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.DisplayPasswordExpiry"), this.displayPasswordExpiryMenuItem);
            this.displayPasswordExpiryMenuItem.addActionListener(this.controller);
            this.displayPasswordExpiryMenuItem.setActionCommand(Constants.CommandType.DisplayDBPasswordExpiry.toString());
            this.displayPasswordExpiryMenuItem.setToolTipText(Messages.getString("Tooltip.DisplayPasswordExpiry"));
            this.displayPasswordExpiryMenuItem.setName(ControlNames.KeymanFrameDisplayPasswordExpiryMenuItem.toString());
        }
        return this.displayPasswordExpiryMenuItem;
    }

    private JMenuItem getExitMenuItem() {
        if (this.exitMenuItem == null) {
            this.exitMenuItem = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Exit"), this.exitMenuItem);
            this.exitMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    KeymanFrame.this.exit();
                }
            });
            this.exitMenuItem.setToolTipText(Messages.getString("Tooltip.Exit"));
            this.exitMenuItem.setName(ControlNames.KeymanFrameExitMenuItem.toString());
        }
        return this.exitMenuItem;
    }

    private void exit() {
        System.exit(0);
    }

    private JMenuItem getNewCertRequestMenuItem() {
        if (this.newCertRequestMenuItem == null) {
            this.newCertRequestMenuItem = new JMenuItem();
            this.newCertRequestMenuItem.setAction(this.createCertRequestAction);
            this.newCertRequestMenuItem.setName(ControlNames.KeymanFrameNewCertRequestMenuItem.toString());
        }
        return this.newCertRequestMenuItem;
    }

    private JMenuItem getNewSelfSignedMenuItem() {
        if (this.newSelfSignedMenuItem == null) {
            this.newSelfSignedMenuItem = new JMenuItem();
            this.newSelfSignedMenuItem.setAction(this.createSelfSignedCertAction);
            this.newSelfSignedMenuItem.setName(ControlNames.KeymanFrameNewSelfSignedMenuItem.toString());
        }
        return this.newSelfSignedMenuItem;
    }

    private JToolBar getToolBar() {
        if (this.toolBar == null) {
            this.toolBar = new JToolBar();
            this.toolBar.setFloatable(false);
            this.toolBar.add(this.getNewBtn());
            this.toolBar.add(this.getOpenBtn());
            this.toolBar.add(this.getSaveBtn());
            this.toolBar.add(this.getNewProviderBtn());
            this.toolBar.add(this.getNewCertRequestBtn());
            this.toolBar.add(this.getNewSelfsignedBtn());
        }
        return this.toolBar;
    }

    private JButton getNewBtn() {
        if (this.newBtn == null) {
            this.newBtn = new JButton();
            this.newBtn.setAction(this.newDatabaseAction);
            this.newBtn.getAccessibleContext().setAccessibleName(Messages.getString("Menu.Item.New"));
            this.newBtn.setText("");
            this.newBtn.setMnemonic(0);
            this.newBtn.setName(ControlNames.KeymanFrameNewButton.toString());
            this.newBtn.setFocusable(false);
        }
        return this.newBtn;
    }

    private JButton getOpenBtn() {
        if (this.openBtn == null) {
            this.openBtn = new JButton();
            this.openBtn.setAction(this.openDatabaseAction);
            this.openBtn.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.Open")));
            this.openBtn.setText("");
            this.openBtn.setMnemonic(0);
            this.openBtn.setName(ControlNames.KeymanFrameOpenButton.toString());
            this.openBtn.setFocusable(false);
        }
        return this.openBtn;
    }

    private JButton getSaveBtn() {
        if (this.saveBtn == null) {
            this.saveBtn = new JButton();
            this.saveBtn.setAction(this.saveAsAction);
            this.saveBtn.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.SaveAs")));
            this.saveBtn.setText("");
            this.saveBtn.setMnemonic(0);
            this.saveBtn.setName(ControlNames.KeymanFrameSaveButton.toString());
            this.saveBtn.setFocusable(false);
        }
        return this.saveBtn;
    }

    private JButton getNewProviderBtn() {
        if (this.newProviderBtn == null) {
            this.newProviderBtn = new JButton();
            this.newProviderBtn.setAction(this.addProviderAction);
            this.newProviderBtn.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.NewProvider")));
            this.newProviderBtn.setText("");
            this.newProviderBtn.setMnemonic(0);
            this.newProviderBtn.setName(ControlNames.KeymanFrameNewProviderButton.toString());
            this.newProviderBtn.setFocusable(false);
        }
        return this.newProviderBtn;
    }

    private JButton getNewCertRequestBtn() {
        if (this.newCertRequestBtn == null) {
            this.newCertRequestBtn = new JButton();
            this.newCertRequestBtn.setAction(this.createCertRequestAction);
            this.newCertRequestBtn.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.NewCertReq")));
            this.newCertRequestBtn.setText("");
            this.newCertRequestBtn.setMnemonic(0);
            this.newCertRequestBtn.setName(ControlNames.KeymanFrameNewCertRequestButton.toString());
            this.newCertRequestBtn.setFocusable(false);
        }
        return this.newCertRequestBtn;
    }

    private JButton getNewSelfsignedBtn() {
        if (this.newSelfsignedBtn == null) {
            this.newSelfsignedBtn = new JButton();
            this.newSelfsignedBtn.setAction(this.createSelfSignedCertAction);
            this.newSelfsignedBtn.getAccessibleContext().setAccessibleName(KeymanUtil.getMenuItemLabel(Messages.getString("Menu.Item.NewSelfsigned")));
            this.newSelfsignedBtn.setText("");
            this.newSelfsignedBtn.setMnemonic(0);
            this.newSelfsignedBtn.setName(ControlNames.KeymanFrameNewSelfsignedButton.toString());
            this.newSelfsignedBtn.setFocusable(false);
        }
        return this.newSelfsignedBtn;
    }

    private JPanel getStatusBar() {
        if (this.statusBar == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.setText(Messages.getString("Message.Start"));
            this.statusLabel.setName(ControlNames.KeymanFrameStatusbar.toString());
            this.statusBar = new JPanel();
            this.statusBar.setLayout(new BorderLayout());
            this.statusBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(0), BorderFactory.createBevelBorder(1)));
            this.statusBar.add((Component)this.statusLabel, "Center");
        }
        return this.statusBar;
    }

    private MainPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new MainPanel();
            this.mainPanel.addActionListener(this.controller);
        }
        return this.mainPanel;
    }

    private JPanel getCentrePanel() {
        if (this.centrePanel == null) {
            this.centrePanel = new JPanel();
            this.centrePanel.setLayout(new BorderLayout());
            this.centrePanel.setBorder(BorderFactory.createBevelBorder(1));
            this.centrePanel.add((Component)this.getMainPanel(), "Center");
        }
        return this.centrePanel;
    }

    @Override
    public void updateProviders(String provider) {
        this.updateMainActions(false);
    }

    @Override
    public void updateDatabase(KeyStoreInfo keystore, KeymanView.UpdateType type) throws KeyManagerException {
        switch (type) {
            case Changed: {
                if (!keystore.equals(this.keyStore)) break;
                this.updateDatabase(keystore);
                break;
            }
            case Closed: {
                this.updateDatabase(null);
                break;
            }
            case Opened: {
                this.updateDatabase(keystore);
            }
        }
    }

    private void updateMainActions(boolean showErrorMessage) {
        try {
            KeymanUtil.validateJCEProvider();
            this.setMainActionsEnabled(true);
        }
        catch (KeyManagerException e) {
            if (showErrorMessage) {
                Logger.showError(e);
            }
            this.setMainActionsEnabled(false);
        }
    }

    private void updateDatabase(KeyStoreInfo keystore) {
        this.mainPanel.refreshDatabase(keystore);
        this.keyStore = keystore;
        this.updateTitle(keystore);
        this.setActionsEnabled(keystore != null);
    }

    private void updateTitle(KeyStoreInfo keystore) {
        this.setTitle(Messages.getString("GUI.Title") + (keystore == null ? "" : " - [" + keystore.getDescriptor().getFileNameString() + "]"));
    }

    @Override
    public void showMessage(String message) {
        JOptionPane.showMessageDialog(this, message);
    }

    @Override
    public void showMessage(String message, String caption) {
        JOptionPane.showMessageDialog(this, message, caption, 1);
    }

    @Override
    public Entry getSelectedEntry() {
        return this.mainPanel.getSelectedEntry();
    }

    @Override
    public Collection<Entry> getSelectedEntries() {
        return this.mainPanel.getSelectedEntries();
    }

    @Override
    public KeyStoreInfo getSelectedDatabase() {
        return this.keyStore;
    }

    @Override
    public int showConfirmation(String message, String title, int options) {
        return JOptionPane.showConfirmDialog(this, message, title, options);
    }

    @Override
    public void displayDetails(Displayable displayable) throws KeyManagerException {
        CertificateDetailsDialog dialog = new CertificateDetailsDialog((Frame)this, displayable, this.keyStore.getDescriptor().getType().supportsCertModifications());
        dialog.addCertificateChangeListener(this.controller);
        if (!displayable.isValid()) {
            JOptionPane.showMessageDialog(this, Messages.getString("Message.ExpiredCert"), Messages.getString("GUI.Title.Warning"), 2);
        }
        dialog.setVisible(true);
        dialog.dispose();
    }

    @Override
    public void showStatusMessage(String message) {
        this.statusLabel.setText(message);
    }

    @Override
    public String getInput(String message, String title, String initialValue) throws CancelledException {
        String value;
        do {
            if ((value = (String)JOptionPane.showInputDialog(this, message, title, 3, null, null, initialValue)) != null) continue;
            throw new CancelledException();
        } while (value.trim().length() <= 0);
        return value;
    }

    @Override
    public void setWaitStatus(boolean b) {
        Cursor cursor = new Cursor(b ? 3 : 0);
        this.setCursor(cursor);
    }

    private JMenuItem getAboutMenu() {
        if (this.aboutMenu == null) {
            this.aboutMenu = new JMenuItem();
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.About"), this.aboutMenu);
            this.aboutMenu.addActionListener(this.controller);
            this.aboutMenu.setActionCommand(Constants.CommandType.Version.toString());
            this.aboutMenu.setName(ControlNames.KeymanFrameAboutMenuItem.toString());
        }
        return this.aboutMenu;
    }

    private JCheckBoxMenuItem getToolbarMenuItem() {
        if (this.toolbarMenuItem == null) {
            this.toolbarMenuItem = new JCheckBoxMenuItem();
            this.toolbarMenuItem.setSelected(true);
            this.toolbarMenuItem.addActionListener(this.checkboxMenuItemListener);
            this.toolbarMenuItem.setName(ControlNames.KeymanFrameToolbarMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Toolbar"), this.toolbarMenuItem);
        }
        return this.toolbarMenuItem;
    }

    private static void setMenuItemTextAndMnemonic(String textAndMnemonic, JMenuItem item) {
        item.setText(KeymanUtil.getMenuItemLabel(textAndMnemonic));
        item.setMnemonic(KeymanUtil.getHotKeyChar(textAndMnemonic));
    }

    private JCheckBoxMenuItem getStatusbarMenuItem() {
        if (this.statusbarMenuItem == null) {
            this.statusbarMenuItem = new JCheckBoxMenuItem();
            this.statusbarMenuItem.setSelected(true);
            this.statusbarMenuItem.addActionListener(this.checkboxMenuItemListener);
            this.statusbarMenuItem.setName(ControlNames.KeymanFrameStatusbarMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Statusbar"), this.statusbarMenuItem);
        }
        return this.statusbarMenuItem;
    }

    private JCheckBoxMenuItem getTooltipsMenuItem() {
        if (this.tooltipsMenuItem == null) {
            this.tooltipsMenuItem = new JCheckBoxMenuItem();
            this.tooltipsMenuItem.setSelected(true);
            this.tooltipsMenuItem.addActionListener(this.checkboxMenuItemListener);
            this.tooltipsMenuItem.setName(ControlNames.KeymanFrameTooltipsMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.Tooltip"), this.tooltipsMenuItem);
        }
        return this.tooltipsMenuItem;
    }

    private JRadioButtonMenuItem getMetalLnFMenu() {
        if (this.metalLnFMenu == null) {
            this.metalLnFMenu = new JRadioButtonMenuItem();
            this.metalLnFMenu.setAction(new LookAndFeelAction(UIManager.getCrossPlatformLookAndFeelClassName()));
            this.metalLnFMenu.setSelected(true);
            this.metalLnFMenu.setName(ControlNames.KeymanFrameMetalLnFMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.LnF.Metal"), this.metalLnFMenu);
        }
        return this.metalLnFMenu;
    }

    private JRadioButtonMenuItem getWindowsLnFMenu() {
        if (this.windowsLnFMenu == null) {
            this.windowsLnFMenu = new JRadioButtonMenuItem();
            this.windowsLnFMenu.setAction(new LookAndFeelAction(WIN_LOOK_AND_FEEL));
            this.windowsLnFMenu.setName(ControlNames.KeymanFrameWindowsLnFMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.LnF.Windows"), this.windowsLnFMenu);
            this.windowsLnFMenu.setVisible(KeymanUtil.isWindowsSystem());
        }
        return this.windowsLnFMenu;
    }

    private JRadioButtonMenuItem getMacLnFMenu() {
        if (this.macLnFMenu == null) {
            this.macLnFMenu = new JRadioButtonMenuItem();
            this.macLnFMenu.setAction(new LookAndFeelAction(MAC_LOOK_AND_FEEL));
            this.macLnFMenu.setName(ControlNames.KeymanFrameMacLnFMenuItem.toString());
            KeymanFrame.setMenuItemTextAndMnemonic(Messages.getStringWithMnemonics("Menu.Item.LnF.Mac"), this.macLnFMenu);
            this.macLnFMenu.setVisible(KeymanUtil.isMacSystem());
        }
        return this.macLnFMenu;
    }

    private class CheckboxMenuItemActionListener
    implements ActionListener {
        private CheckboxMenuItemActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == KeymanFrame.this.toolbarMenuItem) {
                KeymanFrame.this.toolBar.setVisible(((JCheckBoxMenuItem)source).isSelected());
                if (!KeymanFrame.this.toolBar.isVisible()) {
                    KeymanFrame.this.mainPanel.requestFocus();
                } else {
                    KeymanFrame.this.toolBar.requestFocus();
                }
            } else if (source == KeymanFrame.this.statusbarMenuItem) {
                KeymanFrame.this.statusBar.setVisible(((JCheckBoxMenuItem)source).isSelected());
            } else if (source == KeymanFrame.this.tooltipsMenuItem) {
                ToolTipManager.sharedInstance().setEnabled(((JCheckBoxMenuItem)source).isSelected());
            }
        }
    }

    private class LookAndFeelAction
    extends AbstractAction {
        private String lookAndFeelClass;

        public LookAndFeelAction(String lookAndFeelClass) {
            this.lookAndFeelClass = lookAndFeelClass;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.lookAndFeelClass);
            }
            catch (Exception ex) {
                Logger.showError(ex);
                try {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                }
                catch (Exception ex1) {
                    Logger.showError(ex1);
                }
                KeymanFrame.this.getMetalLnFMenu().setSelected(true);
            }
            SwingUtilities.updateComponentTreeUI(KeymanFrame.this);
        }
    }

    static class AddProviderAction
    extends KeymanAction {
        private static final String TEXT = Messages.getStringWithMnemonics("Menu.Item.NewProvider");
        private static final String ICON_PATH = "/com/ibm/gsk/ikeyman/data/prov.jpg";
        private static final String SHORT_TEXT = Messages.getString("Tooltip.NewProvider");

        public AddProviderAction(ActionListener listener) {
            super(TEXT, ICON_PATH, SHORT_TEXT, listener, Constants.CommandType.AddProvider);
        }
    }

    static class SaveAsAction
    extends KeymanAction {
        private static final String TEXT = Messages.getStringWithMnemonics("Menu.Item.SaveAs");
        private static final String ICON_PATH = "/com/ibm/gsk/ikeyman/data/save.gif";
        private static final String SHORT_TEXT = Messages.getString("Tooltip.SaveAs");

        public SaveAsAction(ActionListener listener) {
            super(TEXT, ICON_PATH, SHORT_TEXT, listener, Constants.CommandType.ConvertDB);
        }
    }

    static class CreateSelfsignedCertAction
    extends KeymanAction {
        private static final String TEXT = Messages.getStringWithMnemonics("Menu.Item.NewSelfsigned");
        private static final String ICON_PATH = "/com/ibm/gsk/ikeyman/data/cert.jpg";
        private static final String SHORT_TEXT = Messages.getString("Tooltip.NewSelfsigned");

        public CreateSelfsignedCertAction(ActionListener listener) {
            super(TEXT, ICON_PATH, SHORT_TEXT, listener, Constants.CommandType.CreateSSCert);
        }
    }

    static class CreateCertRequestAction
    extends KeymanAction {
        private static final String TEXT = Messages.getStringWithMnemonics("Menu.Item.NewCertReq");
        private static final String ICON_PATH = "/com/ibm/gsk/ikeyman/data/key.jpg";
        private static final String SHORT_TEXT = Messages.getString("Tooltip.NewCertReq");

        public CreateCertRequestAction(ActionListener listener) {
            super(TEXT, ICON_PATH, SHORT_TEXT, listener, Constants.CommandType.CreateCertRequest);
        }
    }

    static class OpenDatabaseAction
    extends KeymanAction {
        private static final String TEXT = Messages.getStringWithMnemonics("Menu.Item.Open");
        private static final String ICON_PATH = "/com/ibm/gsk/ikeyman/data/open.gif";
        private static final String SHORT_TEXT = Messages.getString("Tooltip.Open");

        public OpenDatabaseAction(ActionListener listener) {
            super(TEXT, ICON_PATH, SHORT_TEXT, listener, Constants.CommandType.LoadDB);
        }
    }

    static class NewDatabaseAction
    extends KeymanAction {
        private static final String TEXT = Messages.getStringWithMnemonics("Menu.Item.New");
        private static final String ICON_PATH = "/com/ibm/gsk/ikeyman/data/new.gif";
        private static final String SHORT_TEXT = Messages.getString("Tooltip.New");

        public NewDatabaseAction(ActionListener listener) {
            super(TEXT, ICON_PATH, SHORT_TEXT, listener, Constants.CommandType.CreateDB);
        }
    }

    static abstract class KeymanAction
    extends AbstractAction {
        private ActionListener listener;

        public KeymanAction(String text, String iconPath, String shortDescription, ActionListener listener, Constants.CommandType actionCommand) {
            super(KeymanUtil.getMenuItemLabel(text));
            this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource(iconPath)));
            this.putValue("ShortDescription", shortDescription);
            this.putValue("ActionCommandKey", actionCommand.toString());
            this.putValue("MnemonicKey", new Integer(Character.toUpperCase(KeymanUtil.getHotKeyChar(text))));
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke((int)Character.toUpperCase(KeymanUtil.getHotKeyChar(text)), 2));
            this.listener = listener;
        }

        public KeymanAction(String iconPath, String shortDescription, ActionListener listener, Constants.CommandType actionCommand, char acceleratorChar) {
        }

        public final void actionPerformed(ActionEvent e) {
            this.listener.actionPerformed(e);
        }
    }
}

