/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gsk.ikeyman.command.password;

import com.ibm.gsk.ikeyman.command.Constants;
import com.ibm.gsk.ikeyman.command.ParameterMap;
import com.ibm.gsk.ikeyman.command.password.CLICallbackHandlerJava5;
import com.ibm.gsk.ikeyman.command.password.KeymanPasswordCallback;
import com.ibm.gsk.ikeyman.command.password.PasswordCallbackHandler;
import com.ibm.gsk.ikeyman.error.CancelledException;
import com.ibm.gsk.ikeyman.error.KeyManagerException;
import com.ibm.gsk.ikeyman.gui.GUIConstants;
import com.ibm.gsk.ikeyman.gui.PasswordPromptDialog;
import java.awt.Frame;
import java.io.IOException;
import javax.security.auth.callback.CallbackHandler;

public class PasswordCallbackHandlerFactory {
    public static CallbackHandler getCLIHandler() {
        String[] version = System.getProperty("java.version").split("[.]");
        try {
            if (version.length >= 2 && new Integer(version[1]) >= 6) {
                return (CallbackHandler)Class.forName(PasswordCallbackHandlerFactory.class.getPackage().getName() + ".CLICallbackHandlerJava6").getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return new CLICallbackHandlerJava5();
        }
        catch (Exception e) {
            return new CLICallbackHandlerJava5();
        }
    }

    public static CallbackHandler getGUIHandler(Frame parent) {
        return new GUICallbackHandler(parent);
    }

    private static class GUICallbackHandler
    extends PasswordCallbackHandler {
        private Frame parent;

        public GUICallbackHandler(Frame parent) {
            this.parent = parent;
        }

        protected ParameterMap getPasswordMap(KeymanPasswordCallback callback) throws IOException {
            try {
                GUIConstants.DialogMode mode = callback.isCreate() ? GUIConstants.DialogMode.New : GUIConstants.DialogMode.Open;
                switch (callback.getDescriptorType()) {
                    case Source: {
                        return PasswordPromptDialog.getPasswordData(this.parent, callback.getType(), Constants.Parameter.Password, mode);
                    }
                    case Target: {
                        return PasswordPromptDialog.getTargetPasswordData(this.parent, callback.getType(), Constants.Parameter.Password, mode);
                    }
                    case Secondary: {
                        return PasswordPromptDialog.getPasswordData(this.parent, callback.getType(), Constants.Parameter.Password, mode, callback.getDatabaseName());
                    }
                }
                throw new RuntimeException("Unsupported descriptor type, GUICallbackHandler.getPassword");
            }
            catch (KeyManagerException e) {
                throw new RuntimeException(e);
            }
            catch (CancelledException e) {
                return null;
            }
        }
    }
}

