/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Hashtable;
import java.util.Vector;
import tcl.lang.EventDeleter;
import tcl.lang.IdleHandler;
import tcl.lang.TclEvent;
import tcl.lang.TclRuntimeError;
import tcl.lang.TimerEvent;
import tcl.lang.TimerHandler;

public class Notifier
implements EventDeleter {
    private TclEvent firstEvent;
    private TclEvent lastEvent;
    private TclEvent markerEvent;
    private TclEvent servicedEvent = null;
    Thread primaryThread;
    private static Hashtable notifierTable = new Hashtable();
    Vector timerList;
    int timerGeneration;
    boolean timerPending;
    Vector idleList;
    int idleGeneration;
    int refCount;

    private Notifier(Thread primaryTh) {
        this.primaryThread = primaryTh;
        this.firstEvent = null;
        this.lastEvent = null;
        this.markerEvent = null;
        this.timerList = new Vector();
        this.timerGeneration = 0;
        this.idleList = new Vector();
        this.idleGeneration = 0;
        this.timerPending = false;
        this.refCount = 0;
    }

    public static synchronized Notifier getNotifierForThread(Thread thread2) {
        Notifier notifier = (Notifier)notifierTable.get(thread2);
        if (notifier == null) {
            notifier = new Notifier(thread2);
            notifierTable.put(thread2, notifier);
        }
        return notifier;
    }

    public synchronized void preserve() {
        if (this.refCount < 0) {
            throw new TclRuntimeError("Attempting to preserve a freed Notifier");
        }
        ++this.refCount;
    }

    public synchronized void release() {
        if (this.refCount == 0 && this.primaryThread != null) {
            throw new TclRuntimeError("Attempting to release a Notifier before it's preserved");
        }
        if (this.refCount <= 0) {
            throw new TclRuntimeError("Attempting to release a freed Notifier");
        }
        --this.refCount;
        if (this.refCount == 0) {
            notifierTable.remove(this.primaryThread);
            this.primaryThread = null;
        }
    }

    public synchronized void queueEvent(TclEvent evt, int position) {
        evt.notifier = this;
        if (position == 0) {
            evt.next = null;
            if (this.firstEvent == null) {
                this.firstEvent = evt;
            } else {
                this.lastEvent.next = evt;
            }
            this.lastEvent = evt;
        } else if (position == 1) {
            evt.next = this.firstEvent;
            if (this.firstEvent == null) {
                this.lastEvent = evt;
            }
            this.firstEvent = evt;
        } else if (position == 2) {
            if (this.markerEvent == null) {
                evt.next = this.firstEvent;
                this.firstEvent = evt;
            } else {
                evt.next = this.markerEvent.next;
                this.markerEvent.next = evt;
            }
            this.markerEvent = evt;
            if (evt.next == null) {
                this.lastEvent = evt;
            }
        } else {
            throw new TclRuntimeError("wrong position \"" + position + "\", must be TCL.QUEUE_HEAD, TCL.QUEUE_TAIL or TCL.QUEUE_MARK");
        }
        if (Thread.currentThread() != this.primaryThread) {
            this.notifyAll();
        }
    }

    public synchronized void deleteEvents(EventDeleter deleter) {
        TclEvent servicedEvent = null;
        if (deleter == this) {
            servicedEvent = this.servicedEvent;
            if (servicedEvent == null) {
                throw new TclRuntimeError("servicedEvent was not set by serviceEvent()");
            }
            this.servicedEvent = null;
        }
        TclEvent prev = null;
        TclEvent evt = this.firstEvent;
        while (evt != null) {
            if (servicedEvent == null && deleter.deleteEvent(evt) == 1 || evt == servicedEvent) {
                if (evt == this.firstEvent) {
                    this.firstEvent = evt.next;
                } else {
                    prev.next = evt.next;
                }
                if (evt.next == null) {
                    this.lastEvent = prev;
                }
                if (evt == this.markerEvent) {
                    this.markerEvent = prev;
                }
                if (evt == servicedEvent) {
                    servicedEvent = null;
                    break;
                }
            } else {
                prev = evt;
            }
            evt = evt.next;
        }
        if (servicedEvent != null) {
            throw new TclRuntimeError("servicedEvent was not removed from the queue");
        }
    }

    public int deleteEvent(TclEvent evt) {
        throw new TclRuntimeError("The Notifier.deleteEvent() method should not be called");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int serviceEvent(int flags) {
        if ((flags & 0xFFFFFFFD) == 0) {
            flags |= 0xFFFFFFFD;
        }
        TclEvent evt = null;
        while ((evt = this.getAvailableEvent(evt)) != null) {
            evt.isProcessing = true;
            if (evt.processEvent(flags) != 0) {
                evt.isProcessed = true;
                if (evt.needsNotify) {
                    TclEvent tclEvent = evt;
                    synchronized (tclEvent) {
                        evt.notifyAll();
                    }
                }
                this.servicedEvent = evt;
                this.deleteEvents(this);
                return 1;
            }
            evt.isProcessing = false;
        }
        return 0;
    }

    private synchronized TclEvent getAvailableEvent(TclEvent skipEvent) {
        TclEvent evt = this.firstEvent;
        while (evt != null) {
            if (!evt.isProcessing && !evt.isProcessed && evt != skipEvent) {
                return evt;
            }
            evt = evt.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doOneEvent(int flags) {
        int result = 0;
        if ((flags & 0xFFFFFFFD) == 0) {
            flags |= 0xFFFFFFFD;
        }
        while (true) {
            Object h;
            if ((flags & 0xFFFFFFFD) == 32) {
                return this.serviceIdle();
            }
            long sysTime = System.currentTimeMillis();
            if (!this.timerPending && this.timerList.size() > 0) {
                h = (TimerHandler)this.timerList.elementAt(0);
                if (((TimerHandler)h).atTime <= sysTime) {
                    TimerEvent event2 = new TimerEvent();
                    event2.notifier = this;
                    this.queueEvent(event2, 0);
                    this.timerPending = true;
                }
            }
            if (this.serviceEvent(flags) != 0) {
                result = 1;
                break;
            }
            if ((flags & 0x20) != 0 && this.serviceIdle() != 0) {
                result = 1;
                break;
            }
            if ((flags & 2) != 0) break;
            try {
                h = this;
                synchronized (h) {
                    if (this.timerList.size() > 0) {
                        TimerHandler h2 = (TimerHandler)this.timerList.elementAt(0);
                        long waitTime = h2.atTime - sysTime;
                        if (waitTime > 0L) {
                            this.wait(waitTime);
                        }
                    } else {
                        this.wait();
                    }
                    continue;
                }
            }
            catch (InterruptedException e) {
                continue;
            }
            break;
        }
        return result;
    }

    private int serviceIdle() {
        int result = 0;
        int gen = this.idleGeneration++;
        while (this.idleList.size() > 0) {
            IdleHandler h = (IdleHandler)this.idleList.elementAt(0);
            if (h.generation > gen) break;
            this.idleList.removeElementAt(0);
            if (h.invoke() == 0) continue;
            result = 1;
        }
        return result;
    }
}

