/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Hashtable;
import tcl.lang.BeanEventMgr;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.ReflectObject;
import tcl.lang.TclException;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class JavaBindCmd
implements Command {
    BeanEventMgr eventMgr = null;
    private Hashtable beanInfoCache = new Hashtable();

    JavaBindCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2 || argv.length > 4) {
            throw new TclNumArgsException(interp, 1, argv, "javaObj ?eventName? ?command?");
        }
        ReflectObject robj = ReflectObject.getReflectObject(interp, argv[1]);
        if (this.eventMgr == null) {
            this.eventMgr = BeanEventMgr.getBeanEventMgr(interp);
        }
        if (argv.length == 2) {
            interp.setResult(this.eventMgr.getHandledEvents(robj));
        } else {
            Object[] arr = this.getEventMethod(interp, robj.javaObj, robj.javaClass, argv[2].toString());
            EventSetDescriptor eventDesc = (EventSetDescriptor)arr[0];
            if (!eventDesc.getListenerType().isInterface()) {
                throw new TclException(interp, "Cannot handle event listener: listererType \"" + eventDesc.getListenerType() + "\" is not an interface");
            }
            Method method2 = (Method)arr[1];
            if (argv.length == 3) {
                TclObject script = this.eventMgr.getBinding(interp, robj, eventDesc, method2);
                if (script != null) {
                    interp.setResult(script);
                } else {
                    interp.resetResult();
                }
            } else {
                this.eventMgr.setBinding(interp, robj, eventDesc, method2, argv[3]);
            }
        }
    }

    Object[] getEventMethod(Interp interp, Object obj, Class cls, String eventName) throws TclException {
        block10: {
            Method method2;
            EventSetDescriptor eventDesc;
            block11: {
                Method[] methods;
                int dotPos;
                EventSetDescriptor[] events;
                block12: {
                    BeanInfo beanInfo;
                    block9: {
                        eventDesc = null;
                        method2 = null;
                        try {
                            beanInfo = (BeanInfo)this.beanInfoCache.get(cls);
                            if (beanInfo != null) break block9;
                            beanInfo = Introspector.getBeanInfo(cls);
                            this.beanInfoCache.put(cls, beanInfo);
                        }
                        catch (IntrospectionException e) {
                            break block10;
                        }
                    }
                    events = beanInfo.getEventSetDescriptors();
                    if (events == null) break block10;
                    dotPos = eventName.lastIndexOf(46);
                    if (dotPos != -1) break block12;
                    for (int i = 0; i < events.length; ++i) {
                        Method[] methods2 = events[i].getListenerType().getMethods();
                        for (int j = 0; j < methods2.length; ++j) {
                            if (!methods2[j].getName().equals(eventName)) continue;
                            if (method2 == null) {
                                method2 = methods2[j];
                                eventDesc = events[i];
                                continue;
                            }
                            throw new TclException(interp, "ambiguous event \"" + eventName + "\"");
                        }
                    }
                    break block11;
                }
                String evtCls = eventName.substring(0, dotPos);
                String evtMethod = eventName.substring(dotPos + 1);
                for (int i = 0; i < events.length; ++i) {
                    Class<?> lsnType = events[i].getListenerType();
                    if (!evtCls.equals(lsnType.getName())) continue;
                    eventDesc = events[i];
                    break;
                }
                if (eventDesc != null && (methods = eventDesc.getListenerType().getMethods()) != null) {
                    for (int j = 0; j < methods.length; ++j) {
                        if (!methods[j].getName().equals(evtMethod)) continue;
                        method2 = methods[j];
                        break block11;
                    }
                }
                break block10;
            }
            if (method2 != null) {
                Object[] arr = new Object[]{eventDesc, method2};
                return arr;
            }
        }
        throw new TclException(interp, "unknown event \"" + eventName + "\"");
    }
}

