/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.StrtoulResult;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class FormatCmd
implements Command {
    private static final int LEFT_JUSTIFY = 1;
    private static final int SHOW_SIGN = 2;
    private static final int SPACE_OR_SIGN = 4;
    private static final int PAD_W_ZERO = 8;
    private static final int ALT_OUTPUT = 16;
    private static final int SIGNED_VALUE = 32;
    private static final int RADIX = 1;
    private static final int FLOAT = 2;
    private static final int EXP = 3;
    private static final int GENERIC = 4;

    FormatCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "formatString ?arg arg ...?");
        }
        int argIndex = 2;
        int fmtIndex = 0;
        boolean gotSequential = false;
        boolean gotXpg = false;
        char[] format = argv[1].toString().toCharArray();
        StringBuffer sbuf = new StringBuffer();
        while (fmtIndex < format.length) {
            int intValue;
            StrtoulResult stoul;
            int width = 0;
            int phase = 0;
            int fmtFlags = 0;
            boolean noPercent = true;
            boolean useShort = false;
            boolean precisionSet = false;
            boolean xpgSet = false;
            int precision = -1;
            if (format[fmtIndex] != '%') {
                int i;
                for (i = fmtIndex; i < format.length; ++i) {
                    if (format[i] != '%') continue;
                    noPercent = false;
                    break;
                }
                sbuf.append(new String(format, fmtIndex, i - fmtIndex));
                fmtIndex = i;
                if (noPercent) break;
            }
            if (fmtIndex + 1 >= format.length) {
                FormatCmd.errorEndMiddle(interp);
            }
            FormatCmd.checkOverFlow(interp, format, fmtIndex + 1);
            if (format[fmtIndex + 1] == '%') {
                sbuf.append("%");
                fmtIndex += 2;
                continue;
            }
            FormatCmd.checkOverFlow(interp, format, ++fmtIndex);
            if (Character.isDigit(format[fmtIndex])) {
                stoul = this.strtoul(format, fmtIndex);
                intValue = (int)stoul.value;
                int endIndex = stoul.index;
                if (format[endIndex] == '$') {
                    if (intValue == 0) {
                        FormatCmd.errorBadIndex(interp, true);
                    }
                    if (gotSequential) {
                        FormatCmd.errorMixedXPG(interp);
                    }
                    gotXpg = true;
                    xpgSet = true;
                    phase = 2;
                    fmtIndex = endIndex + 1;
                    argIndex = intValue + 1;
                    if (argIndex < 2 || argIndex >= argv.length) {
                        FormatCmd.errorBadIndex(interp, gotXpg);
                    }
                } else {
                    if (gotXpg) {
                        FormatCmd.errorMixedXPG(interp);
                    }
                    gotSequential = true;
                    if (format[fmtIndex] != '0') {
                        fmtIndex = endIndex;
                        width = intValue;
                        phase = 4;
                    }
                }
            } else {
                if (gotXpg) {
                    FormatCmd.errorMixedXPG(interp);
                }
                gotSequential = true;
            }
            if (phase < 3) {
                FormatCmd.checkOverFlow(interp, format, fmtIndex);
                char ch = format[fmtIndex];
                boolean cont = true;
                while (cont) {
                    switch (ch) {
                        case '-': {
                            fmtFlags |= 1;
                            break;
                        }
                        case '#': {
                            fmtFlags |= 0x10;
                            break;
                        }
                        case '0': {
                            fmtFlags |= 8;
                            break;
                        }
                        case ' ': {
                            fmtFlags |= 4;
                            break;
                        }
                        case '+': {
                            fmtFlags |= 2;
                            break;
                        }
                        default: {
                            cont = false;
                        }
                    }
                    if (!cont) continue;
                    FormatCmd.checkOverFlow(interp, format, ++fmtIndex);
                    ch = format[fmtIndex];
                }
                phase = 3;
            }
            FormatCmd.checkOverFlow(interp, format, fmtIndex);
            if (Character.isDigit(format[fmtIndex])) {
                stoul = this.strtoul(format, fmtIndex);
                width = (int)stoul.value;
                fmtIndex = stoul.index;
            } else if (format[fmtIndex] == '*' && argv.length > argIndex) {
                width = TclInteger.get(interp, argv[argIndex]);
                if (width < 0) {
                    width = -width;
                    fmtFlags |= 1;
                }
                ++argIndex;
                ++fmtIndex;
            }
            FormatCmd.checkOverFlow(interp, format, fmtIndex);
            if (format[fmtIndex] == '.') {
                FormatCmd.checkOverFlow(interp, format, ++fmtIndex);
                if (Character.isDigit(format[fmtIndex])) {
                    precisionSet = true;
                    stoul = this.strtoul(format, fmtIndex);
                    precision = (int)stoul.value;
                    fmtIndex = stoul.index;
                } else if (format[fmtIndex] == '*') {
                    if (argv.length > argIndex) {
                        precisionSet = true;
                        precision = TclInteger.get(interp, argv[argIndex]);
                        ++argIndex;
                        FormatCmd.checkOverFlow(interp, format, ++fmtIndex);
                    }
                } else {
                    FormatCmd.errorBadField(interp, format[fmtIndex]);
                }
            }
            if (format[fmtIndex] == 'h') {
                FormatCmd.checkOverFlow(interp, format, ++fmtIndex);
                useShort = true;
            } else if (format[fmtIndex] == 'l') {
                FormatCmd.checkOverFlow(interp, format, ++fmtIndex);
            }
            if (argIndex < 2 || argIndex >= argv.length) {
                FormatCmd.errorBadIndex(interp, gotXpg);
            }
            String strValue = "";
            char index = format[fmtIndex];
            switch (index) {
                case 'X': 
                case 'd': 
                case 'i': 
                case 'o': 
                case 'u': 
                case 'x': {
                    long lngValue;
                    if (index == 'u') {
                        lngValue = TclInteger.get(interp, argv[argIndex]);
                        if (lngValue < 0L) {
                            lngValue <<= 32;
                            lngValue >>>= 32;
                        }
                    } else {
                        fmtFlags |= 0x20;
                        lngValue = TclInteger.get(interp, argv[argIndex]);
                    }
                    if (useShort) {
                        lngValue <<= 48;
                        lngValue >>= 48;
                    }
                    if (index == 'o') {
                        sbuf.append(this.cvtLngToStr(lngValue, width, precision, fmtFlags, 8, "01234567".toCharArray(), "0"));
                        break;
                    }
                    if (index == 'x') {
                        sbuf.append(this.cvtLngToStr(lngValue, width, precision, fmtFlags, 16, "0123456789abcdef".toCharArray(), "0x"));
                        break;
                    }
                    if (index == 'X') {
                        sbuf.append(this.cvtLngToStr(lngValue, width, precision, fmtFlags, 16, "0123456789ABCDEF".toCharArray(), "0X"));
                        break;
                    }
                    sbuf.append(this.cvtLngToStr(lngValue, width, precision, fmtFlags, 10, "0123456789".toCharArray(), ""));
                    break;
                }
                case 'c': {
                    intValue = 0;
                    char[] arr = new char[]{(char)TclInteger.get(interp, argv[argIndex])};
                    strValue = new String(arr);
                    sbuf.append(FormatCmd.cvtStrToStr(strValue, width, precision, fmtFlags));
                    break;
                }
                case 's': {
                    strValue = argv[argIndex].toString();
                    sbuf.append(FormatCmd.cvtStrToStr(strValue, width, precision, fmtFlags));
                    break;
                }
                case 'f': {
                    double dblValue = TclDouble.get(interp, argv[argIndex]);
                    sbuf.append(FormatCmd.cvtDblToStr(dblValue, width, precision, fmtFlags, 10, "0123456789".toCharArray(), "", 2));
                    break;
                }
                case 'e': {
                    double dblValue = TclDouble.get(interp, argv[argIndex]);
                    sbuf.append(FormatCmd.cvtDblToStr(dblValue, width, precision, fmtFlags, 10, "e".toCharArray(), "", 3));
                    break;
                }
                case 'E': {
                    double dblValue = TclDouble.get(interp, argv[argIndex]);
                    sbuf.append(FormatCmd.cvtDblToStr(dblValue, width, precision, fmtFlags, 10, "E".toCharArray(), "", 3));
                    break;
                }
                case 'g': {
                    double dblValue = TclDouble.get(interp, argv[argIndex]);
                    sbuf.append(FormatCmd.cvtDblToStr(dblValue, width, precision, fmtFlags, 10, "e".toCharArray(), "", 4));
                    break;
                }
                case 'G': {
                    double dblValue = TclDouble.get(interp, argv[argIndex]);
                    sbuf.append(FormatCmd.cvtDblToStr(dblValue, width, precision, fmtFlags, 10, "E".toCharArray(), "", 4));
                    break;
                }
                default: {
                    FormatCmd.errorBadField(interp, format[fmtIndex]);
                }
            }
            ++fmtIndex;
            ++argIndex;
        }
        interp.setResult(sbuf.toString());
    }

    private String cvtLngToStr(long lngValue, int width, int precision, int flags, int base, char[] charSet, String altPrefix) {
        int nspace;
        int i;
        StringBuffer sbuf = new StringBuffer(100);
        StringBuffer tmpBuf = new StringBuffer(0).append("");
        int prefixSize = 0;
        char prefix = '\u0000';
        if (lngValue == 0L) {
            flags |= 0x10;
        }
        if ((flags & 0x20) != 0) {
            if (lngValue < 0L) {
                if (altPrefix.length() > 0) {
                    lngValue <<= 32;
                    lngValue >>>= 32;
                } else {
                    lngValue = -lngValue;
                    prefix = '-';
                    prefixSize = 1;
                }
            } else if ((flags & 2) != 0) {
                prefix = '+';
                prefixSize = 1;
            } else if ((flags & 4) != 0) {
                prefix = ' ';
                prefixSize = 1;
            }
        }
        if ((8 & flags) != 0 && precision < width - prefixSize) {
            precision = width - prefixSize;
        }
        do {
            sbuf.insert(0, charSet[(int)(lngValue % (long)base)]);
        } while ((lngValue /= (long)base) > 0L);
        int length = sbuf.length();
        for (i = precision - length; i > 0; --i) {
            sbuf.insert(0, '0');
        }
        if (prefix != '\u0000') {
            sbuf.insert(0, prefix);
        }
        if ((flags & 0x10) != 0 && altPrefix.length() > 0 && sbuf.charAt(0) != altPrefix.charAt(0)) {
            sbuf.insert(0, altPrefix);
        }
        if ((nspace = width - sbuf.length()) > 0) {
            tmpBuf = new StringBuffer(nspace);
            for (i = 0; i < nspace; ++i) {
                tmpBuf.append(" ");
            }
        }
        if ((1 & flags) != 0) {
            return sbuf.toString() + tmpBuf.toString();
        }
        return tmpBuf.toString() + sbuf.toString();
    }

    static String toString(double dblValue, int precision, int base) {
        return FormatCmd.cvtDblToStr(dblValue, 0, precision, 0, base, "e".toCharArray(), null, 4);
    }

    private static String cvtDblToStr(double dblValue, int width, int precision, int flags, int base, char[] charSet, String altPrefix, int xtype) {
        int length;
        int digit;
        StringBuffer sbuf = new StringBuffer(100);
        int prefixSize = 0;
        char prefix = '\u0000';
        boolean flag_exp = false;
        boolean flag_rtz = true;
        boolean flag_dp = true;
        if (Double.isNaN(dblValue)) {
            return "NaN";
        }
        if (dblValue == Double.NEGATIVE_INFINITY) {
            return "-Inf";
        }
        if (dblValue == Double.POSITIVE_INFINITY) {
            return "Inf";
        }
        if (precision < 0) {
            precision = 6;
        }
        if (dblValue < 0.0) {
            dblValue = -dblValue;
            prefix = '-';
            prefixSize = 1;
        } else if (dblValue == 0.0 && new Double(dblValue).equals(new Double(-0.0))) {
            dblValue = -dblValue;
            prefix = '-';
            prefixSize = 1;
        } else if ((flags & 2) != 0) {
            prefix = '+';
            prefixSize = 1;
        } else if ((flags & 4) != 0) {
            prefix = ' ';
            prefixSize = 1;
        }
        if (xtype == 4 && precision > 0) {
            --precision;
        }
        int i = precision;
        double rounder = 0.4999;
        while (i > 0) {
            --i;
            rounder *= 0.1;
        }
        if (xtype == 2) {
            dblValue += rounder;
        }
        int exp = 0;
        if (dblValue > 0.0) {
            int k = 0;
            while (dblValue >= 1.0E8 && k++ < 100) {
                dblValue *= 1.0E-8;
                exp += 8;
            }
            while (dblValue >= 10.0 && k++ < 100) {
                dblValue *= 0.1;
                ++exp;
            }
            while (dblValue < 1.0E-8 && k++ < 100) {
                dblValue *= 1.0E8;
                exp -= 8;
            }
            while (dblValue < 1.0 && k++ < 100) {
                dblValue *= 10.0;
                --exp;
            }
            if (k >= 100) {
                return "NaN";
            }
        }
        boolean bl = flag_exp = xtype == 3;
        if (xtype != 2 && (dblValue += rounder) >= 10.0) {
            dblValue *= 0.1;
            ++exp;
        }
        if (xtype == 4) {
            boolean bl2 = flag_rtz = (flags & 0x10) == 0;
            if (exp < -4 || exp > precision) {
                xtype = 3;
            } else {
                precision -= exp;
                xtype = 2;
            }
        } else {
            flag_rtz = false;
        }
        int count = 0;
        if (xtype == 2) {
            boolean bl3 = flag_dp = precision > 0 || (flags & 0x10) != 0;
            if (prefixSize > 0) {
                sbuf.append(prefix);
            }
            if (exp < 0) {
                sbuf.append('0');
            }
            while (exp >= 0) {
                if (count++ >= 16) {
                    sbuf.append('0');
                } else {
                    digit = (int)dblValue;
                    dblValue = (dblValue - (double)digit) * 10.0;
                    sbuf.append(digit);
                }
                --exp;
            }
            if (flag_dp) {
                sbuf.append('.');
            }
            ++exp;
            while (exp < 0 && precision > 0) {
                sbuf.append('0');
                --precision;
                ++exp;
            }
            while (precision-- > 0) {
                if (count++ >= 16) {
                    sbuf.append('0');
                    continue;
                }
                digit = (int)dblValue;
                dblValue = (dblValue - (double)digit) * 10.0;
                sbuf.append(digit);
            }
            if (flag_rtz && flag_dp) {
                int index = 0;
                int len = 0;
                len = sbuf.length() - 1;
                index = 0;
                while (len >= 0 && sbuf.charAt(len) == '0') {
                    --len;
                    ++index;
                }
                if (len >= 0 && sbuf.charAt(len) == '.') {
                    ++index;
                }
                if (index > 0) {
                    sbuf = new StringBuffer(sbuf.toString().substring(0, sbuf.length() - index));
                }
            }
        } else {
            boolean bl4 = flag_dp = precision > 0 || (flags & 0x10) != 0;
            if (prefixSize > 0) {
                sbuf.append(prefix);
            }
            digit = (int)dblValue;
            dblValue = (dblValue - (double)digit) * 10.0;
            sbuf.append(digit);
            if (flag_dp) {
                sbuf.append('.');
            }
            while (precision-- > 0) {
                if (count++ >= 16) {
                    sbuf.append('0');
                    continue;
                }
                digit = (int)dblValue;
                dblValue = (dblValue - (double)digit) * 10.0;
                sbuf.append(digit);
            }
            if (flag_rtz && flag_dp) {
                i = 0;
                length = sbuf.length() - 1;
                while (length >= 0 && sbuf.charAt(length) == '0') {
                    --length;
                    ++i;
                }
                if (length >= 0 && sbuf.charAt(length) == '.') {
                    ++i;
                }
                if (i > 0) {
                    sbuf = new StringBuffer(sbuf.toString().substring(0, sbuf.length() - i));
                }
            }
            if (exp != 0 || flag_exp) {
                sbuf.append(charSet[0]);
                if (exp < 0) {
                    sbuf.append('-');
                    exp = -exp;
                } else {
                    sbuf.append('+');
                }
                if (exp >= 100) {
                    sbuf.append(exp / 100);
                    exp %= 100;
                }
                sbuf.append(exp / 10);
                sbuf.append(exp % 10);
            }
        }
        length = sbuf.length();
        if ((8 & flags) != 0 && (1 & flags) == 0) {
            int nPad = width - length;
            i = prefixSize;
            while (nPad-- > 0) {
                sbuf.insert(prefixSize, '0');
            }
            length = width;
        }
        int nspace = width - length;
        StringBuffer tmpBuf = new StringBuffer(0).append("");
        if (nspace > 0) {
            tmpBuf = new StringBuffer(nspace);
            for (i = 0; i < nspace; ++i) {
                tmpBuf.append(" ");
            }
        }
        if ((1 & flags) != 0) {
            return sbuf.toString() + tmpBuf.toString();
        }
        return tmpBuf.toString() + sbuf.toString();
    }

    private static String cvtStrToStr(String strValue, int width, int precision, int flags) {
        String left = "";
        String right = "";
        if (precision < 0) {
            precision = 0;
        }
        if (precision != 0 && precision < strValue.length()) {
            strValue = strValue.substring(0, precision);
        }
        if (width > strValue.length()) {
            StringBuffer sbuf = new StringBuffer();
            int index = width - strValue.length();
            for (int i = 0; i < index; ++i) {
                if ((flags & 8) != 0) {
                    sbuf.append('0');
                    continue;
                }
                sbuf.append(' ');
            }
            if ((1 & flags) != 0) {
                right = sbuf.toString();
            } else {
                left = sbuf.toString();
            }
        }
        return left + strValue + right;
    }

    private StrtoulResult strtoul(char[] arr, int endIndex) {
        int orgIndex = endIndex;
        while (endIndex < arr.length && Character.isDigit(arr[endIndex])) {
            ++endIndex;
        }
        return new StrtoulResult(Long.parseLong(new String(arr, orgIndex, endIndex - orgIndex)), endIndex, 0);
    }

    private static void checkOverFlow(Interp interp, char[] arr, int index) throws TclException {
        if (index >= arr.length || index < 0) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
    }

    private static void errorMixedXPG(Interp interp) throws TclException {
        throw new TclException(interp, "cannot mix \"%\" and \"%n$\" conversion specifiers");
    }

    private static void errorBadIndex(Interp interp, boolean gotXpg) throws TclException {
        if (gotXpg) {
            throw new TclException(interp, "\"%n$\" argument index out of range");
        }
        throw new TclException(interp, "not enough arguments for all format specifiers");
    }

    private static void errorBadField(Interp interp, char fieldSpecifier) throws TclException {
        throw new TclException(interp, "bad field specifier \"" + fieldSpecifier + "\"");
    }

    private static void errorEndMiddle(Interp interp) throws TclException {
        throw new TclException(interp, "format string ended in middle of field specifier");
    }
}

