/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.IOException;
import java.util.Vector;
import tcl.lang.AssocData;
import tcl.lang.Channel;
import tcl.lang.IdleHandler;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.Parser;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclObject;
import tcl.lang.TclString;

class BgErrorMgr
implements AssocData {
    Interp interp;
    TclObject bgerrorCmdObj;
    Vector errors = new Vector();

    BgErrorMgr(Interp i) {
        this.interp = i;
        this.bgerrorCmdObj = TclString.newInstance("bgerror");
        this.bgerrorCmdObj.preserve();
        this.errors = new Vector();
    }

    void addBgError() {
        BgError bgErr = new BgError(this.interp.getNotifier());
        this.interp.addErrorInfo("");
        bgErr.errorMsg = this.interp.getResult();
        bgErr.errorInfo = null;
        try {
            bgErr.errorInfo = this.interp.getVar("errorInfo", null, 1);
        }
        catch (TclException e) {
            // empty catch block
        }
        bgErr.errorCode = null;
        try {
            bgErr.errorCode = this.interp.getVar("errorCode", null, 1);
        }
        catch (TclException tclException) {
            // empty catch block
        }
        bgErr.errorMsg.preserve();
        bgErr.errorInfo.preserve();
        bgErr.errorCode.preserve();
        this.errors.addElement(bgErr);
    }

    public void disposeAssocData(Interp interp) {
        for (int i = this.errors.size() - 1; i >= 0; --i) {
            BgError bgErr = (BgError)this.errors.elementAt(i);
            this.errors.removeElementAt(i);
            bgErr.cancel();
            bgErr.errorMsg.release();
            bgErr.errorMsg = null;
            bgErr.errorInfo.release();
            bgErr.errorInfo = null;
            bgErr.errorCode.release();
            bgErr.errorCode = null;
        }
        this.bgerrorCmdObj.release();
        this.bgerrorCmdObj = null;
    }

    class BgError
    extends IdleHandler {
        TclObject errorMsg;
        TclObject errorCode;
        TclObject errorInfo;

        BgError(Notifier n) {
            super(n);
        }

        public void processIdleEvent() {
            BgErrorMgr.this.errors.removeElement(this);
            try {
                BgErrorMgr.this.interp.setVar("errorInfo", null, this.errorInfo, 1);
            }
            catch (TclException e) {
                // empty catch block
            }
            try {
                BgErrorMgr.this.interp.setVar("errorCode", null, this.errorCode, 1);
            }
            catch (TclException e) {
                // empty catch block
            }
            BgErrorMgr.this.interp.preserve();
            try {
                TclObject[] argv = new TclObject[]{BgErrorMgr.this.bgerrorCmdObj, this.errorMsg};
                Parser.evalObjv(BgErrorMgr.this.interp, argv, 0, 131072);
            }
            catch (TclException e) {
                switch (e.getCompletionCode()) {
                    case 1: {
                        try {
                            Channel chan = TclIO.getStdChannel(2);
                            if (BgErrorMgr.this.interp.getResult().toString().equals("\"bgerror\" is an invalid command name or ambiguous abbreviation")) {
                                chan.write(BgErrorMgr.this.interp, this.errorInfo);
                                chan.write(BgErrorMgr.this.interp, "\n");
                            } else {
                                chan.write(BgErrorMgr.this.interp, "bgerror failed to handle background error.\n");
                                chan.write(BgErrorMgr.this.interp, "    Original error: ");
                                chan.write(BgErrorMgr.this.interp, this.errorMsg);
                                chan.write(BgErrorMgr.this.interp, "\n");
                                chan.write(BgErrorMgr.this.interp, "    Error in bgerror: ");
                                chan.write(BgErrorMgr.this.interp, BgErrorMgr.this.interp.getResult());
                                chan.write(BgErrorMgr.this.interp, "\n");
                            }
                            chan.flush(BgErrorMgr.this.interp);
                        }
                        catch (TclException e1) {
                        }
                        catch (IOException e2) {}
                        break;
                    }
                    case 3: {
                        for (int i = BgErrorMgr.this.errors.size() - 1; i >= 0; --i) {
                            BgError bgErr = (BgError)BgErrorMgr.this.errors.elementAt(i);
                            BgErrorMgr.this.errors.removeElementAt(i);
                            bgErr.cancel();
                            bgErr.errorMsg.release();
                            bgErr.errorMsg = null;
                            bgErr.errorInfo.release();
                            bgErr.errorInfo = null;
                            bgErr.errorCode.release();
                            bgErr.errorCode = null;
                        }
                        break;
                    }
                }
            }
            BgErrorMgr.this.interp.release();
            this.errorMsg.release();
            this.errorMsg = null;
            this.errorInfo.release();
            this.errorInfo = null;
            this.errorCode.release();
            this.errorCode = null;
        }
    }
}

