/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.utilities;

import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.BasicNotifierImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.wst.common.internal.emf.utilities.DanglingHREFException;
import org.eclipse.wst.common.internal.emf.utilities.IsLoadingProxyAdapter;
import org.eclipse.wst.common.internal.emf.utilities.WFTUtilsResourceHandler;

public class ExtendedEcoreUtil
extends EcoreUtil {
    private static FileNotFoundDetector FILE_NOT_FOUND_DETECTOR;
    private static String NAME_ATTRIBUTE_STRING;

    public static void setFileNotFoundDetector(FileNotFoundDetector detector) {
        FILE_NOT_FOUND_DETECTOR = detector;
    }

    public static FileNotFoundDetector getFileNotFoundDetector() {
        if (FILE_NOT_FOUND_DETECTOR == null) {
            FILE_NOT_FOUND_DETECTOR = new FileNotFoundDetector(){

                public boolean isFileNotFound(WrappedException wrappedEx) {
                    return ExtendedEcoreUtil.getInnerFileNotFoundException(wrappedEx) != null;
                }
            };
        }
        return FILE_NOT_FOUND_DETECTOR;
    }

    public static FileNotFoundException getInnerFileNotFoundException(WrappedException wrappedEx) {
        if (wrappedEx.exception() instanceof FileNotFoundException) {
            return (FileNotFoundException)wrappedEx.exception();
        }
        if (wrappedEx.exception() instanceof WrappedException) {
            return ExtendedEcoreUtil.getInnerFileNotFoundException((WrappedException)wrappedEx.exception());
        }
        return null;
    }

    public static void eSetOrAdd(EObject obj, EStructuralFeature feature, Object value) {
        ExtendedEcoreUtil.eSetOrAdd(obj, feature, value, 0);
    }

    public static void eSetOrAdd(EObject obj, EStructuralFeature feature, Object value, int newIndex) {
        if (feature.isMany() && value != null) {
            List targetList = (List)obj.eGet(feature);
            if (newIndex >= 0) {
                int targetSize = targetList.size();
                if (newIndex <= targetSize) {
                    targetList.add(newIndex, value);
                } else {
                    targetList.add(value);
                }
            } else {
                targetList.add(value);
            }
        } else {
            obj.eSet(feature, value);
        }
    }

    public static void eUnsetOrRemove(EObject obj, EStructuralFeature feature, Object value) {
        if (feature == null || feature.isMany()) {
            ((List)obj.eGet(feature)).remove(value);
        } else {
            obj.eUnset(feature);
        }
    }

    public static boolean endsWith(URI sourceUri, URI testUri) {
        String[] testSegments;
        int i;
        String[] sourceSegments = sourceUri.segments();
        int j = sourceSegments.length;
        if (j >= (i = (testSegments = testUri.segments()).length)) {
            boolean test = true;
            while (test && i > 0) {
                test = testSegments[--i].equals(sourceSegments[--j]);
            }
            return test;
        }
        return false;
    }

    public static String getName(EObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof ENamedElement) {
            return ((ENamedElement)obj).getName();
        }
        EList allAtts = obj.eClass().getEAllAttributes();
        int size = allAtts.size();
        EAttribute nameAttribute = null;
        for (int i = 0; i < size; ++i) {
            EAttribute att = (EAttribute)allAtts.get(i);
            if (!NAME_ATTRIBUTE_STRING.equals(att.getName())) continue;
            nameAttribute = att;
            break;
        }
        if (nameAttribute != null) {
            return (String)obj.eGet(nameAttribute);
        }
        return null;
    }

    public static void addLoadingTag(Resource resource) {
    }

    public static void removeLoadingTag(Resource resource) {
    }

    public static boolean isLoading(Resource resource) {
        return resource != null ? ((Resource.Internal)resource).isLoading() : false;
    }

    public static Adapter createAdapterForLoading(Adapter targetAdapter, EObject targetObject) {
        Resource res = targetObject.eResource();
        if (res == null || ExtendedEcoreUtil.isLoading(res)) {
            return new IsLoadingProxyAdapter(targetAdapter, targetObject);
        }
        return targetAdapter;
    }

    public static void preRegisterPackage(String nsPrefix, EPackage.Descriptor descriptor) {
        if (!EPackage.Registry.INSTANCE.containsKey(nsPrefix)) {
            EPackage.Registry.INSTANCE.put(nsPrefix, descriptor);
        }
    }

    public static Adapter getAdapter(EObject anObject, List adapters, Object type) {
        Object[] adaptArray = ((BasicNotifierImpl.EAdapterList)adapters).data();
        if (adaptArray == null) {
            return null;
        }
        for (int i = 0; i < adaptArray.length; ++i) {
            Adapter adapter = (Adapter)adaptArray[i];
            if (adapter == null || !adapter.isAdapterForType(type)) continue;
            return adapter;
        }
        return null;
    }

    public static void unload(EObject root) {
        Resource res = root.eResource();
        EObject container = root.eContainer();
        if (root != null && res != null) {
            ExtendedEcoreUtil.becomeProxy(root, res);
        }
        if (container == null) {
            if (res != null) {
                res.getContents().remove(root);
            } else {
                EReference feature = root.eContainmentFeature();
                if (feature != null) {
                    ExtendedEcoreUtil.eUnsetOrRemove(container, feature, root);
                }
            }
        }
    }

    public static void becomeProxy(EObject root, Resource res) {
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            ExtendedEcoreUtil.doBecomeProxy((InternalEObject)iter.next(), res);
        }
        ExtendedEcoreUtil.doBecomeProxy((InternalEObject)root, res);
    }

    protected static void doBecomeProxy(InternalEObject p, Resource res) {
        String id = res.getURIFragment(p);
        p.eSetProxyURI(res.getURI().appendFragment(id));
        if (res instanceof XMLResource) {
            ((XMLResource)res).setID(p, null);
        }
        p.eAdapters().clear();
    }

    public static void removeProxy(EObject root, Resource res) {
        TreeIterator iter = root.eAllContents();
        while (iter.hasNext()) {
            ExtendedEcoreUtil.doRemoveProxy((InternalEObject)iter.next(), res);
        }
        ExtendedEcoreUtil.doRemoveProxy((InternalEObject)root, res);
    }

    protected static void doRemoveProxy(InternalEObject p, Resource res) {
        String id = p.eProxyURI().fragment();
        if (res instanceof XMLResource) {
            ((XMLResource)res).setID(p, id);
        }
        p.eSetProxyURI(null);
    }

    public static void checkProxy(EObject object) throws DanglingHREFException {
        if (object == null || !object.eIsProxy()) {
            return;
        }
        String msg = WFTUtilsResourceHandler.getString(WFTUtilsResourceHandler.DANGLING_HREF_ERROR_, new Object[]{((InternalEObject)object).eProxyURI()});
        throw new DanglingHREFException(msg);
    }

    public static boolean valueChanged(Object o1, Object o2) {
        return o1 == null ^ o2 == null || o1 == null || !o1.equals(o2);
    }

    static {
        NAME_ATTRIBUTE_STRING = "name";
    }

    public static interface FileNotFoundDetector {
        public boolean isFileNotFound(WrappedException var1);
    }
}

