/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.xml.sax.InputSource;

public class EntityWidget {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = EntityWidget.class.getName();
    public static final String LOCAL_ARCHIVE_SCHEME = "localarchive";
    public static final String LOCAL_ARCHIVE_SCHEME_PREFIX = "localarchive:////";

    public static URI createLocalArchiveURI(URI uri) {
        if (uri.scheme() == null) {
            uri = URI.createURI(LOCAL_ARCHIVE_SCHEME_PREFIX + uri.toString());
        }
        return uri;
    }

    public static InputSource resolveLocalEntity(String publicId, String systemId, ResourceSet resourceSet) throws IOException {
        String methodName = "resolveLocalEntity";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER");
            logger.logp(Level.FINER, CLASS_NAME, methodName, "  Public ID [ {0} ]", publicId);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "  System ID [ {0} ]", systemId);
        }
        if (!systemId.startsWith(LOCAL_ARCHIVE_SCHEME_PREFIX)) {
            return null;
        }
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Local archive scheme detected [ {0} ]", LOCAL_ARCHIVE_SCHEME_PREFIX);
        String useSystemId = systemId.substring(LOCAL_ARCHIVE_SCHEME_PREFIX.length());
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Stripped system ID [ {0} ]", useSystemId);
        URI systemURI = URI.createURI(useSystemId);
        InputStream resourceStream = resourceSet.getURIConverter().createInputStream(systemURI);
        InputSource resourceSource = new InputSource(resourceStream);
        resourceSource.setPublicId(publicId);
        resourceSource.setSystemId(systemId);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "RETURN");
        return resourceSource;
    }
}

