/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.util.Arrays;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jst.j2ee.ejb.EjbPackage;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.model.internal.validation.ITypeConstants;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;
import org.eclipse.jst.j2ee.model.internal.validation.ValidationRuleUtility;

public final class ClassUtility {
    public static long supertype_counter = 1L;
    private long[] _classTypeIndex;
    private AClassType[] _classNames;
    private static ClassUtility _inst = null;

    private ClassUtility() {
        this.buildTypeList();
    }

    public static ClassUtility getUtility() {
        if (_inst == null) {
            _inst = new ClassUtility();
        }
        return _inst;
    }

    public boolean isClassType(EnterpriseBean bean, JavaClass clazz, long type) throws InvalidInputException {
        AClassType ct = this.getClassType(type);
        if (ct == null) {
            return false;
        }
        return ct.equals(bean, clazz);
    }

    public String getClassName(EnterpriseBean bean, long type) throws InvalidInputException {
        AClassType ct = this.getClassType(type);
        if (ct == null) {
            return null;
        }
        return ct.getName(bean);
    }

    public AClassType getClassType(long type) {
        int index = Arrays.binarySearch(this._classTypeIndex, type);
        if (index > this._classNames.length) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        if (this._classNames[index].getId() != type) {
            return null;
        }
        return this._classNames[index];
    }

    public JavaHelpers getSupertype(EnterpriseBean bean, long type) throws InvalidInputException {
        AClassType ct = this.getClassType(type);
        if (ct == null) {
            return null;
        }
        return ct.getClass(bean);
    }

    private void buildTypeList() {
        int typeCount = 12;
        this._classTypeIndex = new long[typeCount];
        this._classNames = new AClassType[typeCount];
        int count = 0;
        this._classTypeIndex[count] = ITypeConstants.LOCAL_COMPONENT_INTERFACE;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                JavaHelpers clazz = this.getClass(bean);
                if (clazz == null) {
                    return null;
                }
                return clazz.getQualifiedName();
            }

            public long getId() {
                return ITypeConstants.LOCAL_COMPONENT_INTERFACE;
            }

            public JavaHelpers getClass(EnterpriseBean bean) {
                if (bean == null) {
                    return null;
                }
                if (bean.eIsSet(EjbPackage.eINSTANCE.getEnterpriseBean_LocalInterface())) {
                    JavaClass result = bean.getLocalInterface();
                    try {
                        ValidationRuleUtility.isValidTypeHierarchy(bean, result);
                    }
                    catch (InvalidInputException e) {
                        return null;
                    }
                    return result;
                }
                return null;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.REMOTE_COMPONENT_INTERFACE;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                JavaHelpers clazz = this.getClass(bean);
                if (clazz == null) {
                    return null;
                }
                return clazz.getQualifiedName();
            }

            public long getId() {
                return ITypeConstants.REMOTE_COMPONENT_INTERFACE;
            }

            public JavaHelpers getClass(EnterpriseBean bean) {
                if (bean == null) {
                    return null;
                }
                if (bean.eIsSet(EjbPackage.eINSTANCE.getEnterpriseBean_RemoteInterface())) {
                    JavaClass result = bean.getRemoteInterface();
                    try {
                        ValidationRuleUtility.isValidTypeHierarchy(bean, result);
                    }
                    catch (InvalidInputException e) {
                        return null;
                    }
                    return result;
                }
                return null;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_ENTITYBEAN;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.EntityBean";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_ENTITYBEAN;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_EJBLOCALHOME;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.EJBLocalHome";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBLOCALHOME;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_EJBLOCALOBJECT;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.EJBLocalObject";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBLOCALOBJECT;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_EJBHOME;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.EJBHome";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBHOME;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_EJBOBJECT;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.EJBObject";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_EJBOBJECT;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVA_LANG_OBJECT;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "java.lang.Object";
            }

            public long getId() {
                return ITypeConstants.JAVA_LANG_OBJECT;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_MESSAGEDRIVENBEAN;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.MessageDrivenBean";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_MESSAGEDRIVENBEAN;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_JMS_MESSAGELISTENER;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.jms.MessageListener";
            }

            public long getId() {
                return ITypeConstants.JAVAX_JMS_MESSAGELISTENER;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_SESSIONBEAN;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.SessionBean";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_SESSIONBEAN;
            }
        };
        this._classTypeIndex[count] = ITypeConstants.JAVAX_EJB_SESSIONSYNCHRONIZATION;
        this._classNames[count++] = new AClassType(){

            public String getName(EnterpriseBean bean) {
                return "javax.ejb.SessionSynchronization";
            }

            public long getId() {
                return ITypeConstants.JAVAX_EJB_SESSIONSYNCHRONIZATION;
            }
        };
    }

    private abstract class AClassType {
        private AClassType() {
        }

        public abstract String getName(EnterpriseBean var1) throws InvalidInputException;

        public abstract long getId();

        public JavaHelpers getClass(EnterpriseBean bean) throws InvalidInputException {
            return ValidationRuleUtility.getType(this.getName(bean), bean);
        }

        public boolean equals(EnterpriseBean bean, JavaClass clazz) throws InvalidInputException {
            if (clazz == null) {
                return false;
            }
            JavaHelpers thisClass = this.getClass(bean);
            if (thisClass == null) {
                return false;
            }
            return clazz.equals(thisClass);
        }
    }
}

