/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ClientPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.AnnotationsProcessor;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ApplicationClientFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonarchivePackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.AnnotationsProcessorException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.DeploymentDescriptorLoadException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.ModuleFileImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class ApplicationClientFileImpl
extends ModuleFileImpl
implements ApplicationClientFile {
    protected ApplicationClient deploymentDescriptor = null;
    protected ApplicationClient mergedDeploymentDescriptor = null;
    private static final Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp", "commonarchive");
    private static final String className = ApplicationClientFileImpl.class.getName();

    protected String getDDObjectId() {
        return "Application-client_ID";
    }

    public boolean isGeneratedDD() {
        if (this.deploymentDescriptor == null) {
            this.getDeploymentDescriptor(false);
        }
        return super.isGeneratedDD();
    }

    protected EClass eStaticClass() {
        return CommonarchivePackage.Literals.APPLICATION_CLIENT_FILE;
    }

    public ApplicationClient getDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(false);
    }

    public ApplicationClient getDeploymentDescriptor(boolean mergeContent) throws DeploymentDescriptorLoadException {
        String methodName = "getDeploymentDescriptor";
        logger.logp(Level.FINER, className, methodName, "ENTRY URI [ {0} ]", this.getURI());
        logger.logp(Level.FINER, className, methodName, "mergeContent [ {0} ] ", mergeContent);
        if (mergeContent && this.mergedDeploymentDescriptor != null) {
            logger.logp(Level.FINER, className, methodName, "RETURN cached merged deployment descriptor [ {0} ]", this.mergedDeploymentDescriptor);
            return this.mergedDeploymentDescriptor;
        }
        ApplicationClient dd = this.getDeploymentDescriptorGen();
        if (dd == null && this.canLazyInitialize()) {
            try {
                this.getImportStrategy().importMetaData();
            }
            catch (Exception e) {
                throw new DeploymentDescriptorLoadException(this.getDeploymentDescriptorUri(), e);
            }
        }
        ApplicationClient appClientDD = this.getDeploymentDescriptorGen();
        appClientDD.storeJ2EEVersionID();
        if (mergeContent) {
            logger.logp(Level.FINER, className, "getDeploymentDescriptor", "appClientDD.isMetadataComplete() [ {0} ]", appClientDD.isMetadataComplete());
            logger.logp(Level.FINER, className, "getDeploymentDescriptor", "ApplicationClientFile.isAnnotationsSupported() [ {0} ]", this.isAnnotationsSupported());
            if (!appClientDD.isMetadataComplete() && this.isAnnotationsSupported()) {
                logger.logp(Level.FINER, className, "getDeploymentDescriptor", "Condition(s) for processing annotations passed.");
                this.mergedDeploymentDescriptor = (ApplicationClient)this.copyDeploymentDescriptor(appClientDD);
                this.mergedDeploymentDescriptor.storeJ2EEVersionID();
                this.processAnnotations(this.mergedDeploymentDescriptor);
                this.closeArchiveZipFile();
                logger.exiting(className, methodName, this.mergedDeploymentDescriptor);
                return this.mergedDeploymentDescriptor;
            }
            logger.logp(Level.FINER, className, "getDeploymentDescriptor", "Condition(s) for processing annotations did NOT pass.");
        }
        this.closeArchiveZipFile();
        logger.logp(Level.FINER, className, methodName, "RETURN Application Client File deployment descriptor [ {0} ]", appClientDD);
        return appClientDD;
    }

    private void processAnnotations(ApplicationClient appClientDD) throws AnnotationsException {
        AnnotationsProcessor processor;
        String methodName = "processAnnotations";
        logger.entering(className, methodName);
        try {
            processor = this.getAnnotationsProcessor();
        }
        catch (AnnotationsProcessorException ape) {
            logger.logp(Level.SEVERE, className, methodName, CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.Module_annotations_processor_load_failure_0, new Object[]{ape}));
            return;
        }
        MergeData mergeData = this.createMergeData(appClientDD);
        try {
            processor.merge(mergeData);
        }
        catch (Exception e) {
            this.processMergeException(e);
        }
        logger.exiting(className, methodName);
    }

    protected void cleanupOnClose() {
        String methodName = "cleanupOnClose";
        logger.logp(Level.FINER, className, methodName, "ENTRY/RETURN");
        this.mergedDeploymentDescriptor = null;
    }

    public String getDeploymentDescriptorUri() {
        return "META-INF/application-client.xml";
    }

    public int getNoDescriptorVersionID() {
        return 50;
    }

    public EObject getStandardDeploymentDescriptor() throws DeploymentDescriptorLoadException {
        return this.getStandardDeploymentDescriptor(true);
    }

    public EObject getStandardDeploymentDescriptor(boolean merge) throws DeploymentDescriptorLoadException {
        return this.getDeploymentDescriptor(merge);
    }

    public boolean isApplicationClientFile() {
        return true;
    }

    public boolean isDeploymentDescriptorSet() {
        return this.deploymentDescriptor != null;
    }

    public EObject makeDeploymentDescriptor(XMLResource resource) {
        ApplicationClient aClient = ((ClientPackage)EPackage.Registry.INSTANCE.getEPackage("client.xmi")).getClientFactory().createApplicationClient();
        resource.setID(aClient, "Application-client_ID");
        this.setDeploymentDescriptorGen(aClient);
        resource.getContents().add(aClient);
        return aClient;
    }

    public void setDeploymentDescriptor(ApplicationClient appClient) {
        String methodName = "setDeploymentDescriptor";
        if (ArchiveUtil.isMergedDD(appClient)) {
            logger.logp(Level.SEVERE, className, methodName, "An attempt was made to set the Deployment Descriptor on an Application Client Module to the merged form.");
            logger.throwing(className, methodName, new Exception());
        }
        this.setDeploymentDescriptorGen(appClient);
        this.replaceRoot(this.getMofResourceMakeIfNecessary(this.getDeploymentDescriptorUri()), appClient);
    }

    public ApplicationClient getDeploymentDescriptorGen() {
        if (this.deploymentDescriptor != null && this.deploymentDescriptor.eIsProxy()) {
            InternalEObject oldDeploymentDescriptor = (InternalEObject)((Object)this.deploymentDescriptor);
            this.deploymentDescriptor = (ApplicationClient)this.eResolveProxy(oldDeploymentDescriptor);
            if (this.deploymentDescriptor != oldDeploymentDescriptor && this.eNotificationRequired()) {
                this.eNotify(new ENotificationImpl((InternalEObject)this, 9, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
            }
        }
        return this.deploymentDescriptor;
    }

    public ApplicationClient basicGetDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptorGen(ApplicationClient newDeploymentDescriptor) {
        ApplicationClient oldDeploymentDescriptor = this.deploymentDescriptor;
        this.deploymentDescriptor = newDeploymentDescriptor;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldDeploymentDescriptor, (Object)this.deploymentDescriptor));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 9: {
                if (resolve) {
                    return this.getDeploymentDescriptor();
                }
                return this.basicGetDeploymentDescriptor();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor((ApplicationClient)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 9: {
                this.setDeploymentDescriptor(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 9: {
                return this.deploymentDescriptor != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public boolean isAnnotationsSupported() {
        int version = this.getSpecVersionID();
        return version >= 50;
    }

    public boolean requiresIterationOnSave() {
        if (this.mergedDeploymentDescriptor == null) {
            return false;
        }
        return this.mergedDeploymentDescriptor.isMetadataComplete();
    }
}

