/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveFactoryRegistry;
import org.eclipse.jst.j2ee.commonarchivecore.internal.CommonArchiveResourceHandler;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;

public class RepairArchiveCommand
extends AbstractCommand {
    protected Archive archive;
    protected static Map directoryNames;

    public RepairArchiveCommand(Archive anArchive) {
        super("Repair Archive", CommonArchiveResourceHandler.Repairs_all_entries_in_the);
        this.archive = anArchive;
        RepairArchiveCommand.getDirectoryNames();
    }

    public void execute() {
        EList files = this.archive.getFiles();
        block0: for (int i = 0; i < files.size(); ++i) {
            File aFile = (File)files.get(i);
            if (aFile.isArchive()) {
                new RepairArchiveCommand((Archive)aFile).execute();
                continue;
            }
            String upperUri = aFile.getURI().toUpperCase();
            Iterator keysAndValues = directoryNames.entrySet().iterator();
            while (keysAndValues.hasNext()) {
                String uri = aFile.getURI();
                Map.Entry entry = keysAndValues.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (!upperUri.startsWith(key) || uri.startsWith(value)) continue;
                String tail = uri.substring(key.length());
                aFile.setURI(value.concat(tail));
                continue block0;
            }
        }
    }

    protected static Map getDirectoryNames() {
        if (directoryNames == null) {
            directoryNames = new HashMap(6);
            directoryNames.put("META-INF".toUpperCase(), "META-INF");
            directoryNames.put("WEB-INF".toUpperCase(), "WEB-INF");
            directoryNames.put("WEB-INF/lib/".toUpperCase(), "WEB-INF/lib/");
            directoryNames.put("WEB-INF/classes/".toUpperCase(), "WEB-INF/classes/");
        }
        return directoryNames;
    }

    public Collection getResult() {
        return Arrays.asList(this.archive);
    }

    public static void main(String[] args) {
        if (!RepairArchiveCommand.validateArgs(args)) {
            return;
        }
        try {
            Archive anArchive = CommonArchiveFactoryRegistry.INSTANCE.getCommonArchiveFactory().primOpenArchive(args[0]);
            new RepairArchiveCommand(anArchive).execute();
            anArchive.saveAs(args[1]);
        }
        catch (Exception ex) {
            System.out.println(CommonArchiveResourceHandler.Repair_command_failed___ex_EXC_);
            ex.printStackTrace();
        }
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean validateArgs(String[] args) {
        if (args.length != 2) {
            Logger.getLogger().logError(CommonArchiveResourceHandler.RepairArchiveCommand_usage);
            return false;
        }
        java.io.File file = new java.io.File(args[0]);
        boolean isZip = false;
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
            isZip = true;
        }
        catch (IOException ex) {
            isZip = false;
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ex) {}
            }
        }
        if (!isZip && !file.isDirectory()) {
            System.out.println(CommonArchiveResourceHandler.RepairArchiveCommand_usage1_ERROR_);
            return false;
        }
        if (new java.io.File(args[1]).canWrite()) {
            System.out.println(CommonArchiveResourceHandler.getString(CommonArchiveResourceHandler.repair_usage_ERROR_, new Object[]{args[1]}));
            return false;
        }
        return true;
    }
}

