/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.common.internal.impl;

import java.math.BigDecimal;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.common.internal.impl.J2EEResourceEntityResolver;
import org.eclipse.jst.j2ee.internal.common.J2EEVersionResource;
import org.eclipse.jst.j2ee.internal.common.XMLResource;
import org.eclipse.jst.j2ee.internal.xml.J2EEXmlDtDEntityResolver;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;

public abstract class XMLResourceImpl
extends TranslatorResourceImpl
implements XMLResource,
J2EEVersionResource {
    public static final String CONFIG_WTP_LOGGER = "com.ibm.config.eclipse.wtp";
    public static Logger logger = Logger.getLogger("com.ibm.config.eclipse.wtp");
    public static final String CLASS_NAME = XMLResourceImpl.class.getName();
    protected boolean isNew = true;
    protected EntityResolver entityResolver = null;
    protected boolean isAlt = false;
    protected Application application;

    public XMLResourceImpl() {
    }

    public XMLResourceImpl(URI uri) {
        super(uri);
    }

    public XMLResourceImpl(Renderer aRenderer) {
        super(aRenderer);
    }

    public XMLResourceImpl(URI uri, Renderer aRenderer) {
        super(uri, aRenderer);
    }

    public EntityResolver getEntityResolver() {
        String methodName = "getEntityResolver";
        if (this.entityResolver == null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Constructing external entity aware entity resolver");
            this.entityResolver = new J2EEResourceEntityResolver(this.getResourceSet(), J2EEXmlDtDEntityResolver.INSTANCE);
            logger.logp(Level.FINER, CLASS_NAME, methodName, "Constructing external entity aware entity resolver of type [ {0} ]", this.entityResolver.getClass().getName());
        }
        return this.entityResolver;
    }

    public void setDefaults() {
        this.setModuleVersionID(this.getDefaultVersionID());
    }

    protected int getDefaultVersionID() {
        return this.getDefaultModuleVersionID();
    }

    protected int getDefaultModuleVersionID() {
        return 14;
    }

    public void setVersionID(int j2eeVersionId) {
        this.setJ2EEVersionID(j2eeVersionId);
    }

    public int getVersionID() {
        return this.getJ2EEVersionID();
    }

    public boolean isJ2EE1_3() {
        return this.getJ2EEVersionID() == 13;
    }

    protected void primSetVersionID(int moduleVersionId) {
        super.setVersionID(moduleVersionId);
    }

    public abstract void setJ2EEVersionID(int var1);

    public void unrecognizedJ2EEVersionID(String className, String methodName, int j2eeVersionId) {
        logger.logp(Level.WARNING, className, methodName, "Unrecognized J2EE version ID [ {0} ]", new Integer(j2eeVersionId));
    }

    public abstract int getJ2EEVersionID();

    public abstract void setModuleVersionID(int var1);

    public void unrecognizedModuleVersionID(String className, String methodName, int moduleVersionId) {
        logger.logp(Level.WARNING, className, methodName, "Unrecognized module version ID [ {0} ]", new Integer(moduleVersionId));
    }

    public int getModuleVersionID() {
        return super.getVersionID();
    }

    protected String getModuleVersionString() {
        int moduleVersionId = this.getModuleVersionID();
        if (moduleVersionId == 50) {
            return "5";
        }
        return new BigDecimal(String.valueOf(moduleVersionId)).movePointLeft(1).toString();
    }

    public void setPublicId(String publicId) {
        this.setDoctypeValues(publicId, this.getSystemId());
    }

    public void setSystemId(String systemId) {
        this.setDoctypeValues(this.getPublicId(), systemId);
    }

    public boolean usesDTD() {
        int j2eeVersionId = this.getJ2EEVersionID();
        return j2eeVersionId != 14 && j2eeVersionId != 50;
    }

    protected void primSetDoctypeValues(String aPublicId, String aSystemId) {
        super.setDoctypeValues(aPublicId, aSystemId);
    }

    public void setDoctypeValues(String publicId, String systemId) {
        if (publicId != null && systemId == null || publicId == null && systemId != null) {
            logger.logp(Level.WARNING, CLASS_NAME, "setDoctypeValue", "Incomplete doctype values (both or neither should be null): Public ID [ {0} ], System ID [ {1} ]", new Object[]{publicId, systemId});
        }
        if (systemId == null) {
            this.setModuleVersionID(this.getDefaultModuleVersionID());
        } else if (systemId.equals(this.getJ2EE_1_3_SystemID()) || systemId.equals(this.getJ2EE_Alt_1_3_SystemID())) {
            this.setJ2EEVersionID(13);
        } else if (systemId.equals(this.getJ2EE_1_2_SystemID()) || systemId.equals(this.getJ2EE_Alt_1_2_SystemID())) {
            this.setJ2EEVersionID(12);
        } else {
            this.unrecognizedDoctypeValues(CLASS_NAME, "setDoctypeValues", publicId, systemId);
            this.setModuleVersionID(this.getDefaultModuleVersionID());
        }
    }

    public void unrecognizedDoctypeValues(String className, String methodName, String publicId, String systemId) {
        logger.logp(Level.WARNING, className, methodName, "Received unrecognized doctype values: Public ID [ {0} ], System ID [ {1} ]", new Object[]{publicId, systemId});
    }

    protected String getDefaultPublicId() {
        int j2eeVersionId = this.getJ2EEVersionID();
        if (j2eeVersionId == 12) {
            return this.getJ2EE_1_2_PublicID();
        }
        if (j2eeVersionId == 13) {
            return this.getJ2EE_1_3_PublicID();
        }
        return null;
    }

    protected String getDefaultSystemId() {
        int j2eeVersionId = this.getJ2EEVersionID();
        if (j2eeVersionId == 12) {
            return this.getJ2EE_1_2_SystemID();
        }
        if (j2eeVersionId == 13) {
            return this.getJ2EE_1_3_SystemID();
        }
        return null;
    }

    public abstract String getJ2EE_1_2_PublicID();

    public abstract String getJ2EE_1_2_SystemID();

    public String getJ2EE_Alt_1_2_SystemID() {
        return this.getJ2EE_1_2_SystemID();
    }

    public abstract String getJ2EE_1_3_PublicID();

    public abstract String getJ2EE_1_3_SystemID();

    public String getJ2EE_Alt_1_3_SystemID() {
        return this.getJ2EE_1_3_SystemID();
    }

    protected void initializeContents() {
        super.initializeContents();
        this.eAdapters().add(new RootVersionAdapter());
    }

    protected abstract void syncVersionOfRootObject();

    public NotificationChain basicSetResourceSet(ResourceSet aResourceSet, NotificationChain notifications) {
        if (aResourceSet == null && this.resourceSet != null) {
            this.preDelete();
        }
        return super.basicSetResourceSet(aResourceSet, notifications);
    }

    public boolean isAlt() {
        return this.isAlt;
    }

    public void setIsAlt(boolean isAlternateDD) {
        this.isAlt = isAlternateDD;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public Application getApplication() {
        return this.application;
    }

    public boolean setModuleVersionID(Document document) {
        String methodName = "setModuleVersionID";
        int useModuleVersionId = this.getModuleVersionID(document);
        logger.logp(Level.FINER, CLASS_NAME, methodName, "Selected module version ID [ {0} ]", new Integer(useModuleVersionId));
        if (useModuleVersionId != -1) {
            this.setModuleVersionID(useModuleVersionId);
            return true;
        }
        return false;
    }

    public boolean setModuleVersionID(Attributes attributes) {
        String moduleVersionText = attributes.getValue("version");
        int useModuleVersionId = this.parseModuleVersionId(moduleVersionText);
        if (useModuleVersionId != -1) {
            this.setModuleVersionID(useModuleVersionId);
            return true;
        }
        return false;
    }

    public String getSchemaName(Document document) {
        NamedNodeMap map = document.getDocumentElement().getAttributes();
        if (map == null) {
            return null;
        }
        Node schemaNode = map.getNamedItem("xsi:schemaLocation");
        if (schemaNode == null) {
            return null;
        }
        return schemaNode.getNodeValue();
    }

    public String getVersionString(Document document) {
        NamedNodeMap map = document.getDocumentElement().getAttributes();
        if (map == null) {
            return null;
        }
        Node versionNode = map.getNamedItem("version");
        if (versionNode == null) {
            return null;
        }
        return versionNode.getNodeValue();
    }

    public int getModuleVersionID(Document document) {
        int moduleVersionId = -1;
        DocumentType docType = document.getDoctype();
        if (docType != null) {
            moduleVersionId = this.lookupModuleVersionId(docType.getPublicId(), docType.getSystemId());
        }
        if (moduleVersionId == -1) {
            String versionString = this.getVersionString(document);
            moduleVersionId = this.parseModuleVersionId(versionString);
        }
        return moduleVersionId;
    }

    public int lookupModuleVersionId(String schemaName) {
        return -1;
    }

    public int lookupModuleVersionId(String publicId, String systemId) {
        return -1;
    }

    public int parseModuleVersionId(String versionString) {
        return -1;
    }

    private static class RootVersionAdapter
    extends AdapterImpl {
        static final String ADAPTER_TYPE = RootVersionAdapter.class.getName();

        private RootVersionAdapter() {
        }

        public boolean isAdapterForType(Object type) {
            return super.isAdapterForType(type);
        }

        public void notifyChanged(Notification msg) {
            if (msg.getFeatureID(null) == 2 && msg.getEventType() == 3) {
                ((XMLResourceImpl)msg.getNotifier()).syncVersionOfRootObject();
                ((Notifier)msg.getNotifier()).eAdapters().remove(this);
            }
        }
    }
}

