/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.util.logger;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class LogEntry {
    private int _executionMap = 0;
    private Throwable _caughtException = null;
    private String _propertiesFileName = null;
    private String localeOfOrigin = null;
    private String sourceIdentifier;
    private String elapsedTime;
    private String text;
    private String messageTypeIdentifier;

    public LogEntry(String propertiesFileName) {
        this.setPropertiesFileName(propertiesFileName);
    }

    public LogEntry() {
    }

    public int getExecutionMap() {
        return this._executionMap;
    }

    public String getPropertiesFileName() {
        return this._propertiesFileName;
    }

    public Throwable getTargetException() {
        return this._caughtException;
    }

    public String getLocaleOfOrigin() {
        return this.localeOfOrigin;
    }

    public String getSourceidentifier() {
        return this.sourceIdentifier;
    }

    public String getElapsedTime() {
        return this.elapsedTime;
    }

    public String getMessageTypeIdentifier() {
        return this.messageTypeIdentifier;
    }

    public void setExecutionMap(int map) {
        this._executionMap = map;
    }

    public void setPropertiesFileName(String fName) {
        this._propertiesFileName = fName;
    }

    public void setTargetException(Throwable exc) {
        this._caughtException = exc;
    }

    public void appendStackTrace() {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteOutput);
        new Exception("Stack trace").printStackTrace(printWriter);
        printWriter.flush();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getText());
        buffer.append("\n");
        buffer.append(byteOutput.toString());
        this.setText(buffer.toString());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void reset() {
        this.setExecutionMap(0);
        this.setTargetException(null);
        this.localeOfOrigin = null;
        this.sourceIdentifier = null;
        this.elapsedTime = null;
        this.setText(null);
    }

    public void setLocaleOfOrigin(String origin) {
        this.localeOfOrigin = origin;
    }

    public void setSourceID(String id) {
        this.sourceIdentifier = id;
    }

    public void setElapsedTime(long time2) {
        this.elapsedTime = String.valueOf(time2);
    }

    public void setSourceIdentifier(String string) {
        this.setSourceID(string);
    }

    public void setMessageTypeIdentifier(String string) {
        this.messageTypeIdentifier = string;
    }

    public void setMessageTypeID(String string) {
        this.setMessageTypeIdentifier(string);
    }

    public void setTokens(String[] strings) {
    }

    public String toString() {
        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteOutput);
        if (this.text != null) {
            printWriter.println(this.text);
        }
        if (this._caughtException != null) {
            this._caughtException.printStackTrace(printWriter);
        }
        printWriter.flush();
        return byteOutput.toString();
    }
}

