/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.server;

import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.encoding.SOAPMappingRegistry;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.server.SOAPFaultListener;
import org.apache.soap.server.SOAPFaultRouter;
import org.apache.soap.server.TypeMapping;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.Serializer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DeploymentDescriptor
implements Serializable {
    public static final int SERVICE_TYPE_RPC = 0;
    public static final int SERVICE_TYPE_MESSAGE = 1;
    public static final int SCOPE_REQUEST = 0;
    public static final int SCOPE_SESSION = 1;
    public static final int SCOPE_APPLICATION = 2;
    public static final byte PROVIDER_JAVA = 0;
    public static final byte PROVIDER_SCRIPT_FILE = 1;
    public static final byte PROVIDER_SCRIPT_STRING = 2;
    public static final byte PROVIDER_USER_DEFINED = 3;
    protected String id;
    protected int serviceType = 0;
    protected int scope;
    protected byte providerType = (byte)-1;
    protected String providerClass;
    protected String serviceClass;
    protected Hashtable props;
    protected boolean isStatic;
    protected String scriptFilenameOrString;
    protected String scriptLanguage;
    protected String[] methods;
    protected TypeMapping[] mappings;
    transient SOAPMappingRegistry cachedSMR;
    protected String[] faultListener;
    private transient SOAPFaultRouter fr;
    private transient Map cachedServiceInfo;
    protected boolean checkMustUnderstands = false;
    private String defaultSMRClass = null;

    public void setID(String string) {
        this.id = string;
    }

    public String getID() {
        return this.id;
    }

    public boolean getCheckMustUnderstands() {
        return this.checkMustUnderstands;
    }

    public void setCheckMustUnderstands(boolean bl) {
        this.checkMustUnderstands = bl;
    }

    public void setServiceType(int n) {
        this.serviceType = n;
    }

    public int getServiceType() {
        return this.serviceType;
    }

    public void setScope(int n) {
        this.scope = n;
    }

    public int getScope() {
        return this.scope;
    }

    public void setDefaultSMRClass(String string) {
        this.defaultSMRClass = string;
    }

    public String getDefaultSMRClass() {
        return this.defaultSMRClass;
    }

    public void setMethods(String[] stringArray) {
        this.methods = stringArray;
    }

    public String[] getMethods() {
        return this.methods;
    }

    public void setProviderType(byte by) {
        this.providerType = by;
    }

    public byte getProviderType() {
        return this.providerType;
    }

    public void setServiceClass(String string) {
        this.serviceClass = string;
    }

    public String getServiceClass() {
        return this.serviceClass;
    }

    public Hashtable getProps() {
        return this.props;
    }

    public void setProps(Hashtable hashtable) {
        this.props = hashtable;
    }

    public void setProviderClass(String string) {
        this.providerClass = string;
    }

    public String getProviderClass() {
        return this.providerClass;
    }

    public void setIsStatic(boolean bl) {
        this.isStatic = bl;
    }

    public boolean getIsStatic() {
        return this.isStatic;
    }

    public void setScriptLanguage(String string) {
        this.scriptLanguage = string;
    }

    public String getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptFilenameOrString(String string) {
        this.scriptFilenameOrString = string;
    }

    public String getScriptFilenameOrString() {
        return this.scriptFilenameOrString;
    }

    public void setMappings(TypeMapping[] typeMappingArray) {
        this.mappings = typeMappingArray;
    }

    public TypeMapping[] getMappings() {
        return this.mappings;
    }

    private void setCachedSMR(SOAPMappingRegistry sOAPMappingRegistry) {
        this.cachedSMR = sOAPMappingRegistry;
    }

    private SOAPMappingRegistry getCachedSMR() {
        return this.cachedSMR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCachedServiceInfo(String string, Object object) {
        Object object2;
        if (this.cachedServiceInfo == null) {
            object2 = this;
            synchronized (object2) {
                if (this.cachedServiceInfo == null) {
                    this.cachedServiceInfo = Collections.synchronizedMap(new HashMap(8));
                }
            }
        }
        object2 = string;
        synchronized (object2) {
            this.cachedServiceInfo.put(string, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getCachedServiceInfo(String string) {
        if (this.cachedServiceInfo == null) {
            return null;
        }
        String string2 = string;
        synchronized (string2) {
            return this.cachedServiceInfo.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCachedServiceInfo(String string) {
        if (this.cachedServiceInfo == null) {
            return false;
        }
        String string2 = string;
        synchronized (string2) {
            return this.cachedServiceInfo.containsKey(string);
        }
    }

    public String[] getFaultListener() {
        return this.faultListener;
    }

    public void setFaultListener(String[] stringArray) {
        this.faultListener = stringArray;
    }

    public SOAPFaultRouter buildFaultRouter(SOAPContext sOAPContext) {
        if (this.fr != null) {
            return this.fr;
        }
        this.fr = new SOAPFaultRouter();
        if (this.faultListener == null) {
            return this.fr;
        }
        SOAPFaultListener[] sOAPFaultListenerArray = new SOAPFaultListener[this.faultListener.length];
        try {
            for (int i = 0; i < this.faultListener.length; ++i) {
                Class clazz = sOAPContext.loadClass(this.faultListener[i]);
                sOAPFaultListenerArray[i] = (SOAPFaultListener)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fr.setFaultListener(sOAPFaultListenerArray);
        return this.fr;
    }

    public void toXML(Writer writer) {
        Object object;
        int n;
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("<isd:service xmlns:isd=\"http://xml.apache.org/xml-soap/deployment\" id=\"" + this.id + "\"" + (this.serviceType != 0 ? " type=\"message\"" : "") + " checkMustUnderstands=\"" + (this.checkMustUnderstands ? "true" : "false") + "\"" + ">");
        byte by = this.providerType;
        String[] stringArray = new String[]{"Request", "Session", "Application"};
        String string = null;
        string = by == 0 ? "java" : (by == 3 ? this.serviceClass : "script");
        printWriter.print("  <isd:provider type=\"" + string + "\" scope=\"" + stringArray[this.scope] + "\" methods=\"");
        for (n = 0; n < this.methods.length; ++n) {
            printWriter.print(this.methods[n]);
            if (n >= this.methods.length - 1) continue;
            printWriter.print(" ");
        }
        printWriter.println("\">");
        if (by == 0) {
            printWriter.println("    <isd:java class=\"" + this.providerClass + "\" static=\"" + (this.isStatic ? "true" : "false") + "\"/>");
        } else if (by == 1 || by == 2) {
            printWriter.print("    <isd:script language=\"" + this.scriptLanguage + "\"");
            if (by == 1) {
                printWriter.println(" source=\"" + this.scriptFilenameOrString + "\"/>");
            } else {
                printWriter.println(">");
                printWriter.println("      <![CDATA[");
                printWriter.println(this.scriptFilenameOrString);
                printWriter.println("      ]]>");
                printWriter.println("    </isd:script>");
            }
        } else if (by == 3 && this.providerClass != null) {
            printWriter.println("    <isd:java class=\"" + this.providerClass + "\" static=\"" + (this.isStatic ? "true" : "false") + "\"/>");
        }
        if (this.props != null) {
            Enumeration enumeration = this.props.keys();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                String string2 = (String)this.props.get(object);
                printWriter.println("    <isd:option key=\"" + (String)object + "\" value=\"" + string2 + "\" />");
            }
        }
        printWriter.println("  </isd:provider>");
        if (this.faultListener != null) {
            for (n = 0; n < this.faultListener.length; ++n) {
                printWriter.println("  <isd:faultListener>" + this.faultListener[n] + "</isd:faultListener>");
            }
        }
        if (this.mappings != null) {
            printWriter.print("  <isd:mappings");
            if (this.defaultSMRClass != null) {
                printWriter.println(" defaultRegistryClass=\"" + this.defaultSMRClass + "\">");
            } else {
                printWriter.println(">");
            }
            for (n = 0; n < this.mappings.length; ++n) {
                object = this.mappings[n];
                printWriter.print("    <isd:map");
                if (((TypeMapping)object).encodingStyle != null) {
                    printWriter.print(" encodingStyle=\"" + ((TypeMapping)object).encodingStyle + "\"");
                }
                if (((TypeMapping)object).elementType != null) {
                    printWriter.print(" xmlns:x=\"" + ((TypeMapping)object).elementType.getNamespaceURI() + "\" qname=\"x:" + ((TypeMapping)object).elementType.getLocalPart() + "\"");
                }
                if (((TypeMapping)object).javaType != null) {
                    printWriter.print(" javaType=\"" + ((TypeMapping)object).javaType + "\"");
                }
                if (((TypeMapping)object).xml2JavaClassName != null) {
                    printWriter.print(" xml2JavaClassName=\"" + ((TypeMapping)object).xml2JavaClassName + "\"");
                }
                if (((TypeMapping)object).java2XMLClassName != null) {
                    printWriter.print(" java2XMLClassName=\"" + ((TypeMapping)object).java2XMLClassName + "\"");
                }
                printWriter.println("/>");
            }
            printWriter.println("  </isd:mappings>");
        }
        printWriter.println("</isd:service>");
        printWriter.flush();
    }

    public static DeploymentDescriptor fromXML(Reader reader) throws IllegalArgumentException {
        if (reader == null) {
            throw new IllegalArgumentException("Reader passed to DeploymentDescriptor.fromXML(...) must not be null.");
        }
        try {
            DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
            Document document = documentBuilder.parse(new InputSource(reader));
            if (document != null) {
                Element element = document.getDocumentElement();
                return DeploymentDescriptor.fromXML(element);
            }
            throw new Exception("Document came back null.");
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Problem parsing deployment descriptor: " + exception);
        }
    }

    public static DeploymentDescriptor fromXML(Element element) throws IllegalArgumentException {
        String string;
        NodeList nodeList;
        String string2;
        if (element == null || !element.getNamespaceURI().equals("http://xml.apache.org/xml-soap/deployment") || !element.getLocalName().equals("service")) {
            throw new IllegalArgumentException("root is null or document element is not {http://xml.apache.org/xml-soap/deployment}service");
        }
        DeploymentDescriptor deploymentDescriptor = new DeploymentDescriptor();
        String string3 = DOMUtils.getAttribute(element, "id");
        if (string3 == null) {
            throw new IllegalArgumentException("required 'id' attribute missing in deployment descriptor");
        }
        deploymentDescriptor.setID(string3);
        String string4 = DOMUtils.getAttribute(element, "checkMustUnderstands");
        if (string4 != null && string4.equals("true")) {
            deploymentDescriptor.checkMustUnderstands = true;
        }
        if ((string2 = DOMUtils.getAttribute(element, "type")) != null) {
            if (string2.equals("message")) {
                deploymentDescriptor.setServiceType(1);
            } else {
                throw new IllegalArgumentException("unknown value for 'type' attribute: '" + string2 + "': bad deployment descriptor");
            }
        }
        if ((nodeList = element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "provider")) == null || nodeList.getLength() != 1) {
            throw new IllegalArgumentException("exactly one 'provider' element missing in deployment descriptor");
        }
        Element element2 = (Element)nodeList.item(0);
        String string5 = DOMUtils.getAttribute(element2, "type");
        String string6 = DOMUtils.getAttribute(element2, "scope");
        String string7 = DOMUtils.getAttribute(element2, "methods");
        if (string5 == null || string6 == null || !string6.equals("Request") && !string6.equals("Session") && !string6.equals("Application") || string7 == null || string7.equals("")) {
            throw new IllegalArgumentException("invalid value for type or scope or methods attribute in provider element of deployment descriptor");
        }
        int n = -1;
        Element element3 = element2;
        nodeList = element2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "option");
        for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
            element2 = (Element)nodeList.item(i);
            string = DOMUtils.getAttribute(element2, "key");
            String string8 = DOMUtils.getAttribute(element2, "value");
            if (string == null || string.equals("")) {
                throw new IllegalArgumentException("Missing 'key' attribute on 'option' element in deployment desriptor");
            }
            if (deploymentDescriptor.props == null) {
                deploymentDescriptor.props = new Hashtable();
            }
            deploymentDescriptor.props.put(string, string8);
        }
        element2 = element3;
        if (string5.equals("java")) {
            deploymentDescriptor.setProviderType((byte)0);
            nodeList = element2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "java");
            if (nodeList == null || nodeList.getLength() != 1) {
                throw new IllegalArgumentException("exactly one 'java' element missing in deployment descriptor");
            }
            element2 = (Element)nodeList.item(0);
            String string9 = DOMUtils.getAttribute(element2, "class");
            if (string9 == null) {
                throw new IllegalArgumentException("<java> element requires 'class' attribute");
            }
            deploymentDescriptor.setProviderClass(string9);
            string = DOMUtils.getAttribute(element2, "static");
            boolean bl = false;
            if (string != null) {
                if (string.equals("false")) {
                    bl = false;
                } else if (string.equals("true")) {
                    bl = true;
                } else {
                    throw new IllegalArgumentException("'static' attribute of <java> element must be true or false");
                }
            }
            deploymentDescriptor.setIsStatic(bl);
        } else if (string5.equals("script")) {
            nodeList = element2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "script");
            if (nodeList == null || nodeList.getLength() != 1) {
                throw new IllegalArgumentException("exactly one 'script' element missing in deployment descriptor");
            }
            element2 = (Element)nodeList.item(0);
            deploymentDescriptor.setScriptLanguage(DOMUtils.getAttribute(element2, "language"));
            String string10 = DOMUtils.getAttribute(element2, "source");
            if (string10 != null) {
                deploymentDescriptor.setProviderType((byte)1);
                deploymentDescriptor.setScriptFilenameOrString(string10);
            } else {
                deploymentDescriptor.setProviderType((byte)2);
                deploymentDescriptor.setScriptFilenameOrString(DOMUtils.getChildCharacterData(element2));
            }
        } else {
            deploymentDescriptor.setProviderType((byte)3);
            deploymentDescriptor.setServiceClass(string5);
            nodeList = element2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "java");
            if (nodeList != null) {
                if (nodeList.getLength() > 1) {
                    throw new IllegalArgumentException("exactly one 'java' element missing in deployment descriptor");
                }
                if (nodeList.getLength() != 0) {
                    element2 = (Element)nodeList.item(0);
                    String string11 = DOMUtils.getAttribute(element2, "class");
                    if (string11 == null) {
                        throw new IllegalArgumentException("<java> element requires 'class' attribute");
                    }
                    deploymentDescriptor.setProviderClass(string11);
                    string = DOMUtils.getAttribute(element2, "static");
                    boolean bl = false;
                    if (string != null) {
                        if (string.equals("false")) {
                            bl = false;
                        } else if (string.equals("true")) {
                            bl = true;
                        } else {
                            throw new IllegalArgumentException("'static' attribute of <java> element must be true or false");
                        }
                    }
                    deploymentDescriptor.setIsStatic(bl);
                }
            }
        }
        n = string6.equals("Request") ? 0 : (string6.equals("Session") ? 1 : 2);
        deploymentDescriptor.setScope(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string7);
        int n2 = stringTokenizer.countTokens();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        deploymentDescriptor.setMethods(stringArray);
        nodeList = element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "faultListener");
        String[] stringArray2 = new String[nodeList.getLength()];
        try {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                stringArray2[i] = DOMUtils.getChildCharacterData((Element)nodeList.item(i));
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        deploymentDescriptor.setFaultListener(stringArray2);
        nodeList = element.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "mappings");
        if (nodeList == null || nodeList.getLength() > 1) {
            throw new IllegalArgumentException("at most one 'mappings' element allowed in deployment descriptor");
        }
        if (nodeList.getLength() == 1) {
            int n3;
            element2 = (Element)nodeList.item(0);
            String string12 = DOMUtils.getAttribute(element2, "defaultRegistryClass");
            if (string12 != null) {
                deploymentDescriptor.setDefaultSMRClass(string12);
            }
            if ((n3 = (nodeList = element2.getElementsByTagNameNS("http://xml.apache.org/xml-soap/deployment", "map")).getLength()) > 0) {
                TypeMapping[] typeMappingArray = new TypeMapping[n3];
                deploymentDescriptor.setMappings(typeMappingArray);
                for (int i = 0; i < n3; ++i) {
                    element2 = (Element)nodeList.item(i);
                    QName qName = DOMUtils.getQualifiedAttributeValue(element2, "qname", true);
                    typeMappingArray[i] = new TypeMapping(DOMUtils.getAttribute(element2, "encodingStyle"), qName, DOMUtils.getAttribute(element2, "javaType"), DOMUtils.getAttribute(element2, "java2XMLClassName"), DOMUtils.getAttribute(element2, "xml2JavaClassName"));
                }
            }
        }
        return deploymentDescriptor;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < this.methods.length; ++i) {
            stringBuffer.append(this.methods[i]);
            if (i >= this.methods.length - 1) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        String string = "[DeploymentDescriptor id='" + this.id + "', " + (this.serviceType != 0 ? "type='message', " : "") + "scope='" + this.scope + "', ";
        String string2 = null;
        if (this.providerType == 0) {
            string2 = "class='" + this.providerClass + "', static='" + this.isStatic + "', ";
        } else if (this.providerType == 1) {
            string2 = "source='" + this.scriptFilenameOrString + "', ";
            string2 = string2 + "language='" + this.scriptLanguage + "', ";
        } else if (this.providerType == 3) {
            string2 = "type='" + this.serviceClass + "', class='" + this.providerClass;
            string2 = string2 + "', static='" + this.isStatic + "', ";
        }
        StringBuffer stringBuffer2 = new StringBuffer("[");
        if (this.faultListener != null) {
            for (int i = 0; i < this.faultListener.length; ++i) {
                stringBuffer2.append(this.faultListener[i]);
                stringBuffer2.append(" ");
            }
        }
        stringBuffer2.append("]");
        StringBuffer stringBuffer3 = new StringBuffer();
        if (this.props != null) {
            stringBuffer3.append(this.props.toString());
        }
        return string + string2 + "methods='" + stringBuffer + "', " + "faultListener='" + stringBuffer2 + "', " + "mappings='" + DeploymentDescriptor.mappingsToString(this.mappings) + "'], " + "opts='" + stringBuffer3;
    }

    private static String mappingsToString(TypeMapping[] typeMappingArray) {
        if (typeMappingArray != null) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < typeMappingArray.length; ++i) {
                stringBuffer.append((i > 0 ? " " : "") + typeMappingArray[i]);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public static SOAPMappingRegistry buildSOAPMappingRegistry(DeploymentDescriptor deploymentDescriptor, SOAPContext sOAPContext) {
        Object object;
        TypeMapping[] typeMappingArray = deploymentDescriptor.getMappings();
        SOAPMappingRegistry sOAPMappingRegistry = deploymentDescriptor.getCachedSMR();
        if (sOAPMappingRegistry != null) {
            return sOAPMappingRegistry;
        }
        String string = deploymentDescriptor.getDefaultSMRClass();
        if (string != null) {
            try {
                object = sOAPContext.loadClass(string);
                sOAPMappingRegistry = (SOAPMappingRegistry)((Class)object).newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sOAPMappingRegistry == null) {
            object = SOAPMappingRegistry.getBaseRegistry("http://www.w3.org/2001/XMLSchema");
            if (typeMappingArray == null) {
                deploymentDescriptor.setCachedSMR((SOAPMappingRegistry)object);
                return object;
            }
            sOAPMappingRegistry = new SOAPMappingRegistry((SOAPMappingRegistry)object);
        }
        if (typeMappingArray != null) {
            for (int i = 0; i < typeMappingArray.length; ++i) {
                Object object2;
                object = typeMappingArray[i];
                int n = 0;
                try {
                    Object object3;
                    n = 0;
                    Class clazz = null;
                    if (((TypeMapping)object).javaType != null) {
                        clazz = sOAPContext.loadClass(((TypeMapping)object).javaType);
                    }
                    n = 1;
                    object2 = null;
                    if (((TypeMapping)object).java2XMLClassName != null) {
                        object3 = sOAPContext.loadClass(((TypeMapping)object).java2XMLClassName);
                        object2 = (Serializer)((Class)object3).newInstance();
                    }
                    n = 2;
                    object3 = null;
                    if (((TypeMapping)object).xml2JavaClassName != null) {
                        Class clazz2 = sOAPContext.loadClass(((TypeMapping)object).xml2JavaClassName);
                        object3 = (Deserializer)clazz2.newInstance();
                    }
                    sOAPMappingRegistry.mapTypes(((TypeMapping)object).encodingStyle, ((TypeMapping)object).elementType, clazz, (Serializer)object2, (Deserializer)object3);
                    continue;
                }
                catch (Exception exception) {
                    object2 = "Deployment error in SOAP service '" + deploymentDescriptor.getID() + "': ";
                    object2 = n == 0 ? (String)object2 + "class name '" + ((TypeMapping)object).javaType + "' could not be resolved: " : (n == 1 ? (String)object2 + "class name '" + ((TypeMapping)object).java2XMLClassName + "' could not be " + "resolved as a serializer: " : (String)object2 + "class name '" + ((TypeMapping)object).xml2JavaClassName + "' could not be " + "resolved as a deserializer: ");
                    throw new IllegalArgumentException((String)object2 + exception.getMessage());
                }
            }
        }
        deploymentDescriptor.setCachedSMR(sOAPMappingRegistry);
        return sOAPMappingRegistry;
    }
}

