/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.ObjectName;

public class Role
implements Serializable {
    private static final long serialVersionUID = -279985518429862552L;
    private String name;
    private List objectNameList;

    public Role(String roleName, List roleValueList) throws IllegalArgumentException {
        this.setRoleName(roleName);
        this.setRoleValue(roleValueList);
    }

    public void setRoleName(String roleName) throws IllegalArgumentException {
        if (roleName == null) {
            throw new IllegalArgumentException("Cannot have a null role name");
        }
        this.name = roleName;
    }

    public void setRoleValue(List roleValues) throws IllegalArgumentException {
        if (roleValues == null) {
            throw new IllegalArgumentException("List of role values cannot be null");
        }
        if (this.objectNameList == null) {
            this.objectNameList = new ArrayList();
        }
        this.objectNameList.clear();
        this.objectNameList.addAll(roleValues);
    }

    public String getRoleName() {
        return this.name;
    }

    public List getRoleValue() {
        return this.objectNameList == null ? null : new ArrayList(this.objectNameList);
    }

    public String toString() {
        StringBuffer roleToString = new StringBuffer("roleName: ");
        roleToString.append(this.name);
        roleToString.append("\nroleValue: ");
        String values = Role.roleValueToString(this.objectNameList);
        roleToString.append(values);
        return roleToString.toString();
    }

    public Object clone() {
        try {
            return new Role(this.name, this.objectNameList);
        }
        catch (IllegalArgumentException ignored) {
            return null;
        }
    }

    public static String roleValueToString(List roleValues) throws IllegalArgumentException {
        StringBuffer valuesToString = new StringBuffer();
        Iterator roleValuesIterator = roleValues.iterator();
        while (roleValuesIterator.hasNext()) {
            ObjectName currentObjName = (ObjectName)roleValuesIterator.next();
            if (currentObjName != null) {
                valuesToString.append(currentObjName.toString());
            } else {
                String nullValue = null;
                valuesToString.append(nullValue);
            }
            if (!roleValuesIterator.hasNext()) continue;
            valuesToString.append("\n");
        }
        return valuesToString.toString();
    }
}

