/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.HashMap;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    private String stringToCompare;
    private boolean notifyMatch;
    private boolean notifyDiffers;
    private static final MBeanNotificationInfo[] notificationInfos = new MBeanNotificationInfo[]{new MBeanNotificationInfo(new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"}, "javax.management.monitor.MonitorNotification", "Notifications sent by the StringMonitor MBean")};
    private HashMap infos = new HashMap();

    public synchronized void start() {
        this.doStart();
    }

    public synchronized void stop() {
        this.doStop();
    }

    synchronized void executeMonitor(ObjectName objectName, Object attributeValue) {
        StringMonitorInfo smi = (StringMonitorInfo)this.infos.get(objectName);
        if (smi.getLastValue() != null && smi.getLastValue().equals(attributeValue)) {
            return;
        }
        if (this.stringToCompare == null) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" target value is null"));
            this.notifyListeners("jmx.monitor.error.type", objectName, this.attribute);
        }
        if (!(attributeValue instanceof String)) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" attribute is not String"));
            this.notifyListeners("jmx.monitor.error.type", objectName, this.attribute);
            return;
        }
        this.calculateDerivedGauge(smi, (String)attributeValue);
        boolean matches = attributeValue.equals(this.stringToCompare);
        smi.setLastValue((String)attributeValue);
        if (this.notifyMatch && matches) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" found a match"));
            if (!smi.isMatchNotified()) {
                this.notifyListeners("jmx.monitor.string.matches", objectName, this.attribute);
            }
            smi.setMatchNotified(true);
        }
        if (!matches) {
            smi.setMatchNotified(false);
        }
        if (matches) {
            smi.setDifferNotified(false);
        }
        if (this.notifyDiffers && !matches) {
            this.getLogger().info((Object)new StringBuffer("Monitor ").append(this).append(" found a difference"));
            if (!smi.isDifferNotified()) {
                this.notifyListeners("jmx.monitor.string.differs", objectName, this.attribute);
            }
            smi.setDifferNotified(true);
        }
    }

    void calculateDerivedGauge(StringMonitorInfo smi, String value) {
        smi.setDerivedGauge(value);
        smi.setDerivedGaugeTimestamp(System.currentTimeMillis());
    }

    public synchronized String getDerivedGauge() {
        if (this.objectNames.size() == 0) {
            return null;
        }
        return this.getDerivedGauge((ObjectName)this.objectNames.get(0));
    }

    public synchronized String getDerivedGauge(ObjectName objectName) {
        if (this.objectNames.size() == 0) {
            return null;
        }
        return ((StringMonitorInfo)this.infos.get(objectName)).getDerivedGauge();
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        if (this.objectNames.size() == 0) {
            return 0L;
        }
        return this.getDerivedGaugeTimeStamp((ObjectName)this.objectNames.get(0));
    }

    public synchronized long getDerivedGaugeTimeStamp(ObjectName objectName) {
        if (this.objectNames.size() == 0) {
            return 0L;
        }
        return ((StringMonitorInfo)this.infos.get(objectName)).getDerivedGaugeTimestamp();
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Cannot compare to null");
        }
        StringMonitor stringMonitor = this;
        synchronized (stringMonitor) {
            this.resetLastValue();
        }
        this.stringToCompare = value;
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public synchronized void setNotifyMatch(boolean value) {
        this.resetLastValue();
        this.notifyMatch = value;
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffers;
    }

    public synchronized void setNotifyDiffer(boolean value) {
        this.resetLastValue();
        this.notifyDiffers = value;
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return notificationInfos;
    }

    public String toString() {
        return "StringMonitor on " + super.toString();
    }

    public synchronized void addObservedObject(ObjectName objectName) throws IllegalArgumentException {
        super.addObservedObject(objectName);
        this.infos.put(objectName, new StringMonitorInfo(null, System.currentTimeMillis()));
    }

    public synchronized void removeObservedObject(ObjectName objectName) {
        super.removeObservedObject(objectName);
        this.infos.remove(objectName);
    }

    private void resetLastValue() {
        for (int i = 0; i < this.objectNames.size(); ++i) {
            StringMonitorInfo smi = (StringMonitorInfo)this.infos.get(this.objectNames.get(i));
            smi.setLastValue(null);
        }
    }

    class StringMonitorInfo {
        String derivedGauge;
        String lastValue;
        long derivedGaugeTimestamp;
        boolean matchNotified = false;
        boolean differNotified = false;

        public StringMonitorInfo(String derivedGauge, long derivedGaugeTimestamp) {
            this.derivedGauge = derivedGauge;
            this.derivedGaugeTimestamp = derivedGaugeTimestamp;
            this.lastValue = null;
        }

        public String getDerivedGauge() {
            return this.derivedGauge;
        }

        public void setDerivedGauge(String derivedGauge) {
            this.derivedGauge = derivedGauge;
        }

        public long getDerivedGaugeTimestamp() {
            return this.derivedGaugeTimestamp;
        }

        public void setDerivedGaugeTimestamp(long derivedGaugeTimestamp) {
            this.derivedGaugeTimestamp = derivedGaugeTimestamp;
        }

        public String getLastValue() {
            return this.lastValue;
        }

        public void setLastValue(String lastValue) {
            this.lastValue = lastValue;
        }

        public boolean isDifferNotified() {
            return this.differNotified;
        }

        public void setDifferNotified(boolean differNotified) {
            this.differNotified = differNotified;
        }

        public boolean isMatchNotified() {
            return this.matchNotified;
        }

        public void setMatchNotified(boolean matchNotified) {
            this.matchNotified = matchNotified;
        }
    }
}

