/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;
import mx4j.log.FileLogger;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.log.MBeanLogger;
import mx4j.persist.FilePersister;
import mx4j.persist.MBeanPersister;
import mx4j.persist.PersisterMBean;
import mx4j.util.Utils;

public class RequiredModelMBean
implements ModelMBean,
MBeanRegistration,
NotificationEmitter {
    private static final String PERSISTPERIOD = "persistPeriod";
    private static final String NOMOREOFTENTHAN = "NoMoreOftenThan";
    private static final String SETMETHOD = "setMethod";
    private static final String GETMETHOD = "getMethod";
    private static final String LASTUPDATEDTIMESTAMP = "lastUpdatedTimeStamp";
    private static final String LASTRETURNEDVALUE = "lastReturnedValue";
    private static final String NAME = "name";
    private static final String PERSISTNAME = "persistName";
    private static final String PERSISTLOCATION = "persistLocation";
    private static final String CURRENCYTIMELIMIT = "currencyTimeLimit";
    private static final String ONTIMER = "OnTimer";
    private static final String ONUPDATE = "OnUpdate";
    private static final String NEVER = "Never";
    private static final String PERSISTPOLICY = "persistPolicy";
    private static final String TARGETOBJECTTYPE = "targetObjectType";
    private static final String TARGETOBJECT = "targetObject";
    private static final String JMX_MODELMBEAN_GENERIC = "jmx.modelmbean.generic";
    private static final String OBJECT_RESOURCE_TYPE = "ObjectReference";
    private static final String OBJECT_RESOURCE_TYPE1 = "objectReference";
    private static final int ALWAYS_STALE = 1;
    private static final int NEVER_STALE = 2;
    private static final int STALE = 3;
    private static final int NOT_STALE = 4;
    private static final int PERSIST_NEVER = -1;
    private static final int PERSIST_ON_TIMER = -2;
    private static final int PERSIST_ON_UPDATE = -3;
    private static final int PERSIST_NO_MORE_OFTEN_THAN = -4;
    private static final String GENERIC_NOTIFICATION = "GENERIC";
    private static final String ATTRCHANGE_NOTIFICATION = "ATTRIBUTE_CHANGE";
    private static ModelMBeanInfo defaultMmbi = new ModelMBeanInfoSupport((class$javax$management$modelmbean$RequiredModelMBean == null ? (class$javax$management$modelmbean$RequiredModelMBean = RequiredModelMBean.class$("javax.management.modelmbean.RequiredModelMBean")) : class$javax$management$modelmbean$RequiredModelMBean).getName(), "Default RequiredModelMBean", new ModelMBeanAttributeInfo[0], new ModelMBeanConstructorInfo[0], new ModelMBeanOperationInfo[0], new ModelMBeanNotificationInfo[0]);
    private Logger logger = Log.getLogger((String)this.getClass().getName());
    private MBeanServer m_mbeanServer;
    private Object m_managedResource;
    private ModelMBeanInfo m_modelMBeanInfo;
    private ObjectName m_objname;
    private boolean registered = false;
    private NotificationBroadcasterSupport m_attributeChangeBroadcaster = new NotificationBroadcasterSupport();
    private NotificationBroadcasterSupport m_generalBroadcaster = new NotificationBroadcasterSupport();
    static /* synthetic */ Class class$javax$management$modelmbean$RequiredModelMBean;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public RequiredModelMBean() throws MBeanException, RuntimeOperationsException {
        this(defaultMmbi);
    }

    public RequiredModelMBean(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo parameter can't be null"));
        }
        this.setModelMBeanInfo(info);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        if (this.logger.isEnabledFor(0) && name != null) {
            this.logger.trace((Object)("Preparing to register [" + name.toString() + "]"));
        }
        this.m_mbeanServer = server;
        this.m_objname = name;
        return name;
    }

    public void postRegister(Boolean registrationDone) {
        if (this.logger.isEnabledFor(0) && this.m_objname != null) {
            this.logger.trace((Object)("Registration succeded [" + this.m_objname.toString() + ":" + registrationDone.toString() + "]"));
        }
        this.registered = registrationDone;
    }

    public void preDeregister() throws Exception {
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)("Preparing to unregister [" + this.m_objname + "]"));
        }
    }

    public void postDeregister() {
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)("Unregistered [" + this.m_objname.toString() + "]"));
        }
        this.registered = false;
    }

    private void clear() {
        this.m_mbeanServer = null;
    }

    public void setModelMBeanInfo(ModelMBeanInfo info) throws MBeanException, RuntimeOperationsException {
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo must not be null"));
        }
        if (this.registered) {
            throw new RuntimeOperationsException(new IllegalStateException("ModelMBean is registered, can't setModelMBeanInfo"));
        }
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)("Preparing to set ModelMBeanInfo [" + info.toString() + "]"));
        }
        this.m_modelMBeanInfo = (ModelMBeanInfo)info.clone();
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)("ModelMBeanInfo set [" + this.m_modelMBeanInfo.toString() + "]"));
        }
    }

    private boolean isModelMBeanInfoValid(ModelMBeanInfo info) {
        return info != null && info.getClassName() != null;
    }

    public void setManagedResource(Object resource, String resourceType) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (!this.isResourceTypeSupported(resourceType)) {
            throw new InvalidTargetObjectTypeException(resourceType);
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Setting managed resource to be: " + resource));
        }
        this.m_managedResource = resource;
    }

    private boolean isResourceTypeSupported(String resourceType) {
        return OBJECT_RESOURCE_TYPE.equals(resourceType) || OBJECT_RESOURCE_TYPE1.equals(resourceType);
    }

    private Object getManagedResource() {
        return this.m_managedResource;
    }

    public MBeanInfo getMBeanInfo() {
        return this.m_modelMBeanInfo == null ? (MBeanInfo)defaultMmbi.clone() : (MBeanInfo)this.m_modelMBeanInfo.clone();
    }

    public void addAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        ModelMBeanAttributeInfo attrInfo;
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo is null"));
        }
        if (attributeName != null && (attrInfo = info.getAttribute(attributeName)) == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Cannot find ModelMBeanAttributeInfo for attribute " + attributeName));
        }
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        if (attributeName != null) {
            filter.enableAttribute(attributeName);
        } else {
            MBeanAttributeInfo[] ai = this.m_modelMBeanInfo.getAttributes();
            for (int i = 0; i < ai.length; ++i) {
                Descriptor d = ((ModelMBeanAttributeInfo)ai[i]).getDescriptor();
                filter.enableAttribute((String)d.getFieldValue(NAME));
            }
        }
        this.getAttributeChangeBroadcaster().addNotificationListener(listener, filter, handback);
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Listener " + listener + " for attribute " + attributeName + " added successfully, handback is " + handback));
        }
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.m_generalBroadcaster.addNotificationListener(listener, filter, handback);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = this.m_modelMBeanInfo.getNotifications();
        boolean hasgeneric = false;
        if (result != null) {
            hasgeneric = this.hasNotification(result, GENERIC_NOTIFICATION);
        }
        boolean hasattrchange = false;
        if (result != null) {
            hasattrchange = this.hasNotification(result, ATTRCHANGE_NOTIFICATION);
        }
        if (!hasgeneric || !hasattrchange) {
            result = this.addRequiredNotifications(result, hasgeneric, hasattrchange);
        }
        return result;
    }

    public void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        try {
            this.removeAttributeChangeNotificationListener(listener, attributeName, null);
        }
        catch (MBeanException e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()));
        }
    }

    private void removeAttributeChangeNotificationListener(NotificationListener listener, String attributeName, Object handback) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        ModelMBeanAttributeInfo attrInfo;
        if (listener == null) {
            throw new ListenerNotFoundException("Listener cannot be null");
        }
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name not found in MBeanInfo"));
        }
        if (attributeName != null && (attrInfo = info.getAttribute(attributeName)) == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name not found in MBeanInfo"));
        }
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        if (attributeName != null) {
            filter.enableAttribute(attributeName);
        } else {
            MBeanAttributeInfo[] ai = this.m_modelMBeanInfo.getAttributes();
            for (int i = 0; i < ai.length; ++i) {
                Descriptor d = ((ModelMBeanAttributeInfo)ai[i]).getDescriptor();
                filter.enableAttribute((String)d.getFieldValue(NAME));
            }
        }
        this.getAttributeChangeBroadcaster().removeNotificationListener(listener, filter, handback);
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Listener " + listener + " for attribute " + attributeName + " removed successfully, handback is " + handback));
        }
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener is null");
        }
        this.m_generalBroadcaster.removeNotificationListener(listener);
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (listener == null) {
            throw new ListenerNotFoundException("NotificationListener is null");
        }
        this.m_generalBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    public void sendAttributeChangeNotification(Attribute oldAttribute, Attribute newAttribute) throws MBeanException, RuntimeOperationsException {
        if (oldAttribute == null || newAttribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
        }
        if (!oldAttribute.getName().equals(newAttribute.getName())) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names cannot be different"));
        }
        Object oldValue = oldAttribute.getValue();
        AttributeChangeNotification n = new AttributeChangeNotification(this, 1L, System.currentTimeMillis(), "Attribute value changed", oldAttribute.getName(), oldValue == null ? null : oldValue.getClass().getName(), oldValue, newAttribute.getValue());
        this.sendAttributeChangeNotification(n);
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification cannot be null"));
        }
        this.getAttributeChangeBroadcaster().sendNotification(notification);
        this.getGeneralNotificationBroadcaster().sendNotification(notification);
        Logger modelMBeanLogger = this.getModelMBeanLogger(notification.getType());
        if (modelMBeanLogger != null && modelMBeanLogger.isEnabledFor(20)) {
            modelMBeanLogger.info((Object)("ModelMBean log: " + new Date() + " - " + notification));
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Attribute change notification " + notification + " sent"));
        }
    }

    public void sendNotification(String message) throws MBeanException, RuntimeOperationsException {
        if (message == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification text string cannot be null"));
        }
        Notification notification = new Notification(JMX_MODELMBEAN_GENERIC, (Object)this, 1L, message);
        this.sendNotification(notification);
    }

    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification cannot be null"));
        }
        this.m_generalBroadcaster.sendNotification(notification);
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute names cannot be null"));
        }
        AttributeList list = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            String attrName = attributes[i];
            Attribute attribute = null;
            try {
                Object value = this.getAttribute(attrName);
                attribute = new Attribute(attrName, value);
                list.add(attribute);
                continue;
            }
            catch (Exception x) {
                if (!this.logger.isEnabledFor(0)) continue;
                this.logger.trace((Object)("getAttribute for attribute " + attrName + " failed"), (Throwable)x);
            }
        }
        return list;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Descriptor attributeDescriptor;
        ModelMBeanAttributeInfo attrInfo;
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"));
        }
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            throw new AttributeNotFoundException("ModelMBeanInfo is null");
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("ModelMBeanInfo is: " + info));
        }
        if ((attrInfo = info.getAttribute(attribute)) == null) {
            throw new AttributeNotFoundException("Cannot find ModelMBeanAttributeInfo for attribute " + attribute);
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Attribute info is: " + attrInfo));
        }
        if (!attrInfo.isReadable()) {
            throw new AttributeNotFoundException("Attribute " + attribute + " is not readable");
        }
        Descriptor mbeanDescriptor = info.getMBeanDescriptor();
        if (mbeanDescriptor == null) {
            throw new AttributeNotFoundException("MBean descriptor cannot be null");
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("MBean descriptor is: " + mbeanDescriptor));
        }
        if ((attributeDescriptor = attrInfo.getDescriptor()) == null) {
            throw new AttributeNotFoundException("Attribute descriptor for attribute " + attribute + " cannot be null");
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Attribute descriptor is: " + attributeDescriptor));
        }
        Object returnValue = null;
        String lastUpdateField = LASTUPDATEDTIMESTAMP;
        int staleness = this.getStaleness(attributeDescriptor, mbeanDescriptor, lastUpdateField);
        if (staleness == 2 || staleness == 3) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Value is stale");
            }
            String getter = (String)attributeDescriptor.getFieldValue(GETMETHOD);
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("getMethod field is: " + getter));
            }
            if (getter == null) {
                returnValue = attributeDescriptor.getFieldValue("default");
                if (returnValue != null) {
                    Class<?> returned = returnValue.getClass();
                    Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                    this.checkAssignability(returned, declared);
                }
                this.logger.info((Object)("getAttribute for attribute " + attribute + " returns default value: " + returnValue));
            } else {
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"Invoking attribute getter...");
                }
                Object target = this.resolveTargetObject(attributeDescriptor);
                returnValue = this.invokeMethod(target, getter, new Class[0], new Object[0]);
                if (this.logger.isEnabledFor(10)) {
                    this.logger.debug((Object)("Returned value is: " + returnValue));
                }
                if (returnValue != null) {
                    Class<?> returned = returnValue.getClass();
                    Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                    this.checkAssignability(returned, declared);
                }
                if (staleness != 1) {
                    attributeDescriptor.setField("value", returnValue);
                    attributeDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                    if (this.logger.isEnabledFor(0)) {
                        this.logger.trace((Object)"Returned value has been cached");
                    }
                    info.setDescriptor(attributeDescriptor, "attribute");
                }
                this.logger.info((Object)("getAttribute for attribute " + attribute + " returns invoked value: " + returnValue));
            }
        } else {
            returnValue = attributeDescriptor.getFieldValue("value");
            if (returnValue != null) {
                Class<?> returned = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                this.checkAssignability(returned, declared);
            }
            this.logger.info((Object)("getAttribute for attribute " + attribute + " returns cached value: " + returnValue));
        }
        return returnValue;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute list cannot be null"));
        }
        AttributeList list = new AttributeList();
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            String name = attribute.getName();
            try {
                this.setAttribute(attribute);
                list.add(attribute);
            }
            catch (Exception x) {
                if (!this.logger.isEnabledFor(0)) continue;
                this.logger.trace((Object)("setAttribute for attribute " + name + " failed"), (Throwable)x);
            }
        }
        return list;
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Object oldValue;
        String lastUpdateField;
        Descriptor attributeDescriptor;
        Descriptor mbeanDescriptor;
        ModelMBeanAttributeInfo attrInfo;
        Object attrValue;
        String attrName;
        ModelMBeanInfo info;
        block29: {
            if (attribute == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"));
            }
            info = this.getModelMBeanInfo();
            if (info == null) {
                throw new AttributeNotFoundException("ModelMBeanInfo is null");
            }
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("ModelMBeanInfo is: " + info));
            }
            attrName = attribute.getName();
            attrValue = attribute.getValue();
            attrInfo = info.getAttribute(attrName);
            if (attrInfo == null) {
                throw new AttributeNotFoundException("Cannot find ModelMBeanAttributeInfo for attribute " + attrName);
            }
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("Attribute info is: " + attrInfo));
            }
            if (!attrInfo.isWritable()) {
                throw new AttributeNotFoundException("Attribute " + attrName + " is not writable");
            }
            mbeanDescriptor = info.getMBeanDescriptor();
            if (mbeanDescriptor == null) {
                throw new AttributeNotFoundException("MBean descriptor cannot be null");
            }
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("MBean descriptor is: " + mbeanDescriptor));
            }
            if ((attributeDescriptor = attrInfo.getDescriptor()) == null) {
                throw new AttributeNotFoundException("Attribute descriptor for attribute " + attrName + " cannot be null");
            }
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("Attribute descriptor is: " + attributeDescriptor));
            }
            lastUpdateField = LASTUPDATEDTIMESTAMP;
            oldValue = null;
            try {
                oldValue = this.getAttribute(attrName);
                if (this.logger.isEnabledFor(10)) {
                    this.logger.debug((Object)("Previous value of attribute " + attrName + ": " + oldValue));
                }
            }
            catch (Exception x) {
                if (!this.logger.isEnabledFor(10)) break block29;
                this.logger.debug((Object)("Cannot get previous value of attribute " + attrName), (Throwable)x);
            }
        }
        String method2 = (String)attributeDescriptor.getFieldValue(SETMETHOD);
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("setMethod field is: " + method2));
        }
        if (method2 != null) {
            Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
            if (attrValue != null) {
                Class<?> parameter = attrValue.getClass();
                this.checkAssignability(parameter, declared);
            }
            Object target = this.resolveTargetObject(attributeDescriptor);
            this.invokeMethod(target, method2, new Class[]{declared}, new Object[]{attrValue});
            int staleness = this.getStaleness(attributeDescriptor, mbeanDescriptor, lastUpdateField);
            if (staleness != 1) {
                attributeDescriptor.setField("value", attrValue);
                attributeDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"Attribute's value has been cached");
                }
            } else if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Always stale, avoiding to cache attribute's value");
            }
        } else {
            if (attrValue != null) {
                Class<?> parameter = attrValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(attrInfo.getType());
                this.checkAssignability(parameter, declared);
            }
            attributeDescriptor.setField("value", attrValue);
        }
        info.setDescriptor(attributeDescriptor, "attribute");
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)"Sending attribute change notifications");
        }
        this.sendAttributeChangeNotification(new Attribute(attrName, oldValue), attribute);
        boolean persistNow = this.shouldPersistNow(attributeDescriptor, mbeanDescriptor, lastUpdateField);
        if (persistNow) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Persisting this ModelMBean...");
            }
            try {
                this.store();
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"ModelMBean persisted successfully");
                }
            }
            catch (Exception x) {
                this.logger.error((Object)"Cannot store ModelMBean after setAttribute", (Throwable)x);
                if (x instanceof MBeanException) {
                    throw (MBeanException)x;
                }
                throw new MBeanException(x);
            }
        }
    }

    public Object invoke(String method2, Object[] arguments, String[] params) throws MBeanException, ReflectionException {
        Descriptor mbeanDescriptor;
        Descriptor operationDescriptor;
        ModelMBeanInfo info;
        if (method2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name cannot be null"));
        }
        method2 = method2.trim();
        if (arguments == null) {
            arguments = new Object[]{};
        }
        if (params == null) {
            params = new String[]{};
        }
        if ((info = this.getModelMBeanInfo()) == null) {
            throw new MBeanException(new ServiceNotFoundException("ModelMBeanInfo is null"));
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("ModelMBeanInfo is: " + info));
        }
        if (info.getOperations() == null) {
            throw new MBeanException(new ServiceNotFoundException("Cannot find ModelMBeanOperationInfo for operation " + method2));
        }
        ModelMBeanOperationInfo operInfo = this.selectOperationInfo(method2, params, info.getOperations());
        if (operInfo == null) {
            throw new MBeanException(new ServiceNotFoundException("Cannot find ModelMBeanOperationInfo for operation " + method2));
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Operation info is: " + operInfo));
        }
        if ((operationDescriptor = operInfo.getDescriptor()) == null) {
            throw new MBeanException(new ServiceNotFoundException("Operation descriptor for operation " + method2 + " cannot be null"));
        }
        String role = (String)operationDescriptor.getFieldValue("role");
        if (role == null || !role.equals("operation")) {
            throw new MBeanException(new ServiceNotFoundException("Operation descriptor field 'role' must be 'operation', not " + role));
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Operation descriptor is: " + operationDescriptor));
        }
        if ((mbeanDescriptor = info.getMBeanDescriptor()) == null) {
            throw new MBeanException(new ServiceNotFoundException("MBean descriptor cannot be null"));
        }
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("MBean descriptor is: " + mbeanDescriptor));
        }
        Object returnValue = null;
        String lastUpdateField = "lastReturnedTimeStamp";
        int staleness = this.getStaleness(operationDescriptor, mbeanDescriptor, lastUpdateField);
        if (staleness == 2 || staleness == 3) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Value is not Stale");
            }
            Class[] parameters = null;
            try {
                parameters = Utils.loadClasses((ClassLoader)Thread.currentThread().getContextClassLoader(), (String[])params);
            }
            catch (ClassNotFoundException x) {
                this.logger.error((Object)"Cannot find operation's parameter classes", (Throwable)x);
                throw new ReflectionException(x);
            }
            boolean found = this.isMethodExistsInRequiredModelMBean(method2, arguments, parameters);
            Object target = null;
            target = found ? this : this.resolveTargetObject(operationDescriptor);
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Invoking operation...");
            }
            returnValue = this.invokeMethod(target, method2, parameters, arguments);
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("Returned value is: " + returnValue));
            }
            if (returnValue != null) {
                Class<?> parameter = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(operInfo.getReturnType());
                this.checkAssignability(parameter, declared);
            }
            if (staleness != 1) {
                operationDescriptor.setField(LASTRETURNEDVALUE, returnValue);
                operationDescriptor.setField(lastUpdateField, new Long(System.currentTimeMillis()));
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"Returned value has been cached");
                }
                info.setDescriptor(operationDescriptor, "operation");
            }
            if (this.logger.isEnabledFor(20)) {
                this.logger.info((Object)("invoke for operation " + method2 + " returns invoked value: " + returnValue));
            }
        } else {
            returnValue = operationDescriptor.getFieldValue(LASTRETURNEDVALUE);
            if (returnValue != null) {
                Class<?> parameter = returnValue.getClass();
                Class declared = this.loadClassWithContextClassLoader(operInfo.getReturnType());
                this.checkAssignability(parameter, declared);
            }
            if (this.logger.isEnabledFor(20)) {
                this.logger.info((Object)("invoke for operation " + method2 + " returns cached value: " + returnValue));
            }
        }
        boolean persistNow = this.shouldPersistNow(operationDescriptor, null, lastUpdateField);
        int impact = operInfo.getImpact();
        if (persistNow && impact != 0) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Persisting this ModelMBean...");
            }
            try {
                this.store();
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"ModelMBean persisted successfully");
                }
            }
            catch (Exception x) {
                this.logger.error((Object)"Cannot store ModelMBean after operation invocation", (Throwable)x);
                if (x instanceof MBeanException) {
                    throw (MBeanException)x;
                }
                throw new MBeanException(x);
            }
        }
        return returnValue;
    }

    private boolean isMethodExistsInRequiredModelMBean(String method2, Object[] arguments, Class[] parameters) throws ReflectionException {
        boolean found = false;
        try {
            Method mMethod = this.getClass().getMethod(method2, parameters);
            found = true;
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return found;
    }

    private Object resolveTargetObject(Descriptor descriptor) throws MBeanException {
        Object target = descriptor.getFieldValue(TARGETOBJECT);
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)("targetObject is: " + target));
        }
        if (target == null) {
            target = this.getManagedResource();
            if (target == null) {
                throw new MBeanException(new ServiceNotFoundException("Managed resource is null"));
            }
        } else {
            String targetObjectType = (String)descriptor.getFieldValue(TARGETOBJECTTYPE);
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)("targetObjectType is: " + targetObjectType));
            }
            if (targetObjectType == null) {
                targetObjectType = OBJECT_RESOURCE_TYPE;
            }
            if (!this.isResourceTypeSupported(targetObjectType)) {
                throw new MBeanException(new InvalidTargetObjectTypeException(targetObjectType));
            }
        }
        return target;
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        throw new MBeanException(new ServiceNotFoundException("RequiredModelMBean does not support persistence"));
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        throw new MBeanException(new ServiceNotFoundException("RequiredModelMBean does not support persistence"));
    }

    protected ClassLoaderRepository getClassLoaderRepository() {
        if (this.m_mbeanServer != null) {
            return this.m_mbeanServer.getClassLoaderRepository();
        }
        return null;
    }

    private boolean shouldPersistNow(Descriptor attribute, Descriptor mbean, String lastUpdateField) {
        return false;
    }

    private int getPersistPolicy(Descriptor descriptor, Descriptor mbean) {
        String persist = (String)descriptor.getFieldValue(PERSISTPOLICY);
        if (persist == null && mbean != null) {
            persist = (String)mbean.getFieldValue(PERSISTPOLICY);
        }
        if (persist == null) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"No persist policy defined, assuming Never");
            }
            return -1;
        }
        if (persist.equals(NEVER)) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Persist never");
            }
            return -1;
        }
        if (persist.equals(ONUPDATE)) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Persist on update");
            }
            return -3;
        }
        if (persist.equals(ONTIMER)) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Persist on update");
            }
            return -2;
        }
        if (persist.equals(NOMOREOFTENTHAN)) {
            if (this.logger.isEnabledFor(0)) {
                Long period = this.getFieldTimeValue(descriptor, mbean, PERSISTPERIOD);
                this.logger.trace((Object)("Persist no more often than " + period));
            }
            return -4;
        }
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)"Invalid persist policy, assuming persist never");
        }
        return -1;
    }

    private int getStaleness(Descriptor attribute, Descriptor mbean, String lastUpdateField) {
        int returnStaleness = 2;
        Long currencyTimeLimit = this.getFieldTimeValue(attribute, mbean, CURRENCYTIMELIMIT);
        if (currencyTimeLimit == null) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"No currencyTimeLimit defined, assuming never stale");
            }
            returnStaleness = 2;
        } else {
            long ctl = currencyTimeLimit * 1000L;
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)("currencyTimeLimit is (ms): " + ctl));
            }
            if (ctl == 0L) {
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"Never stale");
                }
                returnStaleness = 2;
            } else if (ctl < 0L) {
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"Always stale");
                }
                returnStaleness = 1;
            } else {
                long now;
                Long timestamp = (Long)attribute.getFieldValue(lastUpdateField);
                long luts = 0L;
                if (timestamp != null) {
                    luts = timestamp;
                }
                if (this.logger.isEnabledFor(10)) {
                    this.logger.debug((Object)(lastUpdateField + " is: " + luts));
                }
                if ((now = System.currentTimeMillis()) < luts + ctl) {
                    if (timestamp == null) {
                        if (this.logger.isEnabledFor(0)) {
                            this.logger.trace((Object)"Stale since was never set");
                        }
                        returnStaleness = 3;
                    } else {
                        if (this.logger.isEnabledFor(0)) {
                            this.logger.trace((Object)"Not stale");
                        }
                        returnStaleness = 4;
                    }
                } else {
                    if (this.logger.isEnabledFor(0)) {
                        this.logger.trace((Object)"Stale");
                    }
                    returnStaleness = 3;
                }
            }
        }
        return returnStaleness;
    }

    private Long getFieldTimeValue(Descriptor descriptor, Descriptor mbean, String field) {
        Object value = descriptor.getFieldValue(field);
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Descriptor's " + field + " field: " + value));
        }
        if (value == null && mbean != null) {
            value = mbean.getFieldValue(field);
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("MBean's " + field + " field: " + value));
            }
            if (value == null) {
                return null;
            }
        }
        if (value instanceof Number) {
            return new Long(((Number)value).longValue());
        }
        if (value instanceof String) {
            try {
                long ctl = Long.parseLong((String)value);
                return new Long(ctl);
            }
            catch (NumberFormatException x) {
                return new Long(0L);
            }
        }
        return new Long(0L);
    }

    private Object invokeMethod(Object target, String methodName, Class[] params, Object[] args) throws MBeanException, ReflectionException {
        try {
            Method method2 = target.getClass().getMethod(methodName, params);
            Object value = method2.invoke(target, args);
            if (this.logger.isEnabledFor(10)) {
                this.logger.info((Object)("Method invocation returned value: " + value));
            }
            return value;
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new MBeanException(x);
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof Error) {
                throw new MBeanException(new RuntimeErrorException((Error)t));
            }
            if (t instanceof IllegalArgumentException) {
                throw new MBeanException((IllegalArgumentException)t);
            }
            if (t instanceof RuntimeOperationsException) {
                throw new MBeanException((Exception)t);
            }
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            throw new MBeanException((Exception)t);
        }
    }

    private Logger getModelMBeanLogger(String notificationType) throws MBeanException {
        ModelMBeanInfo info = this.getModelMBeanInfo();
        Descriptor descriptor = null;
        Logger modelMBeanLogger = null;
        if (notificationType != null) {
            descriptor = info.getDescriptor(notificationType, "notification");
            modelMBeanLogger = this.findLogger(descriptor);
        }
        if (modelMBeanLogger == null && (modelMBeanLogger = this.findLogger(descriptor = info.getMBeanDescriptor())) != null) {
            return modelMBeanLogger;
        }
        return null;
    }

    private Logger findLogger(Descriptor descriptor) {
        if (descriptor == null) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Can't find MBean logger, descriptor is null");
            }
            return null;
        }
        String log = (String)descriptor.getFieldValue("log");
        String location = (String)descriptor.getFieldValue("logFile");
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Log fields: log=" + log + ", file=" + location));
        }
        if (log == null || !Boolean.valueOf(log).booleanValue()) {
            this.logger.info((Object)"Logging is not supported by this ModelMBean");
            return null;
        }
        if (location == null) {
            location = (String)descriptor.getFieldValue("logMBean");
            if (this.logger.isEnabledFor(10)) {
                this.logger.debug((Object)("Log fields: mbean=" + location));
            }
            if (location == null) {
                this.logger.trace((Object)"Logging is not supported by this ModelMBean");
                return null;
            }
            try {
                ObjectName objectName = new ObjectName(location);
                MBeanServer server = this.getMBeanServer();
                if (server == null) {
                    throw new MBeanException(new IllegalStateException("RequiredModelMBean is not registered"));
                }
                if (server.isRegistered(objectName)) {
                    MBeanLogger l = new MBeanLogger(server, objectName);
                    this.logger.info((Object)("ModelMBean log supported by delegating to this MBean: " + objectName));
                    return l;
                }
                return null;
            }
            catch (MalformedObjectNameException x) {
                this.logger.info((Object)("Specified logMBean field does not contain a valid ObjectName: " + location));
                return null;
            }
            catch (MBeanException x) {
                this.logger.warn((Object)"logMBean field does not specify an MBean that supports logging delegation", (Throwable)x);
                return null;
            }
        }
        this.logger.info((Object)"ModelMBean log supported on file system");
        return new FileLogger(location);
    }

    private NotificationBroadcasterSupport getGeneralNotificationBroadcaster() {
        return this.m_generalBroadcaster;
    }

    private NotificationBroadcasterSupport getAttributeChangeBroadcaster() {
        return this.m_attributeChangeBroadcaster;
    }

    private MBeanServer getMBeanServer() {
        return this.m_mbeanServer;
    }

    private ModelMBeanInfo getModelMBeanInfo() {
        return this.m_modelMBeanInfo;
    }

    private PersisterMBean findPersister() throws MBeanException, InstanceNotFoundException {
        ModelMBeanInfo info = this.getModelMBeanInfo();
        if (info == null) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Can't find persister, ModelMBeanInfo is null");
            }
            return null;
        }
        Descriptor mbeanDescriptor = info.getMBeanDescriptor();
        if (mbeanDescriptor == null) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Can't find persister, MBean descriptor is null");
            }
            return null;
        }
        String location = (String)mbeanDescriptor.getFieldValue(PERSISTLOCATION);
        String name = (String)mbeanDescriptor.getFieldValue(PERSISTNAME);
        String mbeanName = (String)mbeanDescriptor.getFieldValue(NAME);
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Persistence fields: location=" + location + ", name=" + name));
        }
        if (mbeanName == null && name == null) {
            if (this.logger.isEnabledFor(20)) {
                this.logger.info((Object)"Persistence is not supported by this ModelMBean");
            }
            return null;
        }
        if (name != null) {
            try {
                ObjectName objectName = new ObjectName(name.trim());
                MBeanServer server = this.getMBeanServer();
                if (server == null) {
                    throw new MBeanException(new IllegalStateException("RequiredModelMBean is not registered"));
                }
                if (server.isRegistered(objectName) && server.isInstanceOf(objectName, "mx4j.persist.PersisterMBean")) {
                    MBeanPersister persister = new MBeanPersister(server, objectName);
                    if (this.logger.isEnabledFor(10)) {
                        this.logger.debug((Object)("Persistence is delegated to this MBean: " + objectName));
                    }
                    return persister;
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
            catch (MalformedObjectNameException ignored) {
                if (this.logger.isEnabledFor(0)) {
                    this.logger.trace((Object)"Persistence is not delegated to another MBean");
                }
                FilePersister persister = new FilePersister(location, name);
                if (this.logger.isEnabledFor(10)) {
                    this.logger.debug((Object)("Persistence is realized through file system in " + persister.getFileName()));
                }
                return persister;
            }
        }
        FilePersister persister = new FilePersister(location, mbeanName);
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("Persistence is realized through file system in " + persister.getFileName()));
        }
        return persister;
    }

    private Class loadClassWithContextClassLoader(String name) {
        try {
            return Utils.loadClass((ClassLoader)Thread.currentThread().getContextClassLoader(), (String)name);
        }
        catch (ClassNotFoundException x) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Cannot find attribute's declared return class", (Throwable)x);
            }
            return null;
        }
    }

    private void checkAssignability(Class parameter, Class declared) throws MBeanException {
        if (this.logger.isEnabledFor(10)) {
            this.logger.debug((Object)("The class of the parameter is: " + parameter));
            if (parameter != null) {
                this.logger.debug((Object)("The classloder of the parameter's class is: " + parameter.getClassLoader()));
            }
            this.logger.debug((Object)("The class declared as type of the attribute is: " + declared));
            if (declared != null) {
                this.logger.debug((Object)("The classloader of the declared parameter's class is: " + declared.getClassLoader()));
            }
        }
        boolean assignable = false;
        assignable = declared == null || parameter == null ? false : (declared == Boolean.TYPE && parameter == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = RequiredModelMBean.class$("java.lang.Boolean")) : class$java$lang$Boolean) ? true : (declared == Byte.TYPE && parameter == (class$java$lang$Byte == null ? (class$java$lang$Byte = RequiredModelMBean.class$("java.lang.Byte")) : class$java$lang$Byte) ? true : (declared == Character.TYPE && parameter == (class$java$lang$Character == null ? (class$java$lang$Character = RequiredModelMBean.class$("java.lang.Character")) : class$java$lang$Character) ? true : (declared == Short.TYPE && parameter == (class$java$lang$Short == null ? (class$java$lang$Short = RequiredModelMBean.class$("java.lang.Short")) : class$java$lang$Short) ? true : (declared == Integer.TYPE && parameter == (class$java$lang$Integer == null ? (class$java$lang$Integer = RequiredModelMBean.class$("java.lang.Integer")) : class$java$lang$Integer) ? true : (declared == Long.TYPE && parameter == (class$java$lang$Long == null ? (class$java$lang$Long = RequiredModelMBean.class$("java.lang.Long")) : class$java$lang$Long) ? true : (declared == Float.TYPE && parameter == (class$java$lang$Float == null ? (class$java$lang$Float = RequiredModelMBean.class$("java.lang.Float")) : class$java$lang$Float) ? true : (declared == Double.TYPE && parameter == (class$java$lang$Double == null ? (class$java$lang$Double = RequiredModelMBean.class$("java.lang.Double")) : class$java$lang$Double) ? true : declared.isAssignableFrom(parameter)))))))));
        if (!assignable) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Parameter value's class and attribute's declared return class are not assignable");
            }
            throw new MBeanException(new InvalidAttributeValueException("Returned type and declared type are not assignable"));
        }
    }

    private ModelMBeanOperationInfo selectOperationInfo(String name, String[] sig, MBeanOperationInfo[] ops) {
        ModelMBeanOperationInfo result = null;
        for (int i = 0; i < ops.length; ++i) {
            if (name.compareTo(ops[i].getName()) != 0 || !this.matchOpSignature(sig, ops[i])) continue;
            result = (ModelMBeanOperationInfo)ops[i];
            break;
        }
        return result;
    }

    private boolean matchOpSignature(String[] sig, MBeanOperationInfo op) {
        boolean result = false;
        MBeanParameterInfo[] opsig = op.getSignature();
        if (sig.length == opsig.length) {
            boolean matched = true;
            for (int i = 0; i < sig.length; ++i) {
                if (sig[i].compareTo(opsig[i].getType()) == 0) continue;
                matched = false;
                break;
            }
            result = matched;
        }
        return result;
    }

    private MBeanNotificationInfo[] addRequiredNotifications(MBeanNotificationInfo[] notifs, boolean hasgeneric, boolean hasattrchage) {
        ArrayList<ModelMBeanNotificationInfo> nl = new ArrayList<ModelMBeanNotificationInfo>();
        if (!hasgeneric) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Adding GENERIC Notification to ModelMBeanInfo");
            }
            nl.add(new ModelMBeanNotificationInfo(new String[]{JMX_MODELMBEAN_GENERIC}, GENERIC_NOTIFICATION, "Generic JMX Notification", new DescriptorSupport(new String[]{"name=GENERIC", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.modelmbean.generic"})));
        }
        if (!hasattrchage) {
            if (this.logger.isEnabledFor(0)) {
                this.logger.trace((Object)"Adding ATTRIBUTE_CHANGE Notification to ModelMBeanInfo");
            }
            nl.add(new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, ATTRCHANGE_NOTIFICATION, "JMX Attribute Change Notification", new DescriptorSupport(new String[]{"name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=6", "displayName=jmx.modelmbean.generic"})));
        }
        this.copyNotifications(nl, notifs);
        MBeanNotificationInfo[] result = nl.toArray(new ModelMBeanNotificationInfo[0]);
        if (this.logger.isEnabledFor(0)) {
            this.logger.trace((Object)("Resulting ModelMBeanInfo [" + result.toString() + "]"));
        }
        return result;
    }

    private void copyNotifications(List nl, MBeanNotificationInfo[] notifs) {
        for (int i = 0; notifs != null && i < notifs.length; ++i) {
            nl.add(notifs[i]);
        }
    }

    private boolean hasNotification(MBeanNotificationInfo[] notifs, String notif) {
        boolean result = false;
        for (int i = 0; i < notifs.length && !result; ++i) {
            ModelMBeanNotificationInfo ni = (ModelMBeanNotificationInfo)notifs[i];
            if (ni == null || !notif.equals(ni.getName())) continue;
            result = true;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

