/*
 * Decompiled with CFR 0.152.
 */
package javax.management.loading;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ServiceNotFoundException;
import javax.management.loading.ClassLoaderRepository;
import javax.management.loading.MLetContent;
import javax.management.loading.MLetMBean;
import mx4j.loading.ClassLoaderObjectInputStream;
import mx4j.loading.MLetParseException;
import mx4j.loading.MLetParser;
import mx4j.loading.MLetTag;
import mx4j.log.Log;
import mx4j.log.Logger;

public class MLet
extends URLClassLoader
implements MLetMBean,
MBeanRegistration,
Externalizable {
    private MBeanServer server;
    private ObjectName objectName;
    private boolean delegateToCLR;
    private ThreadLocal loadingOnlyLocally = new ThreadLocal();
    private ThreadLocal loadingWithRepository = new ThreadLocal();
    private String libraryDir;

    public MLet() {
        this(new URL[0]);
    }

    public MLet(URL[] urls) {
        this(urls, true);
    }

    public MLet(URL[] urls, boolean delegateToCLR) {
        super(urls);
        this.setDelegateToCLR(delegateToCLR);
        this.loadingWithRepository.set(Boolean.FALSE);
        this.loadingOnlyLocally.set(Boolean.FALSE);
    }

    public MLet(URL[] urls, ClassLoader parent) {
        this(urls, parent, true);
    }

    public MLet(URL[] urls, ClassLoader parent, boolean delegateToCLR) {
        super(urls, parent);
        this.setDelegateToCLR(delegateToCLR);
        this.loadingWithRepository.set(Boolean.FALSE);
        this.loadingOnlyLocally.set(Boolean.FALSE);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        this(urls, parent, factory, true);
    }

    public MLet(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory, boolean delegateToCLR) {
        super(urls, parent, factory);
        this.setDelegateToCLR(delegateToCLR);
        this.loadingWithRepository.set(Boolean.FALSE);
        this.loadingOnlyLocally.set(Boolean.FALSE);
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.server = server;
        this.objectName = name == null ? new ObjectName(this.server.getDefaultDomain(), "type", "MLet") : name;
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.trace((Object)("MLet service " + this.objectName + " preRegistered successfully"));
        }
        return this.objectName;
    }

    public void postRegister(Boolean registrationDone) {
        Logger logger = this.getLogger();
        boolean done = registrationDone;
        if (!done) {
            this.server = null;
            logger.warn((Object)("MLet service " + this.objectName + " was not registered"));
        } else if (logger.isEnabledFor(0)) {
            logger.trace((Object)("MLet service " + this.objectName + " postRegistered successfully"));
        }
    }

    public void preDeregister() throws Exception {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug((Object)("MLet service " + this.objectName + " preDeregistered successfully"));
        }
    }

    public void postDeregister() {
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(0)) {
            logger.debug((Object)("MLet service " + this.objectName + " postDeregistered successfully"));
        }
    }

    public void addURL(String url) throws ServiceNotFoundException {
        this.addURL(this.createURL(url));
    }

    public void addURL(URL url) {
        Logger logger = this.getLogger();
        if (!Arrays.asList(this.getURLs()).contains(url)) {
            if (logger.isEnabledFor(20)) {
                logger.info((Object)("Adding URL to this MLet (" + this.objectName + ") classpath: " + url));
            }
            super.addURL(url);
        } else if (logger.isEnabledFor(20)) {
            logger.info((Object)("URL already present in this MLet (" + this.objectName + ") classpath: " + url));
        }
    }

    public Class loadClass(String name, ClassLoaderRepository repository2) throws ClassNotFoundException {
        if (repository2 == null) {
            Class cls = this.loadClassLocally(name);
            return cls;
        }
        try {
            Class cls = this.loadClassLocally(name);
            return cls;
        }
        catch (ClassNotFoundException x) {
            Class cls = this.loadClassFromRepository(name, repository2);
            return cls;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class loadClassLocally(String name) throws ClassNotFoundException {
        try {
            this.loadingOnlyLocally.set(Boolean.TRUE);
            Class<?> clazz = this.loadClass(name);
            return clazz;
        }
        finally {
            this.loadingOnlyLocally.set(Boolean.FALSE);
        }
    }

    private Class loadClassFromRepository(String name, ClassLoaderRepository repository2) throws ClassNotFoundException {
        return repository2.loadClassBefore(this, name);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Logger logger = this.getLogger();
        if (this.loadingWithRepository.get() == Boolean.TRUE) {
            if (logger.isEnabledFor(0)) {
                logger.trace((Object)("MLet " + this + " is recursively calling itself to load class " + name + ": skipping further searches"));
            }
            throw new ClassNotFoundException(name);
        }
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Finding class " + name + "..."));
        }
        try {
            Class cls = this.findClassLocally(name);
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Class " + name + " found in this MLet's classpath " + this));
            }
            return cls;
        }
        catch (ClassNotFoundException x) {
            if (!this.isDelegateToCLR()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("MLet " + this + " does not delegate to the ClassLoaderRepository"));
                }
                throw x;
            }
            if (this.loadingOnlyLocally.get() == Boolean.TRUE) {
                throw x;
            }
            if (this.server == null) {
                throw x;
            }
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Class " + name + " not found in this MLet's classpath " + this + ", trying the ClassLoaderRepository..."), (Throwable)x);
            }
            try {
                this.loadingWithRepository.set(Boolean.TRUE);
                ClassLoaderRepository repository2 = this.server.getClassLoaderRepository();
                Class cls = this.loadClassFromRepository(name, repository2);
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Class " + name + " found with ClassLoaderRepository " + repository2));
                }
                Class clazz = cls;
                return clazz;
            }
            catch (ClassNotFoundException xx) {
                if (logger.isEnabledFor(10)) {
                    logger.debug((Object)("Class " + name + " not found in ClassLoaderRepository, giving up"), (Throwable)xx);
                }
                throw new ClassNotFoundException(name);
            }
            finally {
                this.loadingWithRepository.set(Boolean.FALSE);
            }
        }
    }

    private Class findClassLocally(String name) throws ClassNotFoundException {
        String clsName = name;
        if (clsName != null && clsName.endsWith(".class")) {
            clsName = clsName.substring(0, clsName.length() - 6);
        }
        return super.findClass(clsName);
    }

    public Set getMBeansFromURL(String url) throws ServiceNotFoundException {
        return this.getMBeansFromURL(this.createURL(url));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set getMBeansFromURL(URL url) throws ServiceNotFoundException {
        if (url == null) {
            throw new ServiceNotFoundException("Cannot load MBeans from null URL");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("MLet " + this + ", reading MLET file from " + url));
        }
        InputStream is = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream os2 = new BufferedOutputStream(baos);
        try {
            try {
                is = url.openStream();
                this.readFromAndWriteTo(is, os2);
            }
            catch (IOException x) {
                if (!logger.isEnabledFor(10)) throw new ServiceNotFoundException(x.toString());
                logger.debug((Object)("Cannot read input stream from URL " + url), (Throwable)x);
                throw new ServiceNotFoundException(x.toString());
            }
            Object var8_6 = null;
            {
            }
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (is != null) {
                    is.close();
                }
                os2.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        if (is != null) {
            is.close();
        }
        os2.close();
        String mletFileContent = baos.toString();
        if (!logger.isEnabledFor(0)) return this.parseMLetFile(mletFileContent, url);
        logger.trace((Object)("MLet File content is:\n" + mletFileContent));
        return this.parseMLetFile(mletFileContent, url);
    }

    private Set parseMLetFile(String content, URL mletFileURL) throws ServiceNotFoundException {
        Logger logger = this.getLogger();
        try {
            HashSet<Object> mbeans = new HashSet<Object>();
            MLetParser parser2 = new MLetParser(this);
            List tags = parser2.parse(content);
            for (int i = 0; i < tags.size(); ++i) {
                MLetTag tag = (MLetTag)tags.get(i);
                String[] jars = tag.parseArchive();
                for (int j = 0; j < jars.length; ++j) {
                    String jar = jars[j];
                    URL codebase = this.handleCheck(tag, jar, mletFileURL, mbeans);
                    URL archiveURL = tag.createArchiveURL(codebase, jar);
                    this.addURL(archiveURL);
                }
                Object obj = this.createMBean(tag);
                mbeans.add(obj);
            }
            return mbeans;
        }
        catch (MLetParseException x) {
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)"Cannot parse MLet file", (Throwable)x);
            }
            throw new ServiceNotFoundException(x.toString());
        }
    }

    private URL handleCheck(MLetTag tag, String archive, URL mletFileURL, Set mbeans) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("codebaseURL", tag.normalizeCodeBase(mletFileURL));
        map.put("codebase", tag.getCodeBase());
        map.put("archive", tag.getArchive());
        map.put("code", tag.getCode());
        map.put("object", tag.getObject());
        map.put("name", tag.getObjectName().getCanonicalName());
        map.put("version", tag.getVersion());
        MLetContent mletContent = new MLetContent(mletFileURL, map);
        try {
            return this.check(mletContent.getVersion(), mletContent.getCodeBase(), archive, mletContent);
        }
        catch (Throwable x) {
            mbeans.add(x);
            return null;
        }
    }

    protected URL check(String version, URL codebase, String archive, MLetContent content) throws Exception {
        return codebase;
    }

    private Object createMBean(MLetTag tag) throws ServiceNotFoundException {
        if (this.server == null) {
            throw new ServiceNotFoundException("MLet not registered on the MBeanServer");
        }
        Logger logger = this.getLogger();
        if (logger.isEnabledFor(20)) {
            logger.info((Object)("MLet " + this + ", creating MBean from\n" + tag));
        }
        try {
            Object mbean = null;
            if (tag.getObject() != null) {
                String name = tag.getObject();
                InputStream is = this.getResourceAsStream(name);
                if (is == null) {
                    throw new ServiceNotFoundException("Cannot find serialized MBean " + name + " in MLet " + this);
                }
                BufferedInputStream bis = new BufferedInputStream(is);
                ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream((InputStream)bis, (ClassLoader)this);
                mbean = ois.readObject();
            } else {
                String clsName = tag.getCode();
                if (clsName != null && clsName.endsWith(".class")) {
                    clsName = clsName.substring(0, clsName.length() - 6);
                }
                Object[] args = tag.getArguments();
                String[] params = tag.getSignature();
                mbean = this.server.instantiate(clsName, this.objectName, args, params);
            }
            ObjectName objectName = tag.getObjectName();
            ObjectInstance instance = this.server.registerMBean(mbean, objectName);
            return instance;
        }
        catch (Throwable t) {
            return t;
        }
    }

    protected String findLibrary(String libraryName) {
        final String sysLibraryName = System.mapLibraryName(libraryName);
        String path = this.copyLibrary(sysLibraryName);
        if (path != null) {
            return path;
        }
        String osPath = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StringBuffer buffer = new StringBuffer();
                buffer.append(System.getProperty("os.name")).append(File.separator);
                buffer.append(System.getProperty("os.arch")).append(File.separator);
                buffer.append(System.getProperty("os.version")).append(File.separator);
                buffer.append("lib").append(File.separator).append(sysLibraryName);
                return buffer.toString();
            }
        });
        osPath = this.removeSpaces(osPath);
        return this.copyLibrary(osPath);
    }

    private String copyLibrary(String library) {
        Logger logger = this.getLogger();
        library = library.replace('\\', '/');
        if (logger.isEnabledFor(10)) {
            logger.debug((Object)("Loading library " + library));
        }
        InputStream is = null;
        BufferedOutputStream os2 = null;
        try {
            is = this.getResourceAsStream(library);
            if (is == null) {
                return null;
            }
            is = new BufferedInputStream(is);
            File file = new File(this.getLibraryDirectory(), library);
            if (file.exists()) {
                file.delete();
            }
            os2 = new BufferedOutputStream(new FileOutputStream(file));
            this.readFromAndWriteTo(is, os2);
            ((OutputStream)os2).close();
            is.close();
            return file.getCanonicalPath();
        }
        catch (IOException x) {
            if (logger.isEnabledFor(10)) {
                logger.debug((Object)("Cannot copy the library to the library directory " + this.getLibraryDirectory()), (Throwable)x);
            }
            return null;
        }
    }

    private void readFromAndWriteTo(InputStream is, OutputStream os2) throws IOException {
        byte[] buffer = new byte[512];
        int read = -1;
        while ((read = is.read(buffer)) >= 0) {
            os2.write(buffer, 0, read);
        }
    }

    private String removeSpaces(String string) {
        int space = -1;
        StringBuffer buffer = new StringBuffer();
        while ((space = string.indexOf(32)) >= 0) {
            buffer.append(string.substring(0, space));
            string = string.substring(space + 1);
        }
        buffer.append(string);
        return buffer.toString();
    }

    public String getLibraryDirectory() {
        return this.libraryDir;
    }

    public void setLibraryDirectory(String libdir) {
        this.libraryDir = libdir;
    }

    private boolean isDelegateToCLR() {
        return this.delegateToCLR;
    }

    private void setDelegateToCLR(boolean delegateToCLR) {
        this.delegateToCLR = delegateToCLR;
    }

    private URL createURL(String urlString) throws ServiceNotFoundException {
        try {
            URL url = new URL(urlString);
            return url;
        }
        catch (MalformedURLException x) {
            throw new ServiceNotFoundException(x.toString());
        }
    }

    private Logger getLogger() {
        return Log.getLogger((String)this.getClass().getName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new UnsupportedOperationException("MLet.readExternal");
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        throw new UnsupportedOperationException("MLet.writeExternal");
    }
}

