/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.component;

import com.ibm.ws.security.util.AccessController;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.PrivilegedAction;
import java.util.Arrays;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;

class MethodBindingMethodExpressionAdapter
extends MethodBinding
implements StateHolder,
Serializable {
    private static final long serialVersionUID = 7334926223014401689L;
    private static boolean securityManager = System.getSecurityManager() != null;
    private MethodExpression methodExpression = null;
    private boolean tranzient;

    public MethodBindingMethodExpressionAdapter() {
    }

    MethodBindingMethodExpressionAdapter(MethodExpression methodExpression) {
        this.methodExpression = methodExpression;
    }

    @Override
    public Object invoke(FacesContext context, Object[] params) throws EvaluationException, javax.faces.el.MethodNotFoundException {
        assert (null != this.methodExpression);
        if (context == null) {
            throw new NullPointerException("FacesConext -> null");
        }
        Object result = null;
        try {
            result = this.methodExpression.invoke(context.getELContext(), params);
        }
        catch (MethodNotFoundException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        catch (PropertyNotFoundException e) {
            throw new EvaluationException(e);
        }
        catch (ELException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            throw new EvaluationException(cause);
        }
        catch (NullPointerException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        return result;
    }

    @Override
    public Class getType(FacesContext context) throws javax.faces.el.MethodNotFoundException {
        assert (null != this.methodExpression);
        if (context == null) {
            throw new NullPointerException("FacesConext -> null");
        }
        Class<?> result = null;
        if (context == null) {
            throw new NullPointerException();
        }
        try {
            MethodInfo mi = this.methodExpression.getMethodInfo(context.getELContext());
            result = mi.getReturnType();
        }
        catch (PropertyNotFoundException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        catch (MethodNotFoundException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        catch (ELException e) {
            throw new javax.faces.el.MethodNotFoundException(e);
        }
        return result;
    }

    @Override
    public String getExpressionString() {
        assert (null != this.methodExpression);
        return this.methodExpression.getExpressionString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MethodBindingMethodExpressionAdapter) {
            return this.methodExpression.equals(((MethodBindingMethodExpressionAdapter)other).getWrapped());
        }
        if (other instanceof MethodBinding) {
            Method[] methods;
            MethodBinding binding = (MethodBinding)other;
            String expr = binding.getExpressionString();
            int idx = expr.indexOf(46);
            String target = expr.substring(0, idx).substring(2);
            String t = expr.substring(idx + 1);
            String method2 = t.substring(0, t.length() - 1);
            FacesContext context = FacesContext.getCurrentInstance();
            ELContext elContext = context.getELContext();
            MethodInfo controlInfo = this.methodExpression.getMethodInfo(elContext);
            if (!controlInfo.getName().equals(method2)) {
                return false;
            }
            ExpressionFactory factory = context.getApplication().getExpressionFactory();
            ValueExpression ve = factory.createValueExpression(elContext, "#{" + target + '}', Object.class);
            if (ve == null) {
                return false;
            }
            Object result = ve.getValue(elContext);
            if (result == null) {
                return false;
            }
            Class type = binding.getType(context);
            for (Method meth : methods = result.getClass().getMethods()) {
                if (!meth.getName().equals(method2) || !type.equals(controlInfo.getReturnType()) || !Arrays.equals(meth.getParameterTypes(), controlInfo.getParamTypes())) continue;
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        assert (null != this.methodExpression);
        return this.methodExpression.hashCode();
    }

    @Override
    public boolean isTransient() {
        return this.tranzient;
    }

    @Override
    public void setTransient(boolean tranzient) {
        this.tranzient = tranzient;
    }

    @Override
    public Object saveState(FacesContext context) {
        Object[] result = null;
        if (!this.tranzient) {
            if (this.methodExpression instanceof StateHolder) {
                Object[] stateStruct = new Object[]{((StateHolder)((Object)this.methodExpression)).saveState(context), this.methodExpression.getClass().getName()};
                result = stateStruct;
            } else {
                result = this.methodExpression;
            }
        }
        return result;
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        if (null == state) {
            return;
        }
        if (!(state instanceof MethodExpression)) {
            Object[] stateStruct = (Object[])state;
            Object savedState = stateStruct[0];
            String className = stateStruct[1].toString();
            MethodExpression result = null;
            Class toRestoreClass = null;
            if (null != className) {
                try {
                    toRestoreClass = MethodBindingMethodExpressionAdapter.loadClass(className, this);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                if (null != toRestoreClass) {
                    try {
                        result = (MethodExpression)toRestoreClass.newInstance();
                    }
                    catch (InstantiationException e) {
                        throw new IllegalStateException(e.getMessage());
                    }
                    catch (IllegalAccessException a) {
                        throw new IllegalStateException(a.getMessage());
                    }
                }
                if (null != result && null != savedState) {
                    ((StateHolder)((Object)result)).restoreState(context, savedState);
                }
                this.methodExpression = result;
            }
        } else {
            this.methodExpression = (MethodExpression)state;
        }
    }

    public MethodExpression getWrapped() {
        return this.methodExpression;
    }

    private static Class loadClass(String name, final Object fallbackClass) throws ClassNotFoundException {
        if (securityManager) {
            Object cl = AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return Thread.currentThread().getContextClassLoader();
                }
            });
            if (cl == null) {
                cl = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fallbackClass.getClass().getClassLoader();
                    }
                });
            }
            return Class.forName(name, false, (ClassLoader)cl);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return Class.forName(name, false, loader);
    }
}

