/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.util.Logger;
import com.ibm.trl.util.xml.QName;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import java.util.Hashtable;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SOAPIDResolver
implements IDResolver {
    private final Hashtable idTypeAttrTable = new Hashtable();

    public SOAPIDResolver() {
        this(null);
    }

    public SOAPIDResolver(QName[] idTypeAttrs) {
        if (idTypeAttrs != null) {
            for (int i = 0; i < idTypeAttrs.length; ++i) {
                this.addIDTypeAttr(idTypeAttrs[i]);
            }
        }
    }

    public void addIDTypeAttr(QName qname) {
        this.idTypeAttrTable.put(qname, qname);
    }

    public void removeIDTypeAttr(QName qname) {
        this.idTypeAttrTable.remove(qname);
    }

    public Element resolveID(Document doc, String id) {
        Logger.normal("Resolving ID: " + id + ", id type attributes: " + this.idTypeAttrTable, 0);
        if (doc == null) {
            return null;
        }
        Element elem = this.resolveID(doc.getDocumentElement(), id);
        return elem;
    }

    private Element resolveID(Element element, String id) {
        if (this.hasID(element, id)) {
            return element;
        }
        NodeList list = element.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Element elem;
            Node node = list.item(i);
            if (node.getNodeType() != 1 || (elem = this.resolveID((Element)node, id)) == null) continue;
            return elem;
        }
        return null;
    }

    private boolean hasID(Element elem, String id) {
        NamedNodeMap map = elem.getAttributes();
        int length = map.getLength();
        for (int i = 0; i < length; ++i) {
            Attr attr = (Attr)map.item(i);
            String uri = attr.getNamespaceURI();
            uri = uri == null ? "" : uri;
            String name = attr.getLocalName();
            String string = name = name == null ? attr.getName() : name;
            if (this.idTypeAttrTable.get(new QName(uri, name)) == null || !id.equals(attr.getValue())) continue;
            return true;
        }
        return false;
    }
}

