/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security.dsig;

import com.ibm.trl.util.Logger;
import com.ibm.ws.wssecurity.xss4j.dsig.XSignatureException;
import com.ibm.xml.soap.security.util.CertificateUtil;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Element;

final class PKIXChecker {
    private final PKIXBuilderParameters template;

    PKIXChecker(KeyStore keyStore) throws SOAPException {
        try {
            X509CertSelector selector = new X509CertSelector();
            this.template = new PKIXBuilderParameters(keyStore, (CertSelector)selector);
            this.template.setDate(null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid KeyStore", e);
        }
        catch (KeyStoreException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid KeyStore", e);
        }
    }

    PKIXChecker(Set trustedCertificates) throws SOAPException {
        try {
            Iterator iterator = trustedCertificates.iterator();
            HashSet<TrustAnchor> set = new HashSet<TrustAnchor>();
            while (iterator.hasNext()) {
                X509Certificate cert = (X509Certificate)iterator.next();
                TrustAnchor anchor = new TrustAnchor(cert, null);
                set.add(anchor);
            }
            X509CertSelector selector = new X509CertSelector();
            this.template = new PKIXBuilderParameters(set, (CertSelector)selector);
            this.template.setDate(null);
        }
        catch (ClassCastException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Unexpected class", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid algorithm parameter", e);
        }
    }

    Key check(Element signature) throws SOAPException {
        Exception lastException = null;
        try {
            PKIXBuilderParameters params = (PKIXBuilderParameters)this.template.clone();
            CertificateUtil.X509DataUtil[] utils = CertificateUtil.getX509Data(signature);
            Logger.normal("Calling CertificateUtil.verify()...", 0);
            for (int i = 0; i < utils.length; ++i) {
                try {
                    return this.check(signature, params, utils[i]);
                }
                catch (XSignatureException e) {
                    lastException = e.getException();
                    continue;
                }
                catch (IOException e) {
                    lastException = e;
                }
            }
        }
        catch (XSignatureException e) {
            lastException = e.getException();
        }
        Logger.normal("CertificateUtil.verify() Done.", 0);
        throw new SOAPException(Constants.FAULT_CODE_CLIENT, "Invalid certpath", lastException);
    }

    Key check(Element signature, PKIXBuilderParameters params, CertificateUtil.X509DataUtil util2) throws XSignatureException, IOException {
        X509CertSelector selector = util2.createSelector();
        Date date = new Date();
        selector.setCertificateValid(date);
        params.setDate(date);
        params.setTargetCertConstraints(selector);
        return util2.validate(params);
    }

    PKIXBuilderParameters getTemplate() {
        return this.template;
    }
}

