/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.soap.security;

import com.ibm.trl.util.Logger;
import com.ibm.xml.soap.security.util.PasswordAgent;
import com.ibm.xml.soap.transport.AbstractSOAPHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.w3c.dom.Element;

public abstract class SOAPSecurityHandler
extends AbstractSOAPHandler {
    private static final String[] SECURITY_PROVIDERS;
    static final String RES_INPUT_KEYSTOREPASS = "Please input keystore password";

    private static synchronized void addSecurityProvider(String name) {
        try {
            Class<?> cls = Class.forName(name);
            try {
                Security.addProvider((Provider)cls.newInstance());
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected KeyStore getKeyStore(Element keyStore) throws SOAPException {
        String type = keyStore.getAttribute("type");
        String path = keyStore.getAttribute("path");
        char[] storepass = keyStore.getAttribute("storepass").toCharArray();
        if (storepass.length == 0) {
            storepass = PasswordAgent.show("Please input keystore password for \"" + path + "\"");
        }
        if (storepass == null) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Can't get the keystore password: " + path);
        }
        Logger.normal("KeyStore type: " + type, 3);
        Logger.normal("KeyStore path: " + path, 3);
        Logger.normal("KeyStore password: " + new String(storepass), 3);
        return this.createKeyStore(type, path, storepass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore createKeyStore(String type, String path, char[] storepass) throws SOAPException {
        try {
            KeyStore keyStore = KeyStore.getInstance(type);
            InputStream in = null;
            try {
                in = new FileInputStream(new File(this.home, path));
                keyStore.load(in, storepass);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
            return keyStore;
        }
        catch (FileNotFoundException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "File not found: " + path, e);
        }
        catch (IOException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "IO error occured while reading " + path, e);
        }
        catch (CertificateException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Certificate error occured while loading a key store '" + path + "'", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Encountered unknown algorithm while loading a keystore '" + path + "'", e);
        }
        catch (KeyStoreException e) {
            throw new SOAPException(Constants.FAULT_CODE_SERVER, "Unknown key store type: " + type, e);
        }
    }

    static {
        int i;
        SECURITY_PROVIDERS = new String[]{"sun.security.provider.Sun", "com.ibm.crypto.provider.IBMJCE", "com.ibm.security.cert.IBMCertPath"};
        Logger.normal("Removing all security providers", 3);
        Provider[] providers = Security.getProviders();
        for (i = 0; i < providers.length; ++i) {
            Security.removeProvider(providers[i].getName());
        }
        for (i = 0; i < SECURITY_PROVIDERS.length; ++i) {
            SOAPSecurityHandler.addSecurityProvider(SECURITY_PROVIDERS[i]);
        }
        providers = Security.getProviders();
        Logger.normal("Registered security providers:", 3);
        for (i = 0; i < providers.length; ++i) {
            Logger.normal("provider[" + i + "]=" + providers[i].getName(), 3);
        }
    }
}

