/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.wssecurity.config.KRBSPN;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import com.ibm.wsspi.wssecurity.token.KRBToken;
import java.util.HashMap;

public class KRBTokenInfo
extends KRBToken {
    private static TraceComponent tc = null;
    private byte[] token = null;
    private byte[] sessionSubKey = null;
    private String serviceName = "";
    private String kerberosRealm = "";

    public KRBTokenInfo(HashMap properties) {
        super(properties);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBTokenInfo");
        }
        if (properties != null) {
            this.token = (byte[])properties.get("KRBToken");
            this.sessionSubKey = (byte[])properties.get("KRBSubsessionKey");
            KRBSPN spnObj = (KRBSPN)properties.get("com.ibm.wsspi.wssecurity.auth.SPNObj");
            this.serviceName = spnObj.getServicePrincipalName();
            this.kerberosRealm = spnObj.getKerberosRealm();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "token:" + KRB5Util.showHex(this.token));
            Tr.debug(tc, "sessionSubKey:" + KRB5Util.showHex(this.sessionSubKey));
            Tr.debug(tc, "serviceName:" + this.serviceName);
            Tr.debug(tc, "kerberosRealm:" + this.kerberosRealm);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBTokenInfo");
        }
    }

    public byte[] getKerberosToken() {
        return this.token;
    }

    public byte[] getSessionSubKey() {
        return this.sessionSubKey;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getKerberosRealm() {
        return this.kerberosRealm;
    }

    static {
        tc = Tr.register(KRBTokenInfo.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    }
}

