/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.X509BSToken;
import com.ibm.wsspi.wssecurity.config.TokenConsumerConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyStoreKeyLocator;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Map;

public class X509TokenKeyLocator
extends KeyStoreKeyLocator {
    private static final TraceComponent tc = Tr.register(X509TokenKeyLocator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = X509TokenKeyLocator.class.getName();

    public Key getKey(Map type, Map context) throws SoapSecurityException {
        Key key;
        boolean isVerifying;
        boolean isDecrypting;
        boolean isKeyName;
        boolean isKeyId;
        boolean isStrref;
        boolean isEmb;
        boolean isX509;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getKey(Map type,Map context)");
        }
        if (!this._initialized) {
            this.doInit();
        }
        SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
        String keyInfoType = (String)type.get(Constants.WSSECURITY_KEYINFO_TYPE);
        if (keyInfoType == null) {
            isX509 = false;
            isEmb = false;
            isStrref = false;
            isKeyId = false;
            isKeyName = false;
        } else {
            isKeyName = ConfigUtil.isKeyInfoKeyname((String)keyInfoType);
            isKeyId = ConfigUtil.isKeyInfoKeyid((String)keyInfoType);
            isStrref = ConfigUtil.isKeyInfoStrref((String)keyInfoType);
            isEmb = ConfigUtil.isKeyInfoEmb((String)keyInfoType);
            isX509 = ConfigUtil.isKeyInfoX509issuer((String)keyInfoType);
        }
        String keyType = (String)type.get(Constants.WSSECURITY_KEY_TYPE);
        if (keyType == null) {
            isDecrypting = false;
            isVerifying = false;
        } else {
            isVerifying = "VerifyingKey".equals(keyType);
            isDecrypting = "DecryptingKey".equals(keyType);
        }
        if (!isVerifying && !isDecrypting) {
            throw SoapSecurityException.format("security.wssecurity.KeyStoreKeyLocator.getKey02", keyType);
        }
        TokenConsumerConfig tconfig = (TokenConsumerConfig)type.get(Constants.WSSECURITY_KEYINFO_TOKEN_REFERENCE);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoType [" + keyInfoType + "]."));
            Tr.debug((TraceComponent)tc, (String)("KeyType [" + keyType + "]."));
            Tr.debug((TraceComponent)tc, (String)("Configuration of a TokenConsumer [" + tconfig + "]."));
        }
        if ((key = (Key)context.remove(this.getClass())) == null) {
            X509Certificate cert = this.getCert(isKeyName, isKeyId, isStrref, isEmb, isX509, tconfig, type, context);
            if (cert == null) {
                throw SoapSecurityException.format("security.wssecurity.X509IssuerContentGenerator.getKey01");
            }
            context.put(cert.getPublicKey(), cert);
            if (tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"(key, certificate) put in context");
            }
            if (isDecrypting) {
                key = this.getPrivateKey(cert);
            } else if (isVerifying) {
                key = this.getPublicKey(cert);
            }
        }
        context.put(this.getClass(), key);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Map type, Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    private X509Certificate getCert(boolean isKeyName, boolean isKeyId, boolean isStrref, boolean isEmb, boolean isX509, TokenConsumerConfig tconfig, Map type, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCert(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "TokenConsumerConfig tconfig," + "Map type," + "Map context)"));
        }
        X509Certificate cert = null;
        String tokenId = null;
        if (isKeyName) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_NAME);
        } else if (isKeyId) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_ID);
        } else if (isStrref) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_REFERENCE);
        } else if (isEmb) {
            tokenId = (String)type.get(Constants.WSSECURITY_KEY_EMBID);
        } else if (isX509) {
            String issuerName = (String)type.get(Constants.WSSECURITY_KEY_ISSUERNAME);
            String issuerSerial = (String)type.get(Constants.WSSECURITY_KEY_ISSUERSERIAL);
            if (issuerName != null && issuerSerial != null) {
                tokenId = issuerName + ":" + issuerSerial;
            }
        }
        X509BSToken token = (X509BSToken)TokenManager.getToken(context, tconfig, tokenId);
        if (token != null) {
            if (token.getError() != null) {
                throw token.getError();
            }
            cert = token.getCert();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getToken(boolean isKeyName[" + isKeyName + "]," + "boolean isKeyId[" + isKeyId + "]," + "boolean isStrref[" + isStrref + "]," + "boolean isEmb[" + isEmb + "]," + "boolean isX509[" + isX509 + "]," + "Map context)" + " returns X509Certificate[" + cert + "]"));
        }
        return cert;
    }

    private Key getPrivateKey(X509Certificate cert) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPrivateKey(X509Certificate cert)");
        }
        Key key = null;
        if (cert != null && this._keylist != null) {
            String cdn = KeyInfo.X509Data.encodeDName((String)cert.getSubjectDN().getName());
            for (String kdn : this._keylist.keySet()) {
                if (!cdn.equals(kdn = KeyInfo.X509Data.encodeDName((String)kdn))) continue;
                key = ((KeyStoreKeyLocator.KeyInformation)this._keylist.get(kdn)).getPrivateOrSecretKey();
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPrivateKey(X509Certificate cert) returns Key[" + key + "]"));
        }
        return key;
    }

    private Key getPublicKey(X509Certificate cert) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getPublicKey(X509Certificate cert[" + cert + "])"));
        }
        PublicKey key = null;
        if (cert != null) {
            key = cert.getPublicKey();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getPublicKey(X509Certificate cert) returns Key[" + key + "]"));
        }
        return key;
    }
}

