/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.token;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.auth.token.LTPAToken;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class LTPATokenWrapper
extends LTPAToken {
    private static final TraceComponent tc = Tr.register(LTPATokenWrapper.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String compName = "security.wssecurity";
    private static final String getCredentialPermission = "wssecurity.LTPATokenWrapper.getWSCredential";
    private WSCredential _wsCred = null;
    private WSPrincipal _wsPrinc = null;
    private QName DEFAULT_VALUE_TYPE;
    private static final WebSphereRuntimePermission GETWSCREDENTIAL_PERM = new WebSphereRuntimePermission("wssecurity.LTPATokenWrapper.getWSCredential");

    public LTPATokenWrapper(String tokenId, byte[] cred, String username, char[] password, Element elem) {
        super(tokenId, cred, username, password, elem);
        this._vtype = this.DEFAULT_VALUE_TYPE = Constants.LTPA_TOKEN_PROPAGATION;
    }

    public LTPATokenWrapper(String tokenId, byte[] cred) {
        this(tokenId, cred, null, null, null);
    }

    public LTPATokenWrapper(String tokenId, byte[] cred, WSCredential wsCred, WSPrincipal princ) {
        super(tokenId, cred);
        this.DEFAULT_VALUE_TYPE = Constants.LTPA_TOKEN_PROPAGATION;
        this._wsCred = wsCred;
        this._wsPrinc = princ;
        this._vtype = this.DEFAULT_VALUE_TYPE;
    }

    public WSCredential getWSCredential() {
        Tr.entry(tc, "getWSCredential");
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                Tr.debug(tc, "Expecting : " + GETWSCREDENTIAL_PERM.toString());
            }
            sm.checkPermission(GETWSCREDENTIAL_PERM);
        }
        Tr.exit(tc, "getWSCredential");
        return this._wsCred;
    }

    public WSPrincipal getWSPrincipal() {
        return this._wsPrinc;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LTPATokenWrapper[tokenId=[").append(this._tokenId);
        buf.append("], element=[").append(DOMUtil.getDisplayName((Node)this._tokenelem));
        buf.append("], username=[").append(this.getPrincipal());
        buf.append("], WSPrincipal=[").append(this._wsPrinc);
        buf.append("], WSCredential=[").append(this._wsCred);
        buf.append("]");
        return buf.toString();
    }
}

