/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.xml.soapsec.token.UserRegistry;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class WSSecurityMappingModule
implements LoginModule,
Constants {
    private Subject s;
    private CallbackHandler cbh;
    private Map states;
    private Map options;
    private boolean successful = false;
    private boolean committed = false;
    private boolean debug = false;
    protected WSCredential wscred;
    protected WSPrincipal wsprin;
    private static final WebSphereRuntimePermission PERM = new WebSphereRuntimePermission("wssecurity.WSSecurityMappingModule.login");
    private static final TraceComponent tc = Tr.register(WSSecurityMappingModule.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");

    public WSSecurityMappingModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSecurityMappingModule");
            Tr.exit(tc, "WSSecurityMappingModule");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry(tc, "initialize(Subject, CallbackHandler, sharedState, options)", new Object[]{subject, callbackHandler, sharedState, options});
        }
        this.s = subject;
        this.cbh = callbackHandler;
        this.states = sharedState;
        this.options = options;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit(tc, "initialize");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry(tc, "login");
        }
        this.clear();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(PERM);
        }
        String DN = (String)this.states.get("com.ibm.wsspi.wssecurity.Constants.DN");
        return this._login(DN);
    }

    boolean _login(String DN) throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry(tc, "_login");
        }
        if (DN == null || DN.length() == 0) {
            Tr.error(tc, "security.wssecurity.novalidated.dn");
            if (tc.isEntryEnabled() || this.debug) {
                Tr.exit(tc, "_login");
            }
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.novalidated.dn"));
        }
        boolean checkUsername = false;
        UserRegistry ur = UserRegistry.getInstance();
        checkUsername = ur.checkUsername(DN);
        if (!checkUsername) {
            throw new LoginException("DN=" + DN + "checkUsername()=" + checkUsername);
        }
        this.successful = true;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit(tc, "_login: " + this.successful);
        }
        return this.successful;
    }

    public boolean commit() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry(tc, "commit");
        }
        if (!this.successful) {
            Tr.error(tc, ConfigConstants.getMessage("security.wssecurity.notyet.login"));
            throw new WSLoginFailedException(ConfigConstants.getMessage("security.wssecurity.notyet.login"));
        }
        if (this.committed) {
            Tr.warning(tc, ConfigConstants.getMessage("security.wssecurity.already.committed"));
        }
        this.committed = true;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit(tc, "commit: " + this.committed);
        }
        return this.committed;
    }

    public boolean abort() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry(tc, "abort");
        }
        this.clear();
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit(tc, "abort: true");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry(tc, "logout");
        }
        this.clear();
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit(tc, "logout: true");
        }
        return true;
    }

    private void clear() {
        if (tc.isEntryEnabled() || this.debug) {
            Tr.entry(tc, "clear");
        }
        this.successful = false;
        this.committed = false;
        if (tc.isEntryEnabled() || this.debug) {
            Tr.exit(tc, "clear");
        }
    }
}

