/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ws.wssecurity.xss4j.dsig.KeyInfo;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.auth.module.BSTokenLoginModule;
import com.ibm.xml.soapsec.util.CertificateUtil;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import javax.security.auth.login.LoginException;

public class PkiPathLoginModule
extends BSTokenLoginModule {
    private static final TraceComponent tc = Tr.register(PkiPathLoginModule.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = PkiPathLoginModule.class.getName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        boolean ret;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"login()");
        }
        if (ret = super.login()) {
            Object dn2;
            CertPath path = null;
            Provider provider = (Provider)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.provider");
            try {
                path = CertificateUtil.generateCertPath((byte[])this._binary, (String)"X.509", (String)"PkiPath", (Provider)provider);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Succeeded to generate cert path.");
                }
                this._cert = (X509Certificate)path.getCertificates().get(0);
                if (this._cert == null) {
                    throw new CertificateException(ConfigUtil.getMessage((String)"security.wssecurity.KeyStoreKeyLocator.setCertToSubject01"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Succeeded to get a X509 certificate [" + this._cert + "]"));
                }
            }
            catch (CertificateException e) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s01", (String[])new String[]{e.toString()}));
            }
            catch (NoSuchProviderException e) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s01", (String[])new String[]{e.toString()}));
            }
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Checking the validity of X509 certificate...");
                }
                this._cert.checkValidity();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Succeeded to check the validity of X509 certificate.");
                }
            }
            catch (Exception e) {
                throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s02", (String[])new String[]{e.toString()}));
            }
            boolean trustCert = false;
            String value1 = (String)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.trustAny");
            if (value1 != null && value1.length() > 0) {
                trustCert = ConfigUtil.isTrue((String)value1);
                if (tc.isDebugEnabled() && trustCert) {
                    Tr.debug((TraceComponent)tc, (String)"This login module trusts any certificate.");
                }
            }
            if (!trustCert) {
                value1 = (String)this._properties.get(Constants.WSSECURITY_ISSUER_NAME);
                String value2 = (String)this._properties.get(Constants.WSSECURITY_ISSUER_SERIAL);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Issuer name of its own certificate is [" + value1 + "]."));
                    Tr.debug((TraceComponent)tc, (String)("Serial number of its own certificate is [" + value2 + "]."));
                }
                if (value1 != null && value2 != null) {
                    String dn1 = this._cert.getIssuerDN().getName();
                    if ((dn1 = KeyInfo.X509Data.encodeDName((String)dn1)).equals(dn2 = KeyInfo.X509Data.encodeDName((String)value1))) {
                        BigInteger serial1 = this._cert.getSerialNumber();
                        BigInteger serial2 = null;
                        try {
                            serial2 = CertificateUtil.convertSerialNumber((String)value2);
                        }
                        catch (ParseException e) {
                            throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s04", (String[])new String[]{value2, e.toString()}));
                        }
                        if (serial1.equals(serial2)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"The cert is its own certificate, so this login module trusts it.");
                            }
                            trustCert = true;
                        }
                    }
                } else if (value1 != null) {
                    Tr.debug((TraceComponent)tc, (String)"There is issuer name, but not serial number.");
                } else if (value2 != null) {
                    Tr.debug((TraceComponent)tc, (String)"There is serial number, but not issur name.");
                }
            }
            if (!trustCert) {
                PKIXBuilderParameters pkixParams;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This login module doesn't trust all certificate, so starts checking the cert path.");
                }
                if ((pkixParams = (PKIXBuilderParameters)this._properties.get("com.ibm.wsspi.wssecurity.token.x509.pkixBuilderParam")) == null) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.X509LoginModule.s05"));
                }
                dn2 = pkixParams;
                synchronized (dn2) {
                    pkixParams = (PKIXBuilderParameters)pkixParams.clone();
                }
                pkixParams.setRevocationEnabled(false);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Provider [" + provider + "], PKIBuilderParameters [" + pkixParams + "]."));
                }
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Checking the cert path...");
                    }
                    CertificateUtil.validateCertPath((CertPath)path, (PKIXParameters)pkixParams);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Succeeded to validate the cert path.");
                    }
                }
                catch (CertPathValidatorException e) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s02", (String[])new String[]{e.toString()}));
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s02", (String[])new String[]{e.toString()}));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new LoginException(ConfigUtil.getMessage((String)"security.wssecurity.PkiPathLoginModule.s02", (String[])new String[]{e.toString()}));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"login()");
        }
        return true;
    }
}

