/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.module;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.wssecurity.auth.module.KRBIdentityMappingLoginModule;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public class KRBDefaultMappingLoginModule
extends KRBIdentityMappingLoginModule {
    private Map sharedState = null;
    private boolean mappingSucceeded = false;
    private static String userIDSuffix = null;
    private static String userIDPrefix = null;
    private static TraceComponent tc = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize()");
        }
        super.initialize(subject, callbackHandler, sharedState, options);
        this.mappingSucceeded = false;
        this.sharedState = sharedState;
        if (userIDPrefix == null) {
            userIDPrefix = (String)options.get("com.ibm.wsspi.wssecurity.auth.userIDPrefix");
            userIDSuffix = (String)options.get("com.ibm.wsspi.wssecurity.auth.userIDSuffix");
            if (userIDPrefix == null) {
                userIDPrefix = "";
            }
            if (userIDSuffix == null) {
                userIDSuffix = "";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "userIDPrefix: " + userIDPrefix);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "userIDSuffix: " + userIDSuffix);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize()");
        }
    }

    public boolean login() throws LoginException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        this.mappingSucceeded = true;
        String was_principal = (String)this.sharedState.get("com.ibm.wsspi.wssecurity.Constants.DN");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current was_principal " + was_principal);
        }
        String mapped_was_principal = userIDPrefix + was_principal + userIDSuffix;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "mapped was_principal " + mapped_was_principal);
        }
        this.sharedState.put("com.ibm.wsspi.wssecurity.Constants.Mapped_DN", mapped_was_principal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.mappingSucceeded;
    }

    static {
        tc = Tr.register(KRBDefaultMappingLoginModule.class, null, null);
    }
}

