/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.wssecurity.auth.callback;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.webservices.engine.MessageContext;
import com.ibm.ws.webservices.wssecurity.config.KRBSPN;
import com.ibm.ws.webservices.wssecurity.util.KRB5Util;
import com.ibm.wsspi.wssecurity.auth.callback.KRBTokenCallback;
import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class KRBTokenCallbackHandler
implements CallbackHandler {
    private static TraceComponent tc = Tr.register(KRBTokenCallbackHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private HashMap properties = null;

    public KRBTokenCallbackHandler(HashMap properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "KRBTokenCallbackHandler");
        }
        this.properties = properties;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Properties = " + properties.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "KRBTokenCallbackHandler");
        }
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handle");
        }
        for (int i = 0; i < callbacks.length; ++i) {
            byte[] kerberosTokenBytes;
            if (callbacks[i] instanceof KRBTokenCallback) {
                kerberosTokenBytes = null;
                if (this.properties != null) {
                    kerberosTokenBytes = (byte[])this.properties.get("KRBToken");
                }
                if (kerberosTokenBytes == null || kerberosTokenBytes.length == 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Kerberos token doesn't exist");
                    }
                    throw new IOException(KRB5Util.getNLS().getString("security.wssecurity.kerberos.token.unavailable"));
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Kerberos token exists");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Received unsupported callback");
                }
                throw new UnsupportedCallbackException(callbacks[i], callbacks[i].getClass() + " is not recognised callback ");
            }
            KRBTokenCallback callback = (KRBTokenCallback)callbacks[i];
            callback.setKerberosToken(kerberosTokenBytes);
            callback.setSPN((KRBSPN)this.properties.get("com.ibm.wsspi.wssecurity.auth.SPNObj"));
            callback.setKerberosTokenValueType((String)this.properties.get("ValueType"));
            callback.setKerberosTokenID((String)this.properties.get("tokenID"));
            callback.setMessageContext((MessageContext)this.properties.get("com.ibm.wsspi.wssecurity.core.messageContext"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handle");
        }
    }
}

