/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.security.registry;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.TrustedAuthenticationRealm;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegistryHelper {
    private static final TraceComponent tc = Tr.register(RegistryHelper.class, null, "com.ibm.ejs.resources.security");
    private static SecurityConfigManager scm = SecurityObjectLocator.getSecurityConfigManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UserRegistry getUserRegistry(String realmName) throws WSSecurityException {
        UserRegistry ur;
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getUserRegistry", realmName);
            }
            ur = null;
            if (realmName == null || realmName.length() == 0) {
                ur = ContextManagerFactory.getInstance().getRegistry(null);
            } else {
                String domain = null;
                if (scm != null) {
                    domain = scm.getDomainForRealm(realmName);
                }
                if (domain != null && domain.length() > 0) {
                    boolean pop = false;
                    String type = "domain";
                    if (domain.equals("admin")) {
                        type = "admin";
                    }
                    try {
                        try {
                            pop = SecurityObjectLocator.pushContext(domain, type);
                            UserRegistryConfig regCfg = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry();
                            ur = (UserRegistry)regCfg.getUserRegistryStub();
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getUserRegistry unexpected exception getting registry stub for domain: " + domain, e);
                            }
                            Object var7_8 = null;
                            if (pop) {
                                SecurityObjectLocator.popContext();
                            }
                            break block16;
                        }
                        Object var7_7 = null;
                        if (!pop) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (pop) {
                            SecurityObjectLocator.popContext();
                        }
                        throw throwable;
                    }
                    SecurityObjectLocator.popContext();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no domain is configured with the active user registry that matches the realm name " + realmName);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRegistry", ur);
        }
        return ur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> getInboundTrustedRealms(String realmName) throws WSSecurityException {
        TrustedAuthenticationRealm trustedRealms;
        ArrayList<String> trustedRealmList;
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInboundTrustedRealms", realmName);
            }
            trustedRealmList = new ArrayList<String>();
            boolean retVal = false;
            trustedRealms = null;
            if (realmName == null) {
                trustedRealms = SecurityObjectLocator.getSecurityConfig().getInboundTrustedAuthenticationRealm();
            } else {
                String domain = null;
                if (scm != null) {
                    domain = scm.getDomainForRealm(realmName);
                }
                if (domain != null && domain.length() > 0) {
                    boolean pop = false;
                    String type = "domain";
                    if (domain.equals("admin")) {
                        type = "admin";
                    }
                    try {
                        Object var9_10;
                        try {
                            pop = SecurityObjectLocator.pushContext(domain, type);
                            trustedRealms = SecurityObjectLocator.getSecurityConfig().getInboundTrustedAuthenticationRealm();
                        }
                        catch (Exception e) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getInboundTrustedAuthenticationRealm caught unexpected exception for domain: " + domain, e);
                            }
                            var9_10 = null;
                            if (pop) {
                                SecurityObjectLocator.popContext();
                            }
                            break block29;
                        }
                        var9_10 = null;
                        if (!pop) break block29;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        if (pop) {
                            SecurityObjectLocator.popContext();
                        }
                        throw throwable;
                    }
                    SecurityObjectLocator.popContext();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no domain is configured with the active user registry that matches the realm name " + realmName);
                }
            }
        }
        if (trustedRealms != null) {
            boolean trustAll = trustedRealms.getTrustAllRealms();
            if (trustAll) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "all realms are trusted");
                }
                trustedRealmList.add("*");
            } else {
                String realmsList = trustedRealms.getRealmList();
                if (realmsList != null && realmsList.length() > 0) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "realmsList = " + realmsList);
                    }
                    try {
                        StringTokenizer st = new StringTokenizer(realmsList, "|");
                        while (st.hasMoreTokens()) {
                            String nextRealm = st.nextToken();
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "adding realm : " + nextRealm + " to the list");
                            }
                            trustedRealmList.add(nextRealm);
                        }
                    }
                    catch (Exception ex) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getInboundTrustedRealms");
                        }
                        throw new WSSecurityException(ex.getMessage(), ex);
                    }
                }
                String adminRealm = SecurityObjectLocator.getSecurityConfig("security").getActiveUserRegistry().getString("realm");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "adding adminRealm =  " + adminRealm);
                }
                if (adminRealm != null) {
                    trustedRealmList.add(adminRealm);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInboundTrustedRealms", trustedRealmList);
        }
        return trustedRealmList;
    }

    public static boolean isRealmInboundTrusted(String inboundRealm, String localRealm) {
        if (inboundRealm == null) {
            return false;
        }
        try {
            List<String> trustedRealms = RegistryHelper.getInboundTrustedRealms(localRealm);
            if (trustedRealms.contains("*")) {
                return true;
            }
            Iterator<String> it = trustedRealms.iterator();
            while (it.hasNext()) {
                if (!inboundRealm.equalsIgnoreCase(it.next())) continue;
                return true;
            }
            return false;
        }
        catch (WSSecurityException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSecurityException caught: " + e.getMessage());
            }
            return false;
        }
    }
}

