/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.MDQOperationDescriptorImpl;
import com.ibm.ws.websvcs.desc.ServiceBeanInfoImpl;
import com.ibm.ws.websvcs.utils.Axis2Utils;
import com.ibm.wsspi.websvcs.desc.ServiceBeanInfo;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSOperationDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointInterfaceDescription;
import org.apache.axis2.jaxws.description.OperationDescription;

public class MDQEndpointDescriptorImpl
implements WSEndpointDescriptor {
    private WSServiceDescriptor parent;
    private EndpointDescription endpointDescription;
    private List<WSOperationDescriptor> operationDescriptors;
    private boolean operationsBuilt;
    private String portComponentName;
    private ServiceBeanInfo beanInfo;
    private QName bindingQName;
    private QName portTypeQName;
    private static final TraceComponent _tc = Tr.register(MDQEndpointDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");

    public MDQEndpointDescriptorImpl(WSServiceDescriptor parent, EndpointDescription endpointDescription) {
        this.parent = parent;
        this.endpointDescription = endpointDescription;
        this.operationDescriptors = new ArrayList<WSOperationDescriptor>();
        this.operationsBuilt = false;
        this.portComponentName = endpointDescription.getName();
        this.setBindingQName(parent.getWSDLDefinition());
        this.buildServiceBeanInfo(endpointDescription.getAxisService());
    }

    void setBindingQName(Definition definition) {
        Port port;
        Service service;
        if (definition != null && (service = definition.getService(this.parent.getQName())) != null && this.endpointDescription.getPortQName() != null && (port = service.getPort(this.endpointDescription.getPortQName().getLocalPart())) != null && port.getBinding() != null) {
            this.bindingQName = port.getBinding().getQName();
            this.setPortTypeQName(port.getBinding());
        }
    }

    void setPortTypeQName(Binding binding) {
        if (binding != null && binding.getPortType() != null) {
            this.portTypeQName = binding.getPortType().getQName();
        }
    }

    public String getName() {
        return this.endpointDescription.getPortQName() != null ? this.endpointDescription.getPortQName().getLocalPart() : null;
    }

    public QName getBindingQName() {
        return this.bindingQName;
    }

    public QName getPortTypeQName() {
        return this.portTypeQName;
    }

    public Iterator getOperations() {
        this.buildOperations();
        return this.operationDescriptors.iterator();
    }

    public WSServiceDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.endpointDescription.getPortQName();
    }

    public String getURLPattern() {
        AxisService as = this.endpointDescription.getAxisService();
        if (as != null) {
            return Axis2Utils.getURLPattern((AxisService)as);
        }
        return null;
    }

    public String getPortComponentName() {
        return this.portComponentName;
    }

    public ServiceBeanInfo getServiceBeanInfo() {
        return this.beanInfo;
    }

    private void buildServiceBeanInfo(AxisService axisService) {
        String linkValue = null;
        String implClassName = Axis2Utils.getServiceImplClass((AxisService)axisService);
        linkValue = Axis2Utils.getLinkValue((AxisService)axisService);
        ServiceBeanInfo.BeanType beanType = Axis2Utils.getParameterValue((AxisDescription)axisService, (String)"EJB_J2EE_NAME") != null ? ServiceBeanInfo.BeanType.EJB : ServiceBeanInfo.BeanType.WEB;
        this.beanInfo = new ServiceBeanInfoImpl(implClassName, linkValue, beanType);
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Built ServiceBeanInfo: " + this.beanInfo.toString());
        }
    }

    private void buildOperations() {
        if (!this.operationsBuilt) {
            OperationDescription[] opDescs;
            EndpointInterfaceDescription eid = this.endpointDescription.getEndpointInterfaceDescription();
            if (eid != null && (opDescs = eid.getOperations()) != null && opDescs.length > 0) {
                for (OperationDescription opDesc : opDescs) {
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Building WSOperationDescriptor for method: " + opDesc.getOperationName());
                    }
                    MDQOperationDescriptorImpl operationDescriptor = new MDQOperationDescriptorImpl(opDesc.getOperationName());
                    this.operationDescriptors.add(operationDescriptor);
                }
            }
            this.operationsBuilt = true;
        }
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

