/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.websvcs.desc;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.websvcs.desc.DBUtils;
import com.ibm.ws.websvcs.desc.JAXRPCEndpointDescriptorImpl;
import com.ibm.ws.websvcs.desc.WSModuleDescriptorImpl;
import com.ibm.wsspi.websvcs.desc.WSEndpointDescriptor;
import com.ibm.wsspi.websvcs.desc.WSModuleDescriptor;
import com.ibm.wsspi.websvcs.desc.WSServiceDescriptor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.eclipse.jst.j2ee.webservice.wsdd.PortComponent;

public class JAXRPCServiceDescriptorImpl
implements WSServiceDescriptor {
    private static final TraceComponent _tc = Tr.register(WSModuleDescriptorImpl.class, "WebServices", "com.ibm.ws.websvcs.resources.websvcsMessages");
    private Service wsdlService;
    private WSModuleDescriptor parent;
    private Definition def;
    private List<WSEndpointDescriptor> endpointDescList;
    private PortComponent portComponent;
    private String urlPattern;

    public JAXRPCServiceDescriptorImpl(Service wsdlService, Definition def, PortComponent portComponent, WSModuleDescriptor parent) {
        this.wsdlService = wsdlService;
        this.def = def;
        this.portComponent = portComponent;
        this.parent = parent;
        this.endpointDescList = new ArrayList<WSEndpointDescriptor>();
        this.buildEndpoint();
    }

    public boolean deployedWithWSDL() {
        return true;
    }

    public Iterator getEndpoints() {
        return this.endpointDescList.iterator();
    }

    private void buildEndpoint() {
        Port wsdlPort = this.wsdlService.getPort(this.portComponent.getWsdlPort().getLocalPart());
        if (wsdlPort != null) {
            JAXRPCEndpointDescriptorImpl endpointDesc = new JAXRPCEndpointDescriptorImpl(wsdlPort, this.portComponent, this);
            this.endpointDescList.add(endpointDesc);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Added JAXRPCEndpointDescriptorImpl: " + wsdlPort.getName());
            }
        } else if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Did not build JAXRPCEndpointDescriptorImpl because wsdl:port could not be found for port component: " + this.portComponent.getPortComponentName());
        }
    }

    public String getName() {
        return this.wsdlService.getQName().getLocalPart();
    }

    public WSModuleDescriptor getParent() {
        return this.parent;
    }

    public QName getQName() {
        return this.wsdlService.getQName();
    }

    public Definition getWSDLDefinition() {
        return this.def;
    }

    public String getWSDLLocationBaseName() {
        String wsdlBaseName = this.def.getDocumentBaseURI();
        if (wsdlBaseName.lastIndexOf("/") != -1 && wsdlBaseName.lastIndexOf("/") != wsdlBaseName.length()) {
            wsdlBaseName = wsdlBaseName.substring(wsdlBaseName.lastIndexOf("/") + 1, wsdlBaseName.length());
        }
        return wsdlBaseName;
    }

    public URI getWSDLLocationURI() {
        try {
            return new URI(this.def.getDocumentBaseURI());
        }
        catch (Throwable t) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Could not obtain WSDL location URI for: " + this.wsdlService.getQName());
            }
            return null;
        }
    }

    protected void addEndpoint(JAXRPCEndpointDescriptorImpl endpoint) {
        this.endpointDescList.add(endpoint);
    }

    public boolean isJAXRPCService() {
        return true;
    }

    public boolean isJAXWSService() {
        return false;
    }

    public String toString() {
        return DBUtils.printDBObject(this);
    }
}

