/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.util;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.dsig.PartList;
import com.ibm.ws.webservices.wssecurity.util.IntegralDialectElementSelector;
import com.ibm.ws.wssecurity.xss4j.domutil.XPathCanonicalizer;
import com.ibm.ws.wssecurity.xss4j.dsig.IDResolver;
import com.ibm.ws.wssecurity.xss4j.dsig.SignatureContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformContext;
import com.ibm.ws.wssecurity.xss4j.dsig.TransformException;
import com.ibm.ws.wssecurity.xss4j.dsig.transform.XPathTransformer;
import com.ibm.ws.wssecurity.xss4j.dsig.util.XPathUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.token.NonceManager;
import com.ibm.xml.soapsec.util.Duration;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XPathElementSelector
implements ElementSelector {
    private static final TraceComponent tc = Tr.register(XPathElementSelector.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = XPathElementSelector.class.getName();

    public void init(Map properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map properties)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map properties)");
        }
    }

    public NodeList getElements(Node node, Map context) throws SoapSecurityException {
        Object list;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getElements(Node node[" + node + "]," + "Map context)"));
        }
        if (node == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s02");
        }
        String dialect = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.dialect");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Dialect [" + dialect + "]"));
        }
        if (dialect == null) {
            throw SoapSecurityException.format("Null is not allowed as the WAS dialect");
        }
        if (!Constants.DIALECT_XPATH.equals(dialect) && !Constants.DIALECT_FUNCTION.equals(dialect)) {
            throw SoapSecurityException.format(clsName + " does not allow the dialect: " + dialect + ".");
        }
        String keyword = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.keyword");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Keyword [" + keyword + "]"));
        }
        if (keyword == null) {
            throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s03");
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.util.selector.operation");
        boolean encryption = "encryption_mode".equals((String)obj);
        boolean decryption = "decryption_mode".equals((String)obj);
        boolean signature = "signature_mode".equals((String)obj);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Mode [" + obj + "]"));
        }
        String processType = (String)context.get("com.ibm.ws.webservices.wssecurity.util.selector.processType");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Process type [" + processType + "]"));
        }
        Object[] elements = (Object[])context.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Elements [" + elements + "]"));
        }
        Set configs = (Set)context.get("com.ibm.ws.webservices.wssecurity.util.selector.config");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Token generator configs [" + configs + "]"));
        }
        IDResolver idResolver = (IDResolver)context.get("com.ibm.ws.webservices.wssecurity.util.selector.IDResolver");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ID resolver [" + idResolver + "]"));
        }
        Duration duration = (Duration)context.get("security.wssecurity.integraldialectelementselector.duration");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Duration [" + duration + "]"));
        }
        NonceManager nonceManager = (NonceManager)context.get(NonceManager.class);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Nonce manager [" + nonceManager + "]"));
        }
        boolean isContent = false;
        if (encryption || decryption) {
            boolean bl = isContent = keyword != null && keyword.endsWith("node()");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Encryption type is #Content [" + isContent + "]"));
            }
            if (isContent) {
                int pos = keyword.lastIndexOf(47);
                keyword = keyword.substring(0, pos);
            }
        }
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int version = 0;
        if (obj != null && obj instanceof Integer) {
            version = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][version];
        String nsWsu = Constants.NAMESPACES[1][version];
        Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
        if (keyword.length() == 0) {
            XPathCanonicalizer.NodeListImpl listImpl;
            list = listImpl = new XPathCanonicalizer.NodeListImpl(1);
            listImpl.add((Node)doc.getDocumentElement());
        } else {
            try {
                XPathCanonicalizer.NodeListImpl listImpl;
                NodeList nl = XPathAPI.selectNodeList((Node)node, (String)keyword);
                int l = nl.getLength();
                list = listImpl = new XPathCanonicalizer.NodeListImpl(l);
                for (int i = 0; i < l; ++i) {
                    Node n = nl.item(i);
                    if (n.getNodeType() != 1) continue;
                    listImpl.add(n);
                }
            }
            catch (TransformerException ex1) {
                if (!(encryption || decryption || signature || "timestamp".equals(processType) || "nonce".equals(processType))) {
                    try {
                        Element xpathExpression = doc.createElementNS(Constants.NS_DSIG, "ds:XPath");
                        Text expression = doc.createTextNode(keyword);
                        xpathExpression.appendChild(expression);
                        XPathTransformer transformer = new XPathTransformer();
                        transformer.setParameter((Node)xpathExpression);
                        SignatureContext scontext = new SignatureContext();
                        scontext.setIDResolver(idResolver);
                        Vector decls = XPathUtil.fixTree((Node)node);
                        TransformContext tcontext = new TransformContext(scontext, node);
                        transformer.transform(tcontext);
                        if (decls != null) {
                            XPathUtil.cleanTree((Vector)decls);
                        }
                        list = new PartList(tcontext.getNodeset());
                    }
                    catch (TransformException ex2) {
                        Tr.processException((Throwable)ex2, (String)(clsName + ".getElements"), (String)"226");
                        throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", keyword, (Throwable)ex2);
                    }
                }
                Tr.processException((Throwable)ex1, (String)(clsName + ".getElements"), (String)"232");
                throw SoapSecurityException.format("security.wssecurity.XPathElementSelector.s01", keyword, (Throwable)ex1);
            }
        }
        if (processType != null) {
            if (encryption || signature) {
                list = IntegralDialectElementSelector.postprocess(doc, processType, (NodeList)list, elements, duration, nsWsse, nsWsu, nonceManager, signature, encryption, dialect, keyword);
            }
            if (encryption && list != null && list.getLength() > 0) {
                throw SoapSecurityException.format("security.wssecurity.ConfidentialDialectElementSelector.s01", keyword);
            }
        }
        if (encryption || decryption) {
            list = isContent ? new com.ibm.ws.webservices.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Content", (NodeList)list) : new com.ibm.ws.webservices.wssecurity.enc.PartList("http://www.w3.org/2001/04/xmlenc#Element", (NodeList)list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getElements(Node node,Map context) returns NodeList[" + list + "]"));
        }
        return list;
    }
}

