/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.time;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.WSSGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.config.TimestampGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.ElementSelector;
import com.ibm.ws.webservices.wssecurity.core.RequestMessagePool;
import com.ibm.ws.webservices.wssecurity.time.TimestampRequest;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.ws.webservices.wssecurity.util.NonceUtil;
import com.ibm.ws.webservices.wssecurity.util.TimestampDialectElementSelector;
import com.ibm.ws.webservices.wssecurity.util.WSPFunctionElementSelector;
import com.ibm.ws.webservices.wssecurity.util.XPathElementSelector;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.Request;
import com.ibm.xml.soapsec.RequestPool;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimestampGenerator
implements WSSGeneratorComponent {
    private static final TraceComponent tc = Tr.register(TimestampGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public void invoke(Document doc, Element parent, Map context) throws SoapSecurityException {
        boolean isSigned;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("invoke(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map context)"));
        }
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.soapVersion");
        int soapVersion = 0;
        if (obj != null && obj instanceof Integer) {
            soapVersion = (Integer)obj;
        }
        String nsSoap = Constants.NAMESPACES[2][soapVersion];
        obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        int wssVersion = 0;
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsu = Constants.NAMESPACES[1][wssVersion];
        if (parent == null) {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s11", "Null", "the parent element");
        }
        Element timestamp = NonceUtil.getTimestamp(parent, nsWsu);
        if (timestamp != null) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s01");
        }
        timestamp = NonceUtil.createTimestamp(doc, parent, nsWsu, null);
        TimestampGeneratorConfig config = (TimestampGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.timestampGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("TimestampGeneratorConfig [" + config + "]."));
        }
        if (config.getSOAPHeaderAttribute()) {
            TimestampGenerator.setAttributeForSOAPHeader(timestamp, soapVersion, nsSoap, config.getTargetActor(), context);
        }
        timestamp = (Element)parent.insertBefore(timestamp, parent.getFirstChild());
        Element created = NonceUtil.addCreated(doc, timestamp, nsWsu);
        Element expires = null;
        if (config.getDuration() != null) {
            expires = NonceUtil.addExpires(doc, timestamp, config.getDuration(), nsWsu);
        }
        boolean signChildren = (isSigned = config.toBeSigned()) && wssVersion != 0;
        TimestampRequest trequest = new TimestampRequest(isSigned);
        trequest.setElement(timestamp);
        RequestPool.add((Map)context, (Request)trequest);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"invoke(Document doc,Element parent,Map context)");
        }
    }

    private static void setAttributeForSOAPHeader(Element timestamp, int soapVersion, String nsSoap, String actor, Map context) {
        boolean mustUnderstand;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setAttributeForSOAPHeader(Element timestamp[" + DOMUtil.getDisplayName((Node)timestamp) + "]," + "int soapVersion[" + soapVersion + "]," + "String nsSoap[" + nsSoap + "]," + "String actor[" + actor + "])"));
        }
        String prefix = DOMUtil.getNamespacePrefix((Element)timestamp, (String)nsSoap);
        if (actor != null) {
            String attName;
            String string = attName = soapVersion == 0 ? "actor" : "role";
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                timestamp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:env", nsSoap);
            }
            timestamp.setAttributeNS(nsSoap, prefix + ":" + attName, actor);
        }
        if (mustUnderstand = ConfigUtil.getMustUnderstand((Map)context)) {
            if (prefix == null || prefix.length() <= 0) {
                prefix = "env";
                timestamp.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:env", nsSoap);
            }
            timestamp.setAttributeNS(nsSoap, prefix + ":mustUnderstand", "1");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setAttributeForSOAPHeader(Element timestamp,int soapVersion,String nsSoap,String actor)");
        }
    }

    public static void moveTimestamp(Document doc, TimestampGeneratorConfig config, Map selectors, Map context) throws SoapSecurityException {
        NodeList list;
        Request[] requests;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("moveTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "TimestampGeneratorConfig config," + "Map selectors," + "Map context)"));
        }
        if ((requests = RequestPool.get((Map)context, TimestampRequest.class)) == null || requests.length == 0) {
            throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s13");
        }
        if (requests.length > 1) {
            throw SoapSecurityException.format("security.wssecurity.TimestampGenerator.s02");
        }
        TimestampRequest trequest = (TimestampRequest)requests[0];
        Element timestamp = trequest.getElement();
        RequestMessagePool.EncryptedObject eobj = RequestMessagePool.convertElement(context, timestamp, -1);
        if (eobj != null) {
            timestamp = eobj.getEncryptedData();
        }
        Map properties = config.getProperties();
        String dialect = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_DIALECT);
        String keyword = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_TIMESTAMP_KEYWORD);
        if (dialect == null) {
            dialect = Constants.DIALECT_WAS;
            keyword = config.isSOAPHeaderElement() ? TimestampDialectElementSelector.WASDIALECTS[3] : TimestampDialectElementSelector.WASDIALECTS[1];
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Moving the Timestamp element to Dialect[" + dialect + "], " + "Keyword[" + keyword + "]..."));
        }
        if ((list = TimestampGenerator.getTimestamp(doc, dialect, keyword, "move", trequest, eobj, timestamp, selectors, context)) != null && list.getLength() > 0) {
            if (list.getLength() > 1) {
                throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s14");
            }
            timestamp.getParentNode().removeChild(timestamp);
            Element parent = (Element)list.item(0);
            timestamp = (Element)parent.appendChild(timestamp);
            if (eobj != null) {
                eobj.setEncryptedData(timestamp);
            } else {
                trequest.setElement(timestamp);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Succeed to move the Timestamp element to Dialect[" + dialect + "], " + "Keyword[" + keyword + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"moveTimestamp(Document doc,TimestampGeneratorConfig config,Map selectors,Map context)");
        }
    }

    public static NodeList getTimestamp(Document doc, String dialect, String keyword, String mode, TimestampRequest trequest, RequestMessagePool.EncryptedObject eobject, Element element, Map selectors, Map context) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getTimestamp(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "String dialect[" + dialect + "]," + "String keyword[" + keyword + "]," + "String mode[" + mode + "]," + "TimestampRequest trequest[" + trequest + "]," + "EncryptedObject eobject[" + eobject + "]," + "Element element[" + DOMUtil.getDisplayName((Node)element) + "]," + "Map selectors," + "Map context)"));
        }
        HashMap<String, Object> selectorMap = new HashMap<String, Object>(context);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.dialect", dialect);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.keyword", keyword);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.operation", mode);
        selectorMap.put("com.ibm.ws.webservices.wssecurity.util.selector.element", new Object[]{element});
        ElementSelector esel = null;
        if (Constants.DIALECT_WAS.equals(dialect)) {
            esel = (ElementSelector)selectors.get(TimestampDialectElementSelector.class);
        } else if (Constants.DIALECT_FUNCTION.equals(dialect)) {
            esel = (ElementSelector)selectors.get(WSPFunctionElementSelector.class);
        } else if (Constants.DIALECT_XPATH.equals(dialect)) {
            esel = (ElementSelector)selectors.get(XPathElementSelector.class);
        } else {
            throw SoapSecurityException.format("security.wssecurity.SignatureGenerator.s02", dialect);
        }
        NodeList list = esel.getElements(doc, selectorMap);
        if (eobject != null) {
            Object[] objs = (Object[])selectorMap.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
            eobject.setEncryptedData((Element)objs[0]);
        } else if (trequest != null) {
            Object[] objs = (Object[])selectorMap.get("com.ibm.ws.webservices.wssecurity.util.selector.element");
            trequest.setElement((Element)objs[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getTimestamp(Document doc,String dialect,String keyword,String mode,TimestampRequest trequest,EncryptedObject eobject,Element element,Map context)");
        }
        return list;
    }
}

