/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentConsumerConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentConsumerComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoResult;
import com.ibm.ws.webservices.wssecurity.token.TokenManager;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.auth.token.Token;
import com.ibm.xml.soapsec.Result;
import com.ibm.xml.soapsec.ResultPool;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyInfoConsumer
implements KeyInfoConsumerComponent {
    private static final TraceComponent tc = Tr.register(KeyInfoConsumer.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyInfoConsumer.class.getName();
    public static final String KEYNAME = "KEYNAME";
    public static final String KEYID = "KEYID";
    public static final String STRREF = "STRREF";
    public static final String EMB = "EMB";
    public static final String X509ISSUER = "X509ISSUER";
    public static final String UNKNOWN = "UNKNOWN";
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Element target, Map type, Map context) throws SoapSecurityException {
        Key tmpkey;
        KeyInfoContentConsumerComponent kcon;
        KeyInfoResult result;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "Map type," + "Map context)"));
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        Key key = null;
        KeyInfoConsumerConfig config = (KeyInfoConsumerConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoConsumer.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoConsumerConfig [" + config + "]."));
        }
        boolean succeeded = false;
        KeyInfoContentConsumerConfig kicconfig = null;
        Exception[] exceptions2 = new Exception[config.getContentConsumers().size()];
        int exPos = 0;
        Iterator it = config.getContentConsumers().iterator();
        while (it != null && it.hasNext()) {
            kicconfig = (KeyInfoContentConsumerConfig)it.next();
            result = KeyInfoConsumer.getProcessedResult(context, kicconfig);
            if (result != null) {
                if (result.getError() != null) {
                    exceptions2[exPos++] = result.getError();
                    continue;
                }
                key = result.getKey();
                Map props = kicconfig.getProperties();
                String keyStoreName = (String)props.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("HW keystore name is : " + keyStoreName));
                }
                context.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName);
                if (succeeded) continue;
                result.setUsed(true);
                succeeded = true;
                continue;
            }
            try {
                Token token;
                kcon = kicconfig.getInstance();
                context.put("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey", kicconfig);
                tmpkey = kcon.getKey(target, type, context);
                if (tmpkey == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (key == null) {
                    key = tmpkey;
                    Map props = kicconfig.getProperties();
                    String keyStoreName = (String)props.get("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("HW keystorename is : " + keyStoreName));
                    }
                    context.put("com.ibm.ws.wssecurity.config.keystore.consumerkeyStoreRef", keyStoreName);
                }
                if ((token = TokenManager.getUnprocessedToken(context)) != null) {
                    token.setProcessed(true);
                }
                if ((result = KeyInfoConsumer.getUnprocessedResult(context)) != null) {
                    result.setProcessed(true);
                    if (!succeeded) {
                        result.setUsed(true);
                    }
                    result.setKey(key);
                }
                succeeded = true;
            }
            catch (Exception e) {
                exceptions2[exPos++] = e;
                Token token = TokenManager.getUnprocessedToken(context);
                if (token != null) {
                    token.setProcessed(true);
                }
                if ((result = KeyInfoConsumer.getUnprocessedResult(context)) == null) continue;
                result.setError(e);
                result.setProcessed(true);
            }
        }
        it = config.getOtherContentConsumers().iterator();
        while (it != null && it.hasNext()) {
            kicconfig = (KeyInfoContentConsumerConfig)it.next();
            result = KeyInfoConsumer.getProcessedResult(context, kicconfig);
            if (result != null) continue;
            try {
                kcon = kicconfig.getInstance();
                context.put("com.ibm.wsspi.wssecurity.config.keyinfoContentConsumer.configKey", kicconfig);
                tmpkey = kcon.getKey(target, type, context);
                if (tmpkey == null) {
                    throw SoapSecurityException.format("security.wssecurity.KeyInfoGenerator.getKey02");
                }
                if (key == null) {
                    key = tmpkey;
                }
                if ((result = KeyInfoConsumer.getUnprocessedResult(context)) == null) continue;
                result.setProcessed(true);
            }
            catch (Exception e) {
                result = KeyInfoConsumer.getUnprocessedResult(context);
                if (result == null) continue;
                result.setError(e);
                result.setProcessed(true);
            }
        }
        if (!succeeded) {
            if (exPos == 1) {
                if (exceptions2[0] instanceof SoapSecurityException) {
                    throw (SoapSecurityException)exceptions2[0];
                }
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey04", exceptions2[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(exPos + " exceptions were catched."));
                for (int i = 0; i < exPos; ++i) {
                    Tr.debug((TraceComponent)tc, (String)("No." + i + "'s exception: " + exceptions2[i]));
                }
            }
            throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKey03", exceptions2[exPos - 1]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getkey(Element target,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getKeyInfoType(Element target, String nsWsse) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKeyInfoType(Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "String [" + nsWsse + "])"));
        }
        String kitype = UNKNOWN;
        Element child = DOMUtil.getFirstElement((Node)target);
        if (child != null && DOMUtil.equals((Node)child, (String)Constants.NS_DSIG, (String)"KeyName")) {
            kitype = KEYNAME;
        } else {
            if (!DOMUtil.equals((Node)child, (String)nsWsse, (String)"SecurityTokenReference")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
            if (DOMUtil.equals((Node)(child = DOMUtil.getFirstElement((Node)child)), (String)nsWsse, (String)"KeyIdentifier")) {
                kitype = KEYID;
            } else if (DOMUtil.equals((Node)child, (String)nsWsse, (String)"Reference")) {
                kitype = STRREF;
            } else if (DOMUtil.equals((Node)child, (String)nsWsse, (String)"Embedded")) {
                kitype = EMB;
            } else {
                if (!DOMUtil.equals((Node)child, (String)Constants.NS_DSIG, (String)"X509Data")) throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getKeyInfoType01");
                kitype = X509ISSUER;
            }
        }
        if (!tc.isEntryEnabled()) return kitype;
        Tr.exit((TraceComponent)tc, (String)("getKeyInfoType(Element target,String  nsWsse) returns String[" + kitype + "]"));
        return kitype;
    }

    public static QName getValueType(Element target, String kitype, String nsWsse, int wssVersion) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getValueType(Element target[" + DOMUtil.getDisplayName((Node)target) + "]," + "String kitype[" + kitype + "]," + "String nsWsse[" + nsWsse + "]," + "int wssVersion[" + wssVersion + "])"));
        }
        QName vtype = null;
        if (kitype == STRREF) {
            Element child = DOMUtil.getOneElement((Element)target, (String)nsWsse, (String)"Reference");
            if (child == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType01");
            }
            String vts = DOMUtil.getAttribute((Element)child, (String)"ValueType");
            vtype = DOMUtil.getQName(target, vts, wssVersion);
        } else if (kitype == KEYID) {
            Element child = DOMUtil.getOneElement((Element)target, (String)nsWsse, (String)"KeyIdentifier");
            if (child == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType02");
            }
            String vts = DOMUtil.getAttribute((Element)child, (String)"ValueType");
            vtype = DOMUtil.getQName(target, vts, wssVersion);
        } else if (kitype == EMB) {
            Element child = DOMUtil.getOneElement((Element)target, (String)nsWsse, (String)"Embedded");
            if (child == null) {
                throw SoapSecurityException.format("security.wssecurity.KeyInfoConsumer.getValueType03");
            }
            Element child2 = DOMUtil.getFirstElement((Node)child);
            if (child2 != null) {
                if (child2.getNodeName() == "wsse:BinarySecurityToken" && child2.getNamespaceURI() == nsWsse) {
                    String vts = DOMUtil.getAttribute((Element)child2, (String)"ValueType");
                    vtype = DOMUtil.getQName(target, vts, wssVersion);
                } else {
                    String string = child2.getNodeName();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getValueType(Element target,String kitype,String nsWsse) returns QName[" + vtype + "]"));
        }
        return vtype;
    }

    private static KeyInfoResult getUnprocessedResult(Map context) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getUnprocessedResult(Map context)");
        }
        KeyInfoResult result = null;
        Result[] results = ResultPool.get((Map)context, KeyInfoResult.class);
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = (KeyInfoResult)results[i];
                if (r.isProcessed()) continue;
                result = r;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getUnprocessedResult(Map context) returns KeyInfoResult[" + result + "]"));
        }
        return result;
    }

    private static KeyInfoResult getProcessedResult(Map context, KeyInfoContentConsumerConfig kconfig) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig");
        }
        KeyInfoResult result = null;
        Result[] results = ResultPool.get((Map)context, KeyInfoResult.class);
        if (results != null) {
            for (int i = 0; i < results.length; ++i) {
                KeyInfoResult r = (KeyInfoResult)results[i];
                if (!kconfig.equals(r.getKeyInfoContentConsumer())) continue;
                result = r;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getProcessedResult(Map context,KeyInfoContentConsumerConfig kconfig) returns KeyInfoResult[" + result + "]"));
        }
        return result;
    }
}

