/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.keyinfo;

import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.KeyInfoContentGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoContentGeneratorComponent;
import com.ibm.ws.webservices.wssecurity.keyinfo.STRReferenceContentGenerator;
import com.ibm.ws.webservices.wssecurity.util.DOMUtil;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.TokenGeneratorConfig;
import com.ibm.wsspi.wssecurity.keyinfo.KeyLocator;
import com.ibm.wsspi.wssecurity.token.TokenGeneratorComponent;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.Key;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class KeyIdContentGenerator
implements KeyInfoContentGeneratorComponent {
    private static final TraceComponent tc = Tr.register(KeyIdContentGenerator.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = KeyIdContentGenerator.class.getName();
    private boolean _initialized = false;

    public void init(Map map) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"init(Map map)");
        }
        if (!this._initialized) {
            this._initialized = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init(Map map)");
        }
    }

    public Key getKey(Document doc, Element parent, Map type, Map context) throws SoapSecurityException {
        KeyLocator klocator;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getKey(Document doc[" + DOMUtil.getDisplayName((Node)doc) + "]," + "Element parent[" + DOMUtil.getDisplayName((Node)parent) + "]," + "Map type," + "Map context)"));
        }
        KeyInfoContentGeneratorConfig config = (KeyInfoContentGeneratorConfig)context.remove("com.ibm.wsspi.wssecurity.config.keyinfoContentGenerator.configKey");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("KeyInfoContentGeneratorConfig [" + config + "]."));
        }
        if (!ConfigUtil.isKeyInfoKeyid((String)config.getKeyInfoType())) {
            String keyType = (String)type.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_TYPE);
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            StringBuffer buf = new StringBuffer(clsName).append(" expects KeyInfo's type [KEYID],");
            buf.append(" but the type requested in the configuration is [").append(config.getKeyInfoType()).append("].");
            buf.append(" Please make sure the KeyInfo used for");
            if ("SigningKey".equals(keyType)) {
                buf.append(" siganture");
            } else {
                buf.append(" encryption");
            }
            buf.append(" in the");
            if (isServer) {
                buf.append(" response generator configuration.");
            } else {
                buf.append(" request generator configuration.");
            }
            throw new SoapSecurityException(buf.toString());
        }
        int wssVersion = 0;
        Object obj = context.get("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
        if (obj != null && obj instanceof Integer) {
            wssVersion = (Integer)obj;
        }
        String nsWsse = Constants.NAMESPACES[0][wssVersion];
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEYINFO_TYPE, config.getKeyInfoType());
        if (config.getKeyName() == null) {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
            context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF);
        } else {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
            context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAMEREF, config.getKeyName());
        }
        Map properties = config.getProperties();
        String emitEncodingTypeString = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMIT_ENCODING_TYPE);
        boolean emitEncodingType = false;
        if (emitEncodingTypeString != null && emitEncodingTypeString.length() > 0) {
            emitEncodingType = ConfigUtil.isTrue((String)emitEncodingTypeString);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("emitEncodingTypeString [" + emitEncodingTypeString + "], emitEncodingType [" + emitEncodingType + "]."));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("emitEncodingTypeString [null or empty], emitEncodingType [" + emitEncodingType + "]."));
        }
        String ln = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE_LN);
        String ns = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE_NS);
        QName idType = Constants.ITSHA1;
        if (ln != null && ln.length() > 0) {
            idType = ns == null ? new QName("", ln) : new QName(ns, ln);
        }
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, idType);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_IDTYPE, idType);
        ln = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING_LN);
        ns = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING_NS);
        QName encoding = Constants.BASE64_BINARY;
        if (ln != null && ln.length() > 0) {
            encoding = ns == null ? new QName("", ln) : new QName(ns, ln);
        }
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, encoding);
        context.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ENCODING, encoding);
        ln = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE_LN);
        ns = (String)properties.get(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE_NS);
        TokenGeneratorConfig tconfig = config.getTokenGenerator();
        QName valueType = Constants.X509_SKI_OLD;
        if (ln != null && ln.length() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Found local name " + ln + ", namespace " + (ns == null ? "<null>" : ns)));
            }
            valueType = ns == null ? new QName("", ln) : new QName(ns, ln);
        } else {
            QName tokenType;
            boolean isServer = WSSecurityPlatformContextFactory.getInstance().isServer();
            if (isServer) {
                SOAPMessageContext messageContext = (SOAPMessageContext)context.get("com.ibm.wsspi.wssecurity.core.messageContext");
                if (messageContext == null) {
                    throw SoapSecurityException.format("security.wssecurity.WSSGenerator.s01");
                }
                QName vt = (QName)messageContext.getProperty("com.ibm.ws.webservices.wssecurity.constants.consumedKeyidValuetype");
                if (vt != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Cached X509v3 key idendifier [" + valueType + "] is found.  It is used for value type."));
                    }
                    valueType = vt;
                } else {
                    QName tokenType2;
                    Object configObj = messageContext.getProperty("RequestSenderConfig");
                    if (configObj != null && tconfig != null && (tokenType2 = tconfig.getType()) != null) {
                        if (Constants.X509V3.equals(tokenType2)) {
                            valueType = Constants.X509_SKI;
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Token type is \"" + tokenType2 + "\". Therefore using value type \"" + valueType + "\" for request generator."));
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Token type is \"" + tokenType2 + "\". Leaving value type as \"" + valueType + "\" for request generator."));
                        }
                    }
                }
            } else if (tconfig != null && (tokenType = tconfig.getType()) != null) {
                if (Constants.X509V3.equals(tokenType)) {
                    valueType = Constants.X509_SKI;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Token type is \"" + tokenType + "\". Therefore using value type \"" + valueType + "\" for request generator."));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Token type is \"" + tokenType + "\". Leaving value type as \"" + valueType + "\" for request generator."));
                }
            }
        }
        type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_VALUETYPE, valueType);
        String keyId = null;
        if (tconfig != null) {
            TokenGeneratorComponent tgen = tconfig.getInstance();
            if (tgen == null) {
                throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey01");
            }
            context.put("com.ibm.wsspi.wssecurity.config.tokenGenerator.configKey", tconfig);
            Element security2 = STRReferenceContentGenerator.getSecurityElement(doc, parent, wssVersion, nsWsse, context);
            tgen.invoke(doc, security2, context);
            keyId = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        }
        if ((klocator = config.getKeyLocator()) == null) {
            throw SoapSecurityException.format("security.wssecurity.STRReferenceContentGenerator.getKey03");
        }
        if (keyId != null) {
            type.put(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID, keyId);
        } else {
            type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        }
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_EMBID);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_REFERENCE);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_NAME);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERNAME);
        type.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ISSUERSERIAL);
        Key key = klocator.getKey(type, context);
        if (keyId == null) {
            keyId = (String)context.remove(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_KEY_ID);
        }
        String prefix = DOMUtil.getNamespacePrefix((Element)parent, (String)nsWsse);
        boolean nsDecl = false;
        if (prefix == null) {
            nsDecl = true;
            prefix = "wsse:";
        } else if (prefix.length() > 0) {
            prefix = prefix + ":";
        }
        Element elem = doc.createElementNS(nsWsse, prefix + "SecurityTokenReference");
        if (nsDecl) {
            elem.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:wsse", nsWsse);
        }
        Element elem2 = doc.createElementNS(nsWsse, prefix + "KeyIdentifier");
        if (emitEncodingType) {
            DOMUtil.setQNameAttr(elem2, null, "EncodingType", encoding, wssVersion);
        }
        DOMUtil.setQNameAttr(elem2, null, "ValueType", valueType, wssVersion);
        elem2 = (Element)elem.appendChild(elem2);
        Text text = doc.createTextNode(keyId);
        text = (Text)elem2.appendChild(text);
        elem = (Element)parent.appendChild(elem);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Created the element [" + DOMUtil.getDisplayName((Node)elem) + "]."));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getKey(Document doc,Element parent,Map type,Map context) returns Key[" + key + "]"));
        }
        return key;
    }
}

