/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler.token;

import com.ibm.ws.webservices.wssecurity.handler.token.TokenCache;
import com.ibm.ws.webservices.wssecurity.token.PropagationToken;
import com.ibm.ws.webservices.wssecurity.token.TokenCacheManager;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;

public class TokenCacheManagerImpl
implements TokenCacheManager {
    private static final TraceComponent tc = Tr.register(TokenCacheManagerImpl.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = TokenCacheManagerImpl.class.getName();
    private TokenCache _cache = null;
    private long _cushion = 0L;

    public TokenCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout, long cushion) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("TokenCacheManagerImpl(String cacheName[" + cacheName + "]," + "int cacheSize[" + cacheSize + "]," + "int cacheTimeout[" + cacheTimeout + "]" + "long cushion[" + cushion + "])"));
        }
        int size = ConfigConstants.validTokenCacheSize(cacheSize);
        int timeout = ConfigConstants.validTokenCacheTimeout(cacheTimeout);
        if (cacheName == null || cacheName.length() == 0) {
            cacheName = "WSSTokenCache";
        }
        this._cache = new TokenCache(cacheName, size, timeout * 1000, true, false);
        this._cushion = ConfigConstants.validTokenCushion(cushion);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"TokenCacheManagerImpl(String cacheName, int cacheSize, int cacheTimeout)");
        }
    }

    public PropagationToken getCachedToken(String key) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getCachedToken(String key[" + key + "])"));
        }
        PropagationToken token = null;
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified key is null or zero length.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The token cache is null.");
            }
        } else {
            Object obj = this._cache.get(key);
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There is no object linked with the specified key [" + key + "]."));
                }
            } else if (obj instanceof PropagationToken) {
                token = (PropagationToken)obj;
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There is an object linked with the specified key [" + key + "].  But it's not the Token object: " + obj.getClass().getName()));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCachedToken(String key) returns Token[" + token + "]"));
        }
        return token;
    }

    public void cacheToken(String key, PropagationToken token) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cacheToken(String key[" + key + "]," + "PropagationToken token[" + token + "]"));
        }
        if (key == null || key.length() == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified key is null or zero length.");
            }
        } else if (token == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The specified token is null.");
            }
        } else if (this._cache == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The token cache is null.");
            }
        } else {
            this._cache.put(key, token);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cacheToken(String key, PropagationToken token");
        }
    }

    public long getCushion() throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCushion()");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getCushion() returns " + this._cushion));
        }
        return this._cushion;
    }
}

