/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityResponseSenderBindingConfig;
import com.ibm.etools.webservice.wscommonbnd.CanonicalizationMethod;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.EncryptionKey;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.etools.webservice.wscommonbnd.SigningKey;
import com.ibm.etools.webservice.wscommonext.AddCreatedTimeStamp;
import com.ibm.etools.webservice.wscommonext.ConfidentialPart;
import com.ibm.etools.webservice.wscommonext.ConfidentialPartPart;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.Reference;
import com.ibm.etools.webservice.wscommonext.ReferencePart;
import com.ibm.etools.webservice.wsext.SecurityResponseSenderServiceConfig;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.VariableMap;
import com.ibm.ws.runtime.service.WSSecurityService;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityDefaultConfiguration;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.wsspi.wssecurity.Constants;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.wsspi.wssecurity.config.KeyLocator;
import com.ibm.xml.soapsec.confimpl.PrivateSenderConfig;
import com.ibm.xml.soapsec.enc.EncryptionSettings;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.DOMUtil;
import com.ibm.xml.soapsec.util.Duration;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;

public class WSEMFResponseSenderConfig
extends PrivateSenderConfig {
    private String origin = "non-ws-security";
    private static final TraceComponent tc = Tr.register(WSEMFResponseSenderConfig.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSEMFResponseSenderConfig.class.getName();

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig resSndBnd, SecurityResponseSenderServiceConfig resSndExt, String actorURI, VariableMap varMap, WSSecurityService service) throws SoapSecurityException {
        this(resSndBnd, resSndExt, actorURI, varMap, service, null, null);
    }

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig resSndBnd, SecurityResponseSenderServiceConfig resSndExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader) throws SoapSecurityException {
        this(resSndBnd, resSndExt, actorURI, varMap, service, null, null);
    }

    public WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig resSndBnd, SecurityResponseSenderServiceConfig resSndExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PCBinding portCmpBnd) throws SoapSecurityException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseSenderConfig(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portCmpBnd):", new Object[]{resSndBnd, resSndExt, actorURI, varMap, service, appClassLoader});
        }
        this.init(resSndBnd, resSndExt, actorURI, varMap, service, appClassLoader, portCmpBnd);
        this.origin = "ws-security";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    WSEMFResponseSenderConfig() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSEMFResponseSenderConfig()");
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    final void init(SecurityResponseSenderBindingConfig resSndBnd, SecurityResponseSenderServiceConfig resSndExt, String actorURI, VariableMap varMap, WSSecurityService service, ClassLoader appClassLoader, PCBinding portCmpBnd) throws SoapSecurityException {
        String name;
        int i;
        String tmpActor;
        boolean alwaysTrue;
        EList p;
        Object dconfig;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init(SecurityResponseSenderBindingConfig, SecurityResponseSenderServiceConfig, actorURI, VariableMap, WSSecurityService, ClassLoader, portCmpBnd):", new Object[]{resSndBnd, resSndExt, actorURI, varMap, service, appClassLoader});
        }
        AddCreatedTimeStamp addCreatedTimeStamp = null;
        Confidentiality confidentiality = null;
        Integrity integrity = null;
        String tactor = null;
        WSSecurityDefaultConfiguration config = null;
        if (service != null && (dconfig = service.getConfig()) instanceof WSSecurityDefaultConfiguration) {
            config = (WSSecurityDefaultConfiguration)dconfig;
        }
        Map defaultProps = null;
        Map extProperties = null;
        Map bndProperties = null;
        Map bndParameters = null;
        this._properties = new HashMap();
        if (config != null) {
            WSSGeneratorConfig dgconfig = config.getDefaultGeneratorBinding();
            if (dgconfig != null) {
                defaultProps = dgconfig.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            } else {
                defaultProps = config.getProperties();
                if (defaultProps != null) {
                    this._properties.putAll(defaultProps);
                }
            }
        }
        if (resSndExt != null && (p = resSndExt.getProperties()) != null && (extProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(extProperties);
        }
        if (portCmpBnd != null && (p = portCmpBnd.getParameters()) != null && (bndParameters = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndParameters);
        }
        if (resSndBnd != null && (p = resSndBnd.getProperties()) != null && (bndProperties = ConfigConstants.getProperties(p, varMap)) != null) {
            this._properties.putAll(bndProperties);
        }
        if (resSndExt != null) {
            addCreatedTimeStamp = resSndExt.getAddCreatedTimestamp();
            confidentiality = resSndExt.getConfidentiality();
            integrity = resSndExt.getIntegrity();
            tactor = resSndExt.getActor();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Response Sender Service Config (AddCreatedTimestamp, Confidentiality, Integrity, targetActor):", new Object[]{addCreatedTimeStamp, confidentiality, integrity, tactor});
            }
        }
        this.serviceGetMustUnderstand = !(alwaysTrue = ConfigUtil.getIsTrueProperty((Map)this._properties, (String)Constants.WSSECURITY_GET_MUSTUNDERSTAND));
        ConfigValidation valid = new ConfigValidation(varMap, config);
        if (!valid.confidentialityValid(confidentiality)) {
            throw new SoapSecurityException("Invalid Confidentiality");
        }
        if (!valid.integrityValid(integrity)) {
            throw new SoapSecurityException("Invalid Integrity");
        }
        if (actorURI != null) {
            tmpActor = actorURI.trim();
            if (tmpActor.length() != 0) {
                this.myactor = tmpActor;
            }
        } else {
            this.myactor = null;
        }
        if (tactor != null) {
            tmpActor = tactor.trim();
            if (tmpActor.length() != 0) {
                this.targetactor = tmpActor;
            }
        } else {
            this.targetactor = null;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "actorURI = " + this.myactor + ", actor = " + this.targetactor);
        }
        this.enableCreatedTimestamp = false;
        this.duration = null;
        if (addCreatedTimeStamp != null) {
            this.enableCreatedTimestamp = addCreatedTimeStamp.isFlag();
            String value = addCreatedTimeStamp.getExpires();
            if (value != null && value.length() > 0) {
                try {
                    this.duration = Duration.parse((String)value);
                }
                catch (ParseException pe) {
                    String msgKey = "security.wssecurity.CommonSenderConfig.sconf07";
                    FFDCFilter.processException((Throwable)pe, clsName + ".WSEMFResponseSenderConfig", "178", (Object)this);
                    Tr.error(tc, msgKey, value);
                    throw SoapSecurityException.format(msgKey, value, (Throwable)pe);
                }
            }
        }
        if (integrity != null) {
            int count = integrity.getReferences().size();
            for (i = 0; i < count; ++i) {
                Reference ref = (Reference)integrity.getReferences().get(i);
                ReferencePart refPart = ref.getPart();
                name = refPart.getName();
                this.integralParts.add(name);
                if (!name.equals("securitytoken")) continue;
                this.isSecTokenSigned = true;
            }
        }
        if (confidentiality != null) {
            int count = confidentiality.getConfidentialParts().size();
            for (i = 0; i < count; ++i) {
                ConfidentialPart confPart = (ConfidentialPart)confidentiality.getConfidentialParts().get(i);
                ConfidentialPartPart confPartPart = confPart.getPart();
                name = confPartPart.getName();
                this.confidentialParts.add(name);
                if (!name.equals("usernametoken")) continue;
                this.isUsernameTokenEncrypted = true;
            }
        }
        EncryptionInfo encryptionInfo = null;
        EList keyLocators = null;
        SigningInfo signingInfo = null;
        if (resSndBnd != null) {
            encryptionInfo = resSndBnd.getEncryptionInfo();
            keyLocators = resSndBnd.getKeyLocators();
            signingInfo = resSndBnd.getSigningInfo();
            EList p2 = resSndBnd.getProperties();
            if (p2 != null) {
                bndProperties = ConfigConstants.getProperties(p2, varMap);
            }
            if (tc.isDebugEnabled()) {
                if (bndProperties != null) {
                    Tr.debug(tc, "Response Sender Binding Config (EncryptionInfo, KeyLocators, SigningInfo, Property):", new Object[]{encryptionInfo, keyLocators, signingInfo, bndProperties});
                } else {
                    Tr.debug(tc, "Response Sender Binding Config (EncryptionInfo, KeyLocators, SigningInfo):", new Object[]{encryptionInfo, keyLocators, signingInfo});
                }
            }
        }
        if (bndProperties != null || bndProperties.size() != 0) {
            String tmpIN = (String)bndProperties.get(Constants.WSSECURITY_INCLUSIVE_NAMESPACES);
            this.inclusiveNamespaces = ConfigUtil.isTrue((String)tmpIN);
        }
        if (!valid.senderSigningInfoValid(signingInfo, null, null, integrity)) {
            throw new SoapSecurityException("Invalid sender SigningInfo");
        }
        if (!valid.encryptionInfoValid(encryptionInfo, keyLocators, confidentiality)) {
            throw new SoapSecurityException("Invalid EncryptionInfo");
        }
        if (encryptionInfo != null) {
            EncryptionKey encryptionKey = encryptionInfo.getEncryptionKey();
            String encKeyName = null;
            String encKeyLocRef = null;
            if (encryptionKey != null) {
                encKeyName = encryptionKey.getName();
                encKeyLocRef = encryptionKey.getLocatorRef();
            }
            DataEncryptionMethod dataEncryptionMethod = encryptionInfo.getEncryptionMethod();
            String dataEncAlg = null;
            if (dataEncryptionMethod != null) {
                dataEncAlg = dataEncryptionMethod.getAlgorithm();
            }
            KeyEncryptionMethod keyEncryptionMethod = encryptionInfo.getKeyEncryptionMethod();
            String keyEncAlg = null;
            if (keyEncryptionMethod != null) {
                keyEncAlg = keyEncryptionMethod.getAlgorithm();
            }
            KeyLocator locator = ConfigConstants.findKeyLocator(keyLocators, encKeyLocRef, varMap, config, appClassLoader);
            if (dataEncAlg == null || encKeyName == null || locator == null) {
                String msgKey = "security.wssecurity.IncompleteEncryptionInfo";
                if (dataEncAlg == null) {
                    Tr.warning(tc, msgKey, "Data Encryption Algorithm");
                }
                if (encKeyName == null) {
                    Tr.warning(tc, msgKey, "Encryption Key Name");
                }
                if (locator == null) {
                    Tr.warning(tc, msgKey, "Key Locator");
                }
            }
            this.encryptionSettings = new EncryptionSettings(dataEncAlg, keyEncAlg, encKeyName, locator);
        }
        if (signingInfo != null) {
            CanonicalizationMethod c14nMethod = signingInfo.getCanonicalizationMethod();
            String c14nAlgorithm = null;
            if (c14nMethod == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No CanonicalizationMethod defined");
                }
            } else {
                c14nAlgorithm = c14nMethod.getAlgorithm();
            }
            this.c14nMethod = c14nAlgorithm;
            SignatureMethod signatureMethod = signingInfo.getSignatureMethod();
            String signatureAlgorithm = null;
            if (signatureMethod == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SignatureMethod defined");
                }
            } else {
                signatureAlgorithm = signatureMethod.getAlgorithm();
            }
            this.signatureMethod = signatureAlgorithm;
            DigestMethod digestMethod = signingInfo.getDigestMethod();
            String digestAlgorithm = null;
            if (digestMethod == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No DigestMethod defined");
                }
            } else {
                digestAlgorithm = digestMethod.getAlgorithm();
            }
            this.digestMethod = digestAlgorithm;
            SigningKey signingKey = signingInfo.getSigningKey();
            if (signingKey != null) {
                String signingKeyLocRef = signingKey.getLocatorRef();
                this.keyName = signingKey.getName();
                this.keyLocator = ConfigConstants.findKeyLocator(keyLocators, signingKeyLocRef, varMap, config, appClassLoader);
            }
        }
        this.processPrivateConfig(DOMUtil.getPrivateConfig((boolean)true));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, this.getLogProperties(defaultProps, bndParameters, extProperties, bndProperties, "response", "sender"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSEMFResponseSenderConfig()");
        }
    }

    final String getOrigin() {
        return this.origin;
    }
}

