/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.handler;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseReceiverBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscext.ClientServiceConfig;
import com.ibm.etools.webservice.wscext.LoginConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestGeneratorServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityRequestSenderServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseConsumerServiceConfig;
import com.ibm.etools.webservice.wscext.SecurityResponseReceiverServiceConfig;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.etools.webservice.wscommonext.Confidentiality;
import com.ibm.etools.webservice.wscommonext.Integrity;
import com.ibm.etools.webservice.wscommonext.RequiredConfidentiality;
import com.ibm.etools.webservice.wscommonext.RequiredIntegrity;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.handlers.jaxrpc.JAXRPCHandler;
import com.ibm.ws.webservices.engine.handlers.soap.SOAPPort;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.wssecurity.Constants;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCache;
import com.ibm.ws.webservices.wssecurity.core.DistributedConfigCacheFactory;
import com.ibm.ws.webservices.wssecurity.core.WSSConsumer;
import com.ibm.ws.webservices.wssecurity.core.WSSGenerator;
import com.ibm.ws.webservices.wssecurity.core.WSSecurityPlatformContextFactory;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestConsumerConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestReceiverConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFRequestSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseConsumerConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseReceiverConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSEMFResponseSenderConfig;
import com.ibm.ws.webservices.wssecurity.handler.WSSecurityConsumerBase;
import com.ibm.ws.webservices.wssecurity.handler.WSSecurityGeneratorBase;
import com.ibm.ws.webservices.wssecurity.handler.WSSoapSecurityReceiverBase;
import com.ibm.ws.webservices.wssecurity.handler.WSSoapSecuritySenderBase;
import com.ibm.ws.webservices.wssecurity.util.ConfigConstants;
import com.ibm.ws.webservices.wssecurity.util.NamespaceUtil;
import com.ibm.wsspi.webservices.rpc.handler.GenericHandler;
import com.ibm.wsspi.webservices.rpc.handler.SystemHandler;
import com.ibm.wsspi.webservices.rpc.handler.soap.SOAPMessageContext;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.ReceiverConfig;
import com.ibm.xml.soapsec.SenderConfig;
import com.ibm.xml.soapsec.proxy.FaultProxy;
import com.ibm.xml.soapsec.proxy.MessageContextProxy;
import com.ibm.xml.soapsec.util.ConfigUtil;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GlobalSecurityHandler
extends GenericHandler
implements SystemHandler {
    private static final String clsName = GlobalSecurityHandler.class.getName();
    private static final TraceComponent tc = Tr.register(GlobalSecurityHandler.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";
    private boolean _isServer = true;
    private Map _configMap;
    private WSSoapSecuritySenderBase _sh = null;
    private WSSoapSecurityReceiverBase _rh = null;
    private WSSecurityGeneratorBase _gh = null;
    private WSSecurityConsumerBase _ch = null;
    private boolean isWebSphereClient = true;
    private static final JAXRPCHandler.QNameSet securityHeaderQNames = new JAXRPCHandler.QNameSet();

    public GlobalSecurityHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "GlobalSecurityHandler()");
        }
        boolean bl = this.isWebSphereClient = !WSSecurityPlatformContextFactory.getInstance().isServer();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "GlobalSecurityHandler()");
        }
    }

    public void init(HandlerInfo info) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init()");
        }
        super.init(info);
        this._configMap = info.getHandlerConfig();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Options: ", new Object[]{this._configMap});
        }
        this._sh = new WSSoapSecuritySenderBase();
        this._rh = new WSSoapSecurityReceiverBase();
        this._gh = new WSSecurityGeneratorBase();
        this._ch = new WSSecurityConsumerBase();
        if (this._configMap != null) {
            this._isServer = this._configMap.get(GenericHandler.HANDLER_PARAM_ROLE).equals(GenericHandler.HANDLER_PARAM_ROLE_SERVER);
            for (String name : this._configMap.keySet()) {
                String value = (String)this._configMap.get(name);
                this._sh.setHandlerOption(name, value);
                this._rh.setHandlerOption(name, value);
                this._gh.setHandlerOption(name, value);
                this._ch.setHandlerOption(name, value);
            }
        }
        this._sh.init();
        this._rh.init();
        try {
            this._gh.init();
            this._ch.init();
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, clsName + ".init", "201", (Object)this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public boolean handleRequest(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest:", new Object[]{context});
        }
        final SOAPMessageContext ctx = (SOAPMessageContext)context;
        if (this._isServer) {
            Object obj = ctx.getProperty("RequestReceiverConfig");
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig or ReceiverConfig found");
                }
            } else if (obj instanceof WSSConsumerConfig) {
                this.handleRequest6(ctx, obj);
            } else if (obj instanceof ReceiverConfig) {
                this.handleRequest5(ctx, obj);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSConsumerConfig or ReceiverConfig: " + obj.getClass().getName());
            }
        } else {
            boolean existCbind;
            Object obj = null;
            final String cdd = (String)ctx.getProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CDD);
            final String cbind = (String)ctx.getProperty(com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CBIND);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CDD + " [" + cdd + "], " + com.ibm.wsspi.wssecurity.Constants.WSSECURITY_CBIND + " [" + cbind + "].");
            }
            final boolean existCdd = cdd != null && cdd.length() != 0;
            boolean bl = existCbind = cbind != null && cbind.length() != 0;
            if (existCdd) {
                final DistributedConfigCache dcc = _disCache._cache;
                obj = AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        boolean existCbind2;
                        URI fdd = existCdd ? URI.createURI(cdd) : null;
                        boolean existCdd2 = existCdd && !fdd.isEmpty();
                        URI fbind = existCbind ? URI.createURI(cbind) : null;
                        boolean bl = existCbind2 = !existCbind || !fdd.isEmpty();
                        if (!existCdd2) {
                            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s01", (String[])new String[]{cdd}));
                        }
                        if (!existCbind2) {
                            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s02", (String[])new String[]{cbind}));
                        }
                        CachedEntry cachedEntry = null;
                        Object obj = null;
                        Object pobj = null;
                        if (dcc != null) {
                            block11: {
                                try {
                                    cachedEntry = (CachedEntry)dcc.getConfigObject(fdd);
                                }
                                catch (SoapSecurityException e) {
                                    if (!tc.isDebugEnabled()) break block11;
                                    Tr.debug(tc, "Exception occured when getting Cached Context", new Object[]{e});
                                    FFDCFilter.processException((Throwable)e, clsName + ".handleRequest", "271", this);
                                }
                            }
                            if (cachedEntry != null) {
                                if (cachedEntry.isWas6()) {
                                    obj = cachedEntry.getGeneratorConfig();
                                    pobj = cachedEntry.getConsumerConfig();
                                } else {
                                    obj = cachedEntry.getSenderConfig();
                                    pobj = cachedEntry.getReceiverConfig();
                                }
                                if (pobj != null) {
                                    ctx.setProperty("ResponseReceiverConfig", pobj);
                                }
                                return obj;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "getConfigObject returns null");
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Distributed Config Cache instance is null, continue normal processing");
                        }
                        obj = GlobalSecurityHandler.this.loadConfig(fdd, fbind, ctx);
                        return obj;
                    }
                });
            } else {
                obj = ctx.getProperty("RequestSenderConfig");
            }
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig or SenderConfig found");
                }
            } else if (obj instanceof WSSGeneratorConfig) {
                this.handleRequest6(ctx, obj);
            } else if (obj instanceof SenderConfig) {
                if (existCdd) {
                    ctx.setProperty("RequestSenderConfig", obj);
                }
                this.handleRequest5(ctx, obj);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSGeneratorConfig or SenderConfig: " + obj.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest");
        }
        return true;
    }

    private boolean handleRequest5(SOAPMessageContext context, Object config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest5(SOAPMessageContext, Object):", new Object[]{context, config});
        }
        try {
            if (this._isServer) {
                ReceiverConfig rconfig = (ReceiverConfig)config;
                if (rconfig != null) {
                    if (this.shouldProcessSecurityHeader(rconfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer buf = new StringBuffer("isServer=");
                            buf.append(this._isServer).append(", calling ");
                            buf.append(((Object)((Object)this._rh)).getClass().getName());
                            buf.append(".invoke(), context=").append(context);
                            buf.append(", Config Class Name=").append(rconfig.getClass().getName());
                            buf.append(", source=");
                            if (rconfig instanceof WSEMFRequestReceiverConfig) {
                                buf.append(((WSEMFRequestReceiverConfig)rconfig).getOrigin());
                            } else {
                                buf.append("unknown");
                            }
                            Tr.debug(tc, buf.toString());
                        }
                        this._rh.invoke(MessageContextProxy.getInstance((Object)context));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No ReceiverConfig found");
                }
            } else {
                SenderConfig sconfig = (SenderConfig)config;
                if (sconfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer buf = new StringBuffer("isServer=");
                        buf.append(this._isServer).append(", calling ");
                        buf.append(((Object)((Object)this._sh)).getClass().getName());
                        buf.append(".invoke(), context=").append(context);
                        buf.append(", Config Class Name=").append(sconfig.getClass().getName());
                        buf.append(", source=");
                        if (sconfig instanceof WSEMFRequestSenderConfig) {
                            buf.append(((WSEMFRequestSenderConfig)sconfig).getOrigin());
                        } else {
                            buf.append("unknown");
                        }
                        Tr.debug(tc, buf.toString());
                    }
                    this._sh.invoke(MessageContextProxy.getInstance((Object)context));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SenderConfig found");
                }
            }
        }
        catch (FaultProxy e) {
            FFDCFilter.processException((Throwable)e.get(), clsName + ".handleRequest5", "387", (Object)this);
            throw new JAXRPCException(e.get());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest5(SOAPMessageContext, Object)");
        }
        return true;
    }

    private boolean handleRequest6(SOAPMessageContext context, Object config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleRequest6(SOAPMessageContext, Object):", new Object[]{context, config});
        }
        try {
            if (this._isServer) {
                WSSConsumerConfig cconfig = (WSSConsumerConfig)config;
                if (cconfig != null) {
                    if (this.shouldProcessSecurityHeader(cconfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer buf = new StringBuffer("isServer=");
                            buf.append(this._isServer).append(", calling ");
                            buf.append(this._ch.getClass().getName());
                            buf.append(".invoke(), context=").append(context);
                            buf.append(", Config Class Name=").append(cconfig.getClass().getName());
                            buf.append(", source=");
                            if (cconfig instanceof WSEMFRequestConsumerConfig) {
                                buf.append(((WSEMFRequestConsumerConfig)cconfig).getOrigin());
                            } else {
                                buf.append("unknown");
                            }
                            Tr.debug(tc, buf.toString());
                        }
                        this._ch.invoke(context, cconfig);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig found");
                }
            } else {
                WSSGeneratorConfig gconfig = (WSSGeneratorConfig)config;
                if (gconfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer buf = new StringBuffer("isServer=");
                        buf.append(this._isServer).append(", calling ");
                        buf.append(this._gh.getClass().getName());
                        buf.append(".invoke(), context=").append(context);
                        buf.append(", Config Class Name=").append(gconfig.getClass().getName());
                        buf.append(", source=");
                        if (gconfig instanceof WSEMFRequestGeneratorConfig) {
                            buf.append(((WSEMFRequestGeneratorConfig)gconfig).getOrigin());
                        } else {
                            buf.append("unknown");
                        }
                        Tr.debug(tc, buf.toString());
                    }
                    this._gh.invoke(context, gconfig);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig found");
                }
            }
        }
        catch (WebServicesFault e) {
            FFDCFilter.processException((Throwable)e, clsName + ".handleRequest6", "454", (Object)this);
            throw new JAXRPCException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleRequest6(SOAPMessageContext, Object)");
        }
        return true;
    }

    public boolean handleResponse(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse:", new Object[]{context});
        }
        SOAPMessageContext ctx = (SOAPMessageContext)context;
        if (this._isServer) {
            Object obj = ctx.getProperty("ResponseSenderConfig");
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig or SenderConfig found");
                }
            } else if (obj instanceof WSSGeneratorConfig) {
                this.handleResponse6(ctx, obj);
            } else if (obj instanceof SenderConfig) {
                this.handleResponse5(ctx, obj);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSGeneratorConfig or SenderConfig: " + obj.getClass().getName());
            }
        } else {
            Object obj = ctx.getProperty("RequestSenderConfig");
            if (obj != null) {
                String targetEndpointAddress = (String)ctx.getProperty("javax.xml.rpc.service.endpoint.address");
                Object token = null;
                if (obj instanceof WSSGeneratorConfig) {
                    token = ctx.getProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken");
                    if (targetEndpointAddress != null && targetEndpointAddress.length() != 0 && token != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TargetEndpointAddress is [" + targetEndpointAddress + "]");
                            Tr.debug(tc, "Cached username token is [" + token + "]");
                        }
                        this._gh.saveObject(targetEndpointAddress, token);
                    }
                } else if (obj instanceof SenderConfig) {
                    token = ctx.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken");
                    if (targetEndpointAddress != null && targetEndpointAddress.length() != 0 && token != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "TargetEndpointAddress is [" + targetEndpointAddress + "]");
                            Tr.debug(tc, "Cached username token is [" + token + "]");
                        }
                        this._sh.saveObject(targetEndpointAddress, token);
                    }
                }
            }
            if ((obj = ctx.getProperty("ResponseReceiverConfig")) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig or ReceiverConfig found");
                }
            } else if (obj instanceof WSSConsumerConfig) {
                this.handleResponse6(ctx, obj);
            } else if (obj instanceof ReceiverConfig) {
                this.handleResponse5(ctx, obj);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSConsumerConfig or ReceiverConfig: " + obj.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse");
        }
        return true;
    }

    private boolean handleResponse5(SOAPMessageContext context, Object config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse5(SOAPMessageContext, Object):", new Object[]{context, config});
        }
        try {
            if (this._isServer) {
                SenderConfig sconfig = (SenderConfig)config;
                if (sconfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer buf = new StringBuffer("isServer=");
                        buf.append(this._isServer).append(", calling ");
                        buf.append(((Object)((Object)this._sh)).getClass().getName());
                        buf.append(".invoke(), context=").append(context);
                        buf.append(", Config Class Name=").append(sconfig.getClass().getName());
                        buf.append(", source=");
                        if (sconfig instanceof WSEMFResponseSenderConfig) {
                            buf.append(((WSEMFResponseSenderConfig)sconfig).getOrigin());
                        } else {
                            buf.append("unknown");
                        }
                        Tr.debug(tc, buf.toString());
                    }
                    this._sh.invoke(MessageContextProxy.getInstance((Object)context));
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No SenderConfig found");
                }
            } else {
                ReceiverConfig rconfig = (ReceiverConfig)config;
                if (rconfig != null) {
                    if (this.shouldProcessSecurityHeader(rconfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer buf = new StringBuffer("isServer=");
                            buf.append(this._isServer).append(", calling ");
                            buf.append(((Object)((Object)this._rh)).getClass().getName());
                            buf.append(".invoke(), context=").append(context);
                            buf.append(", Config Class Name=").append(rconfig.getClass().getName());
                            buf.append(", source=");
                            if (rconfig instanceof WSEMFResponseReceiverConfig) {
                                buf.append(((WSEMFResponseReceiverConfig)rconfig).getOrigin());
                            } else {
                                buf.append("unknown");
                            }
                            Tr.debug(tc, buf.toString());
                        }
                        this._rh.invoke(MessageContextProxy.getInstance((Object)context));
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No ReceiverConfig found");
                }
            }
        }
        catch (FaultProxy e) {
            FFDCFilter.processException((Throwable)e.get(), clsName + ".handleResponse5", "598", (Object)this);
            throw new JAXRPCException(e.get());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse(SOAPMessageContext, Object)");
        }
        return true;
    }

    private boolean handleResponse6(SOAPMessageContext context, Object config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleResponse6(SOAPMessageContext, Object):", new Object[]{context, config});
        }
        try {
            HashMap<String, SOAPMessageContext> lcontext = new HashMap<String, SOAPMessageContext>();
            lcontext.put("com.ibm.wsspi.wssecurity.core.messageContext", context);
            if (this._isServer) {
                WSSGeneratorConfig gconfig = (WSSGeneratorConfig)config;
                if (gconfig != null) {
                    if (tc.isDebugEnabled()) {
                        StringBuffer buf = new StringBuffer("isServer=");
                        buf.append(this._isServer).append(", calling ");
                        buf.append(this._gh.getClass().getName());
                        buf.append(".invoke(), context=").append(context);
                        buf.append(", Config Class Name=").append(gconfig.getClass().getName());
                        buf.append(", source=");
                        if (gconfig instanceof WSEMFResponseGeneratorConfig) {
                            buf.append(((WSEMFResponseGeneratorConfig)gconfig).getOrigin());
                        } else {
                            buf.append("unknown");
                        }
                        Tr.debug(tc, buf.toString());
                    }
                    this._gh.invoke(context, gconfig);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig found");
                }
            } else {
                WSSConsumerConfig cconfig = (WSSConsumerConfig)config;
                if (cconfig != null) {
                    if (this.shouldProcessSecurityHeader(cconfig.getBypassSecurityHeaderSetting())) {
                        if (tc.isDebugEnabled()) {
                            StringBuffer buf = new StringBuffer("isServer=");
                            buf.append(this._isServer).append(", calling ");
                            buf.append(this._ch.getClass().getName());
                            buf.append(".invoke(), context=").append(context);
                            buf.append(", Config Class Name=").append(cconfig.getClass().getName());
                            buf.append(", source=");
                            if (cconfig instanceof WSEMFResponseConsumerConfig) {
                                buf.append(((WSEMFResponseConsumerConfig)cconfig).getOrigin());
                            } else {
                                buf.append("unknown");
                            }
                            Tr.debug(tc, buf.toString());
                        }
                        this._ch.invoke(context, cconfig);
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig found");
                }
            }
        }
        catch (WebServicesFault e) {
            FFDCFilter.processException((Throwable)e, clsName + ".handleResponse6", "666", (Object)this);
            throw new JAXRPCException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleResponse6(SOAPMessageContext, Object)");
        }
        return true;
    }

    public boolean handleFault(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault", new Object[]{context});
        }
        SOAPMessageContext ctx = (SOAPMessageContext)context;
        if (this._isServer) {
            Object obj = ctx.getProperty("ResponseSenderConfig");
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSGeneratorConfig or SenderConfig found");
                }
            } else if (obj instanceof WSSGeneratorConfig) {
                this.handleFault6(ctx, obj);
            } else if (obj instanceof SenderConfig) {
                this.handleFault5(ctx, obj);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSGeneratorConfig or SenderConfig: " + obj.getClass().getName());
            }
        } else {
            Object obj = ctx.getProperty("RequestReceiverConfig");
            if (obj == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No WSSConsumerConfig or ReceiverConfig found");
                }
            } else if (obj instanceof WSSConsumerConfig) {
                this.handleFault6(ctx, obj);
            } else if (obj instanceof ReceiverConfig) {
                this.handleFault5(ctx, obj);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to cast to WSSConsumerConfig or ReceiverConfig: " + obj.getClass().getName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault");
        }
        return true;
    }

    private boolean handleFault5(SOAPMessageContext context, Object config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault5(SOAPMessageContext, Object):", new Object[]{context, config});
        }
        if (this._isServer) {
            SenderConfig sconfig = (SenderConfig)config;
            if (sconfig != null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("isServer=");
                    buf.append(this._isServer).append(", calling ");
                    buf.append(((Object)((Object)this._rh)).getClass().getName());
                    buf.append(".onFault(), context=").append(context);
                    buf.append(", Config Class Name=").append(sconfig.getClass().getName());
                    buf.append(", source=");
                    if (sconfig instanceof WSEMFResponseSenderConfig) {
                        buf.append(((WSEMFResponseSenderConfig)sconfig).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    Tr.debug(tc, buf.toString());
                }
                this._rh.onFault(MessageContextProxy.getInstance((Object)context));
            } else {
                Tr.debug(tc, "No SenderConfig found");
            }
        } else {
            ReceiverConfig rconfig;
            SOAPPart sp;
            SOAPMessage sm;
            if (this.isWebSphereClient && (sm = context.getMessage()) != null && (sp = sm.getSOAPPart()) != null) {
                try {
                    String wsseNS;
                    QName qname;
                    String faultCode;
                    SOAPFault fault;
                    SOAPBody sb;
                    boolean authenticationFailed = true;
                    SOAPEnvelope se = sp.getEnvelope();
                    if (se != null && (sb = se.getBody()) != null && sb.hasFault() && (fault = sb.getFault()) != null && (faultCode = fault.getFaultCode()) != null && faultCode.length() != 0 && !(qname = com.ibm.xml.soapsec.Constants.getQName((String)(wsseNS = ConfigConstants.getWSSENS(context)), (String)"FailedAuthentication")).getLocalPart().equals(faultCode)) {
                        authenticationFailed = false;
                    }
                    if (!authenticationFailed) {
                        Object token = context.getProperty("com.ibm.wsspi.wssecurity.username.basicAuthToken");
                        String targetEndpointAddress = (String)context.getProperty("javax.xml.rpc.service.endpoint.address");
                        if (targetEndpointAddress != null && targetEndpointAddress.length() != 0 && token != null) {
                            this._gh.saveObject(targetEndpointAddress, token);
                        }
                    }
                }
                catch (SOAPException e) {
                    FFDCFilter.processException((Throwable)e, clsName + ".handleFault5", "792", (Object)this);
                }
                catch (SoapSecurityException e) {
                    FFDCFilter.processException((Throwable)e, clsName + ".handleFault5", "794", (Object)this);
                }
            }
            if ((rconfig = (ReceiverConfig)config) != null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("isServer=");
                    buf.append(this._isServer).append(", calling ");
                    buf.append(((Object)((Object)this._sh)).getClass().getName());
                    buf.append(".onFault(), context=").append(context);
                    buf.append(", Config Class Name=").append(rconfig.getClass().getName());
                    buf.append(", source=");
                    if (rconfig instanceof WSEMFResponseReceiverConfig) {
                        buf.append(((WSEMFResponseReceiverConfig)rconfig).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    Tr.debug(tc, buf.toString());
                }
                this._sh.onFault(MessageContextProxy.getInstance((Object)context));
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ReceiverConfig found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault5(SOAPMessageContext, Object)");
        }
        return true;
    }

    private boolean handleFault6(SOAPMessageContext context, Object config) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault6(SOAPMessageContext, Object):", new Object[]{context, config});
        }
        if (this._isServer) {
            WSSGeneratorConfig gconfig = (WSSGeneratorConfig)config;
            if (gconfig != null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("isServer=");
                    buf.append(this._isServer).append(", calling ");
                    buf.append(this._ch.getClass().getName());
                    buf.append(".onFault(), context=").append(context);
                    buf.append(", Config Class Name=").append(config.getClass().getName());
                    buf.append(", source=");
                    if (gconfig instanceof WSEMFResponseGeneratorConfig) {
                        buf.append(((WSEMFResponseGeneratorConfig)gconfig).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    Tr.debug(tc, buf.toString());
                }
                this._ch.onFault(context);
            } else {
                Tr.debug(tc, "No SenderConfig found");
            }
        } else {
            SOAPPart sp;
            SOAPMessage sm;
            if (this.isWebSphereClient && (sm = context.getMessage()) != null && (sp = sm.getSOAPPart()) != null) {
                try {
                    String faultCode;
                    SOAPFault fault;
                    SOAPBody sb;
                    boolean authenticationFailed = true;
                    SOAPEnvelope se = sp.getEnvelope();
                    if (se != null && (sb = se.getBody()) != null && sb.hasFault() && (fault = sb.getFault()) != null && (faultCode = fault.getFaultCode()) != null && faultCode.length() != 0) {
                        String wsseNS;
                        QName qname;
                        int wssVersion = 0;
                        Object obj = context.getProperty("com.ibm.ws.webservices.wssecurity.constants.wssVersion");
                        if (obj != null && obj instanceof Integer) {
                            wssVersion = (Integer)obj;
                        }
                        if (!(qname = com.ibm.xml.soapsec.Constants.getQName((String)(wsseNS = Constants.NAMESPACES[0][wssVersion]), (String)"FailedAuthentication")).getLocalPart().equals(faultCode)) {
                            authenticationFailed = false;
                        }
                    }
                    if (!authenticationFailed) {
                        Object token = context.getProperty("com.ibm.ws.webservices.wssecurity.handler.GlobalSecurityHandler.basicAuthToken");
                        String targetEndpointAddress = (String)context.getProperty("javax.xml.rpc.service.endpoint.address");
                        if (targetEndpointAddress != null && targetEndpointAddress.length() != 0 && token != null) {
                            this._sh.saveObject(targetEndpointAddress, token);
                        }
                    }
                }
                catch (SOAPException e) {
                    FFDCFilter.processException((Throwable)e, clsName + ".handleFault6", "903", (Object)this);
                }
                catch (SoapSecurityException e) {
                    FFDCFilter.processException((Throwable)e, clsName + ".handleFault6", "905", (Object)this);
                }
            }
            WSSConsumerConfig cconfig = (WSSConsumerConfig)config;
            if (config != null) {
                if (tc.isDebugEnabled()) {
                    StringBuffer buf = new StringBuffer("isServer=");
                    buf.append(this._isServer).append(", calling ");
                    buf.append(this._gh.getClass().getName());
                    buf.append(".onFault(), context=").append(context);
                    buf.append(", Config Class Name=").append(config.getClass().getName());
                    buf.append(", source=");
                    if (cconfig instanceof WSEMFResponseConsumerConfig) {
                        buf.append(((WSEMFResponseConsumerConfig)cconfig).getOrigin());
                    } else {
                        buf.append("unknown");
                    }
                    Tr.debug(tc, buf.toString());
                }
                this._gh.onFault(context);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No ReceiverConfig found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleFault(SOAPMessageContext, Object)");
        }
        return true;
    }

    public void preHandleIncoming(MessageContext context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "preHandleIncoming", context);
        }
        Object config = null;
        com.ibm.ws.webservices.engine.MessageContext ctx = (com.ibm.ws.webservices.engine.MessageContext)context;
        if (this._isServer && !ctx.getPastPivot()) {
            config = ctx.getProperty("RequestReceiverConfig");
        } else if (!this._isServer && ctx.getPastPivot()) {
            config = ctx.getProperty("ResponseReceiverConfig");
        }
        if (config != null) {
            if (config instanceof WSSConsumerConfig) {
                WSSConsumerConfig conf = (WSSConsumerConfig)config;
                boolean idCheck = GlobalSecurityHandler.requireIdCheck(ctx, conf);
                if (idCheck) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Setting High Fidelity.");
                    }
                    ctx.setHighFidelity(true);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not Setting High Fidelity.");
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "config not instanceof WSSConsumerConfig; setting High Fidelity.");
                }
                ctx.setHighFidelity(true);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "High fidelity = " + ctx.isHighFidelity());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "preHandleIncoming");
        }
    }

    private static boolean requireIdCheck(com.ibm.ws.webservices.engine.MessageContext messageContext, WSSConsumerConfig config) {
        NodeList secList;
        block21: {
            Element header;
            block20: {
                SOAPPart soapPart;
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "requireIdCheck.");
                }
                if (config.isVerificationRequired() || config.isDecryptionRequired()) {
                    messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness", "true");
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "requireIdCheck. Verification or decryption required; ID validation is required.");
                    }
                    return true;
                }
                messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness", "false");
                SOAPMessage message = messageContext.getMessage();
                SOAPPart doc = soapPart = message.getSOAPPart();
                header = null;
                try {
                    header = WSSGenerator.getHeader((Document)doc, false);
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug(tc, "requireIdCheck. Exception occur while calling WSSGenerator.getHeader():", e);
                }
            }
            if (header == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "requireIdCheck. Not header from WSSGenerator, ID validation not required.");
                }
                return false;
            }
            int soapVersion = NamespaceUtil.isSoap(header.getNamespaceURI());
            if (tc.isDebugEnabled()) {
                String msg = null;
                msg = soapVersion == 0 ? "The spec of SOAP is SOAP1.1." : (soapVersion == 1 ? "The spec of SOAP is SOAP1.2." : "Unknown spec of SOAP: " + header.getNamespaceURI());
                Tr.debug(tc, msg);
            }
            secList = null;
            try {
                secList = WSSConsumer.getSecurityHeaders(header, soapVersion, config.isUltimateReceiver(), config.getMyActor());
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block21;
                Tr.debug(tc, "requireIdCheck. Exception occur when call ing WSSConsumer.getSecurityHeaders() :", e);
            }
        }
        if (secList == null || secList.getLength() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "requireIdCheck. Security header not found, ID validation not required.");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, secList.getLength() + " security headers found");
        }
        boolean skipIdCheck = false;
        try {
            Element el = (Element)secList.item(0);
            String id = WSSConsumer.getId(el);
            if (id == null) {
                skipIdCheck = true;
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "requireIdCheck. Exception occur when calling WSSConsumer.getId() :", e);
            }
            skipIdCheck = true;
        }
        if (skipIdCheck) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "requireIdCheck. ID validation not required.");
            }
            return false;
        }
        messageContext.setProperty("com.ibm.ws.webservices.wssecurity.constants.checkIdUniqueness", "true");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requireIdCheck. ID validation is required.");
        }
        return true;
    }

    private Object loadConfig(URI cdd, URI cbind, SOAPMessageContext ctx) {
        SOAPPort port;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadConfig(URI, URI, SOAPMesageContext): ", new Object[]{cdd, cbind, ctx});
        }
        Object config = null;
        WASResourceSetImpl resSet = new WASResourceSetImpl();
        SecurityRequestSenderServiceConfig reqSndExt = null;
        SecurityResponseReceiverServiceConfig resRecExt = null;
        SecurityRequestGeneratorServiceConfig reqGenExt = null;
        SecurityResponseConsumerServiceConfig resConExt = null;
        String actorURI = null;
        if (cdd != null) {
            Resource res = resSet.getResource(cdd, true);
            EList list = res.getContents();
            Object obj = list.get(0);
            if (!(obj instanceof WsClientExtension)) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s03", (String[])new String[]{obj.getClass().getName()}));
            }
            WsClientExtension dd = (WsClientExtension)obj;
            EList elist = dd.getServiceRefs();
            if (elist != null && !elist.isEmpty()) {
                if (elist.size() > 1) {
                    throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s05"));
                }
                com.ibm.etools.webservice.wscext.ServiceRef sr = (com.ibm.etools.webservice.wscext.ServiceRef)elist.get(0);
                if ((elist = sr.getPortQnameBindings()) != null && !elist.isEmpty()) {
                    ClientServiceConfig csConfig;
                    if (elist.size() > 1) {
                        throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s06"));
                    }
                    com.ibm.etools.webservice.wscext.PortQnameBinding pqb = (com.ibm.etools.webservice.wscext.PortQnameBinding)elist.get(0);
                    if (pqb != null && (csConfig = pqb.getClientServiceConfig()) != null) {
                        reqSndExt = csConfig.getSecurityRequestSenderServiceConfig();
                        resRecExt = csConfig.getSecurityResponseReceiverServiceConfig();
                        reqGenExt = csConfig.getSecurityRequestGeneratorServiceConfig();
                        resConExt = csConfig.getSecurityResponseConsumerServiceConfig();
                        actorURI = csConfig.getActorURI();
                    }
                }
            }
        }
        if ((port = ((com.ibm.ws.webservices.engine.MessageContext)ctx).getPort()) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Can't add header bindings based on actor [" + actorURI + "] since there is no port is found.");
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Added header bindings based on actor [" + actorURI + "] since the port is found.");
            }
            port.addActorHeaderBinding(actorURI, (Collection)securityHeaderQNames);
        }
        SecurityRequestSenderBindingConfig reqSndBnd = null;
        SecurityResponseReceiverBindingConfig resRecBnd = null;
        SecurityRequestGeneratorBindingConfig reqGenBnd = null;
        SecurityResponseConsumerBindingConfig resConBnd = null;
        if (cbind != null) {
            Resource res = resSet.getResource(cbind, true);
            EList list = res.getContents();
            Object obj = list.get(0);
            if (!(obj instanceof ClientBinding)) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s04", (String[])new String[]{obj.getClass().getName()}));
            }
            ClientBinding bind = (ClientBinding)obj;
            EList elist = bind.getServiceRefs();
            if (elist != null && elist.size() > 1) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s05"));
            }
            ServiceRef sr = (ServiceRef)elist.get(0);
            if ((elist = sr.getPortQnameBindings()) != null && !elist.isEmpty()) {
                if (elist.size() > 1) {
                    throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s06"));
                }
                PortQnameBinding pqb = (PortQnameBinding)elist.get(0);
                if (pqb != null) {
                    reqSndBnd = pqb.getSecurityRequestSenderBindingConfig();
                    resRecBnd = pqb.getSecurityResponseReceiverBindingConfig();
                    reqGenBnd = pqb.getSecurityRequestGeneratorBindingConfig();
                    resConBnd = pqb.getSecurityResponseConsumerBindingConfig();
                }
            }
        }
        boolean was6 = true;
        if (reqSndExt != null || reqSndBnd != null || resRecExt != null || resRecBnd != null) {
            was6 = false;
        }
        if (reqGenExt != null || reqGenBnd != null || resConExt != null || resConBnd != null) {
            was6 = true;
        }
        try {
            CachedEntry cachedEntry;
            Object obj = null;
            if (was6) {
                if (GlobalSecurityHandler.createRequestGeneratorConfig(reqGenExt, reqGenBnd)) {
                    config = new WSEMFRequestGeneratorConfig(reqGenBnd, reqGenExt, actorURI, null, null);
                }
                if (GlobalSecurityHandler.createResponseConsumerConfig(resConExt, resConBnd)) {
                    obj = new WSEMFResponseConsumerConfig(resConBnd, resConExt, actorURI, null, null);
                    ctx.setProperty("ResponseReceiverConfig", obj);
                }
                cachedEntry = new CachedEntry(config, obj, null, null, was6);
                if (_disCache._cache != null) {
                    if (_disCache._cache.putConfigObject(cdd, cachedEntry) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putConfigObject success");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "putConfigObject returns null");
                    }
                }
            } else {
                if (GlobalSecurityHandler.createRequestSenderConfig(reqSndExt, reqSndBnd)) {
                    config = new WSEMFRequestSenderConfig(reqSndBnd, reqSndExt, actorURI, null, null);
                }
                if (GlobalSecurityHandler.createResponseReceiverConfig(resRecExt, resRecBnd)) {
                    obj = new WSEMFResponseReceiverConfig(resRecBnd, resRecExt, actorURI, null, null);
                    ctx.setProperty("ResponseReceiverConfig", obj);
                }
                cachedEntry = new CachedEntry(null, null, config, obj, was6);
                if (_disCache._cache != null) {
                    if (_disCache._cache.putConfigObject(cdd, cachedEntry) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "putConfigObject success");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "putConfigObject returns null");
                    }
                }
            }
        }
        catch (SoapSecurityException e) {
            FFDCFilter.processException((Throwable)e, clsName + ".loadConfig", "1259", (Object)this);
            Tr.error(tc, "security.wssecurity.GlobalSecurityHandler.s09", e);
            throw new JAXRPCException(e);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadConfig(URI, URI, MesageContext)");
        }
        return config;
    }

    private static boolean createRequestGeneratorConfig(SecurityRequestGeneratorServiceConfig ext, SecurityRequestGeneratorBindingConfig bnd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestGeneratorConfig", new Object[]{ext, bnd});
        }
        boolean result = false;
        if (ext != null) {
            EList securityTokens;
            EList confidentialities;
            boolean[] tmp = new boolean[4];
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            EList integrities = ext.getIntegrity();
            if (integrities != null) {
                for (int i = 0; i < integrities.size(); ++i) {
                    Integrity integrity = (Integrity)integrities.get(i);
                    EList parts = integrity.getMessageParts();
                    boolean bl = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getTimestamp();
                    boolean bl2 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getNonce();
                    boolean bl3 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + tmp[0]);
            }
            if ((confidentialities = ext.getConfidentiality()) != null) {
                for (int i = 0; i < confidentialities.size(); ++i) {
                    Confidentiality confidentiality = (Confidentiality)confidentialities.get(i);
                    EList parts = confidentiality.getMessageParts();
                    boolean bl = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getTimestamp();
                    boolean bl4 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getNonce();
                    boolean bl5 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = (securityTokens = ext.getSecurityToken()) != null && !securityTokens.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityToken constraint defined: " + tmp[2]);
            }
            boolean bl6 = tmp[3] = ext.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + tmp[2]);
            }
            if ((tmp[0] || tmp[1] || tmp[2]) && bnd == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3];
        } else if (bnd != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestGeneratorConfig returns " + result);
        }
        return result;
    }

    private static boolean createResponseConsumerConfig(SecurityResponseConsumerServiceConfig ext, SecurityResponseConsumerBindingConfig bnd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseConsumerConfig", new Object[]{ext, bnd});
        }
        boolean result = false;
        if (ext != null) {
            EList securityTokens;
            EList confidentialities;
            boolean[] tmp = new boolean[4];
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            EList integrities = ext.getRequiredIntegrity();
            if (integrities != null) {
                for (int i = 0; i < integrities.size(); ++i) {
                    RequiredIntegrity integrity = (RequiredIntegrity)integrities.get(i);
                    EList parts = integrity.getMessageParts();
                    boolean bl = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getTimestamp();
                    boolean bl2 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                    parts = integrity.getNonce();
                    boolean bl3 = tmp[0] = parts != null && !parts.isEmpty();
                    if (tmp[0]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + tmp[0]);
            }
            if ((confidentialities = ext.getRequiredConfidentiality()) != null) {
                for (int i = 0; i < confidentialities.size(); ++i) {
                    RequiredConfidentiality confidentiality = (RequiredConfidentiality)confidentialities.get(i);
                    EList parts = confidentiality.getMessageParts();
                    boolean bl = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getTimestamp();
                    boolean bl4 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                    parts = confidentiality.getNonce();
                    boolean bl5 = tmp[1] = parts != null && !parts.isEmpty();
                    if (tmp[1]) break;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = (securityTokens = ext.getRequiredSecurityToken()) != null && !securityTokens.isEmpty();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredSecurityToken constraint defined: " + tmp[2]);
            }
            boolean bl6 = tmp[3] = ext.getAddTimestamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddTimestamp constraint defined: " + tmp[3]);
            }
            if ((tmp[0] || tmp[1] || tmp[2]) && bnd == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3];
        } else if (bnd != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseConsumerConfig returns " + result);
        }
        return result;
    }

    private static boolean createRequestSenderConfig(SecurityRequestSenderServiceConfig ext, SecurityRequestSenderBindingConfig bnd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createRequestSenderConfig", new Object[]{ext, bnd});
        }
        boolean result = false;
        if (ext != null) {
            LoginConfig loginConfig;
            Confidentiality confidentiality;
            boolean[] tmp = new boolean[5];
            tmp[4] = false;
            tmp[3] = false;
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            Integrity integrity = ext.getIntegrity();
            if (integrity != null) {
                EList refs = integrity.getReferences();
                boolean bl = tmp[0] = refs != null && !refs.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Integrity constraint defined: " + tmp[0]);
            }
            if ((confidentiality = ext.getConfidentiality()) != null) {
                EList parts = confidentiality.getConfidentialParts();
                boolean bl = tmp[1] = parts != null && !parts.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Confidentiality constraint defined: " + tmp[1]);
            }
            if ((loginConfig = ext.getLoginConfig()) != null) {
                String authMethod = loginConfig.getAuthMethod();
                boolean bl = tmp[2] = authMethod != null && authMethod.length() != 0;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "LoginConfig constraint defined: " + tmp[2]);
            }
            boolean bl = tmp[3] = ext.getAddCreatedTimeStamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddCreatedTimeStamp constraint defined: " + tmp[3]);
            }
            boolean bl2 = tmp[4] = ext.getIdAssertion() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IdAssertion constraint defined: " + tmp[4]);
            }
            if ((tmp[0] || tmp[1] || tmp[2]) && bnd == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            result = tmp[0] || tmp[1] || tmp[2] || tmp[3] || tmp[4];
        } else if (bnd != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createRequestSenderConfig returns " + result);
        }
        return result;
    }

    private static boolean createResponseReceiverConfig(SecurityResponseReceiverServiceConfig ext, SecurityResponseReceiverBindingConfig bnd) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createResponseReceiverConfig", new Object[]{ext, bnd});
        }
        boolean result = false;
        if (ext != null) {
            RequiredConfidentiality confidentiality;
            boolean[] tmp = new boolean[3];
            tmp[2] = false;
            tmp[1] = false;
            tmp[0] = false;
            RequiredIntegrity integrity = ext.getRequiredIntegrity();
            if (integrity != null) {
                EList refs = integrity.getReferences();
                boolean bl = tmp[0] = refs != null && !refs.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredIntegrity constraint defined: " + tmp[0]);
            }
            if ((confidentiality = ext.getRequiredConfidentiality()) != null) {
                EList parts = confidentiality.getConfidentialParts();
                boolean bl = tmp[1] = parts != null && !parts.isEmpty();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RequiredConfidentiality constraint defined: " + tmp[1]);
            }
            boolean bl = tmp[2] = ext.getAddReceivedTimeStamp() != null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AddReceivedTimeStamp constraint defined: " + tmp[2]);
            }
            if ((tmp[0] || tmp[1]) && bnd == null) {
                throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s07"));
            }
            result = tmp[0] || tmp[1] || tmp[2];
        } else if (bnd != null) {
            throw new JAXRPCException(ConfigUtil.getMessage((String)"security.wssecurity.GlobalSecurityHandler.s08"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createResponseReceiverConfig returns " + result);
        }
        return result;
    }

    private boolean shouldProcessSecurityHeader(boolean configSetting) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shouldProcessSecurityHeader");
        }
        boolean processHeader = true;
        if (configSetting) {
            if (!ContextManagerFactory.getInstance().isServerSecurityEnabled()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Server security is disabled and com.ibm.wsspi.wssecurity.config.disableWSSIfApplicationSecurityDisabled is true.  The security header will not be processed.");
                }
                processHeader = false;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Server security is enabled.  The security header will be processed.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shouldProcessSecurityHeader");
        }
        return processHeader;
    }

    static {
        securityHeaderQNames.add((Object)QNameTable.createQName("http://schemas.xmlsoap.org/ws/2002/04/secext", "Security"));
        securityHeaderQNames.add((Object)QNameTable.createQName("http://schemas.xmlsoap.org/ws/2002/07/secext", "Security"));
        securityHeaderQNames.add((Object)QNameTable.createQName("http://schemas.xmlsoap.org/ws/2003/06/secext", "Security"));
        securityHeaderQNames.add((Object)QNameTable.createQName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
    }

    private static class _disCache {
        static DistributedConfigCache _cache = null;

        private _disCache() {
        }

        static {
            try {
                DistributedConfigCacheFactory.init();
                _cache = DistributedConfigCacheFactory.getInstance();
            }
            catch (Exception ex) {
                FFDCFilter.processException(ex, clsName + "init", "1465");
            }
        }
    }

    private class CachedEntry {
        private WSEMFRequestGeneratorConfig gConfig = null;
        private WSEMFResponseConsumerConfig cConfig = null;
        private WSEMFRequestSenderConfig sConfig = null;
        private WSEMFResponseReceiverConfig rConfig = null;
        private boolean isWAS6 = false;

        public CachedEntry(Object genConfig, Object conConfig, Object senConfig, Object recConfig, boolean was6) {
            this.isWAS6 = was6;
            if (this.isWAS6) {
                this.gConfig = (WSEMFRequestGeneratorConfig)genConfig;
                this.cConfig = (WSEMFResponseConsumerConfig)conConfig;
            } else {
                this.sConfig = (WSEMFRequestSenderConfig)((Object)senConfig);
                this.rConfig = (WSEMFResponseReceiverConfig)((Object)recConfig);
            }
        }

        public boolean isWas6() {
            return this.isWAS6;
        }

        public WSEMFRequestGeneratorConfig getGeneratorConfig() {
            return this.gConfig;
        }

        public WSEMFResponseConsumerConfig getConsumerConfig() {
            return this.cConfig;
        }

        public WSEMFRequestSenderConfig getSenderConfig() {
            return this.sConfig;
        }

        public WSEMFResponseReceiverConfig getReceiverConfig() {
            return this.rConfig;
        }
    }
}

