/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.deploy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.webservice.wsbnd.PCBinding;
import com.ibm.etools.webservice.wsbnd.SecurityRequestConsumerBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityRequestReceiverBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseGeneratorBindingConfig;
import com.ibm.etools.webservice.wsbnd.SecurityResponseSenderBindingConfig;
import com.ibm.etools.webservice.wsbnd.WSBinding;
import com.ibm.etools.webservice.wsbnd.WSDescBinding;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscbnd.ComponentScopedRefs;
import com.ibm.etools.webservice.wscbnd.PortQnameBinding;
import com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityRequestSenderBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseConsumerBindingConfig;
import com.ibm.etools.webservice.wscbnd.SecurityResponseReceiverBindingConfig;
import com.ibm.etools.webservice.wscbnd.ServiceRef;
import com.ibm.etools.webservice.wscommonbnd.DataEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.DigestMethod;
import com.ibm.etools.webservice.wscommonbnd.EncryptionInfo;
import com.ibm.etools.webservice.wscommonbnd.KeyEncryptionMethod;
import com.ibm.etools.webservice.wscommonbnd.PartReference;
import com.ibm.etools.webservice.wscommonbnd.SignatureMethod;
import com.ibm.etools.webservice.wscommonbnd.SigningInfo;
import com.ibm.websphere.management.application.InstallScheduler;
import com.ibm.websphere.management.application.task.AbstractTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.deploy.DeployUtils;
import com.ibm.ws.webservices.wssecurity.util.ConfigValidation;
import com.ibm.ws.webservices.wssecurity.util.WebServicesSecurityAlgorithmHelper;
import com.ibm.wsspi.webservices.models.WSModels;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;

public class WSSFipsValidationServerTask
extends AbstractTask {
    private static final String comp = "security.wssecurity";
    private static final String clsName = WSSFipsValidationServerTask.class.getName();
    private static final TraceComponent tc = Tr.register(WSSFipsValidationServerTask.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String _taskName = "WSSFipsValidationServerTask";
    protected String _appName = null;
    protected String _moduleName = null;
    protected String _portName = null;
    protected boolean _fipsMode = false;
    protected boolean _algorithmsInitialized = false;
    protected Set _fipsSignatureMethods = new HashSet();
    protected Set _fipsDigestMethods = new HashSet();
    protected Set _fipsEncryptionMethods = new HashSet();
    protected Set _fipsKeyEncryptionMethods = new HashSet();

    public WSSFipsValidationServerTask() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSSFipsValidationServerTask()");
        }
        this.appTaskName = _taskName;
        this.bundle = ResourceBundle.getBundle("com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
        this._fipsMode = ConfigValidation.isFipsEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "FIPS mode is " + this._fipsMode);
        }
        if (this._fipsMode) {
            try {
                WebServicesSecurityAlgorithmHelper algoHelper = new WebServicesSecurityAlgorithmHelper();
                this._fipsSignatureMethods = algoHelper.getFipsSignatureAlgorithms();
                this._fipsDigestMethods = algoHelper.getFipsDigestAlgorithms();
                this._fipsEncryptionMethods = algoHelper.getFipsDataEncryptionAlgorithms();
                this._fipsKeyEncryptionMethods = algoHelper.getFipsKeyEncryptionAlgorithms();
                this._fipsSignatureMethods.addAll(algoHelper.get5xFipsSignatureAlgorithms());
                this._fipsDigestMethods.addAll(algoHelper.get5xFipsDigestAlgorithms());
                this._fipsEncryptionMethods.addAll(algoHelper.get5xFipsDataEncryptionAlgorithms());
                this._fipsKeyEncryptionMethods.addAll(algoHelper.get5xFipsKeyEncryptionAlgorithms());
                this._algorithmsInitialized = true;
            }
            catch (SoapSecurityException e) {
                FFDCFilter.processException((Throwable)e, clsName + ".WSSFipsValidationServerTask", "130", this);
                Tr.error(tc, "security.wssecurity.WSEC0150E", new Object[]{e});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSSFipsValidationServerTask()");
        }
    }

    public boolean performTask() throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "performTask()");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "FIPS mode is " + this._fipsMode);
            Tr.debug(tc, "Algorithms initialized: " + this._algorithmsInitialized);
        }
        if (!this._fipsMode || !this._algorithmsInitialized) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask()");
            }
            return true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "task name is WSSFipsValidationServerTask");
        }
        InstallScheduler scheduler = (InstallScheduler)this.scheduler;
        this._appName = scheduler.getAppName();
        EARFile ear = scheduler.getEarFile(false, true);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "_appName is " + this._appName + ", ear file is " + ear);
        }
        boolean wsSecEnabled = DeployUtils.isWebServicesSecurityEnabled(ear);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "WebServicesSecurityEnabled: " + wsSecEnabled);
        }
        if (!wsSecEnabled) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "performTask()");
            }
            return true;
        }
        this.validateFipsAlgos(ear);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "performTask()");
        }
        return true;
    }

    private void validateFipsAlgos(EARFile ear) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFipsAlgos(EARFile ear[" + ear + "])");
        }
        List moduleFiles = ear.getModuleFiles();
        LoadStrategy loadStrategy = null;
        for (ModuleFile mf : moduleFiles) {
            if (mf == null) continue;
            loadStrategy = mf.getLoadStrategy();
            String wsbFilename = mf.isWARFile() ? "WEB-INF/ibm-webservices-bnd.xmi" : "META-INF/ibm-webservices-bnd.xmi";
            String wscbFilename = mf.isWARFile() ? "WEB-INF/ibm-webservicesclient-bnd.xmi" : "META-INF/ibm-webservicesclient-bnd.xmi";
            WSBinding wsb = WSSFipsValidationServerTask.loadWebServicesBindingXML(loadStrategy, wsbFilename);
            ClientBinding wscb = WSSFipsValidationServerTask.loadWebServicesClientBindingXML(loadStrategy, wscbFilename);
            this._moduleName = mf.getName();
            if (this._moduleName == null) {
                this._moduleName = "<null>";
            }
            if (wsb != null) {
                this.validateFipsAlgosInWSBinding(wsb);
            }
            if (wscb == null) continue;
            this.validateFipsAlgosInClientBinding(wscb);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFipsAlgos(EARFile ear)");
        }
    }

    private void validateFipsAlgosInWSBinding(WSBinding wsb) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFipsAlgosInWSBinding(WSBinding wsb[" + wsb + "])");
        }
        boolean valid = true;
        EList wsdecbnds = wsb.getWsdescBindings();
        if (wsdecbnds != null && !wsdecbnds.isEmpty()) {
            int size = wsdecbnds.size();
            for (int i = 0; i < size; ++i) {
                WSDescBinding w = (WSDescBinding)wsdecbnds.get(i);
                EList pcbs = w.getPcBindings();
                if (pcbs == null || pcbs.isEmpty()) continue;
                int pcBndNum = pcbs.size();
                for (int j = 0; j < pcBndNum; ++j) {
                    EList eis;
                    SecurityResponseGeneratorBindingConfig srgbnd;
                    SecurityRequestConsumerBindingConfig srcbnd;
                    SecurityResponseSenderBindingConfig srsbnd;
                    SecurityRequestReceiverBindingConfig srrbnd;
                    PCBinding pc = (PCBinding)pcbs.get(j);
                    this._portName = pc.getPcNameLink();
                    if (this._portName == null) {
                        this._portName = "<null>";
                    }
                    if ((srrbnd = pc.getSecurityRequestReceiverBindingConfig()) != null) {
                        EList eis2;
                        EList sis = srrbnd.getSigningInfos();
                        if (sis != null && !sis.isEmpty()) {
                            valid = this.validateSigningInfos(sis);
                        }
                        if ((eis2 = srrbnd.getEncryptionInfos()) != null && !eis2.isEmpty()) {
                            valid = this.validateEncryptionInfos(eis2);
                        }
                    }
                    if ((srsbnd = pc.getSecurityResponseSenderBindingConfig()) != null) {
                        EncryptionInfo ei;
                        SigningInfo si = srsbnd.getSigningInfo();
                        if (si != null) {
                            valid = this.validateSigningInfo(si);
                        }
                        if ((ei = srsbnd.getEncryptionInfo()) != null) {
                            valid = this.validateEncryptionInfo(ei);
                        }
                    }
                    if ((srcbnd = pc.getSecurityRequestConsumerBindingConfig()) != null) {
                        EList eis3;
                        EList sis = srcbnd.getSigningInfo();
                        if (sis != null && !sis.isEmpty()) {
                            valid = this.validateSigningInfos(sis);
                        }
                        if ((eis3 = srcbnd.getEncryptionInfo()) != null && !eis3.isEmpty()) {
                            valid = this.validateEncryptionInfos(eis3);
                        }
                    }
                    if ((srgbnd = pc.getSecurityResponseGeneratorBindingConfig()) == null) continue;
                    EList sis = srgbnd.getSigningInfo();
                    if (sis != null && !sis.isEmpty()) {
                        valid = this.validateSigningInfos(sis);
                    }
                    if ((eis = srgbnd.getEncryptionInfo()) == null || eis.isEmpty()) continue;
                    valid = this.validateEncryptionInfos(eis);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateFipsAlgosInWSBinding: valid = " + valid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFipsAlgosInWSBinding(WSBinding wsb)");
        }
    }

    private void validateFipsAlgosInClientBinding(ClientBinding wscb) {
        EList csrefs;
        EList srefs;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateFipsAlgosInClientBinding(ClientBinding wscb[" + wscb + "])");
        }
        if ((srefs = wscb.getServiceRefs()) != null && !srefs.isEmpty()) {
            this.validateServiceRefs(srefs);
        }
        if ((csrefs = wscb.getComponentScopedRefs()) != null && !csrefs.isEmpty()) {
            int size = csrefs.size();
            for (int i = 0; i < size; ++i) {
                EList srefs2;
                ComponentScopedRefs csref = (ComponentScopedRefs)csrefs.get(i);
                if (csref == null || (srefs2 = csref.getServiceRefs()) == null || srefs2.isEmpty()) continue;
                this.validateServiceRefs(srefs2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateFipsAlgosInClientBinding(ClientBinding wscb)");
        }
    }

    private void validateServiceRefs(EList srefs) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateServiceRefs(EList srefs[" + srefs + "])");
        }
        boolean valid = true;
        if (srefs != null && !srefs.isEmpty()) {
            int size = srefs.size();
            for (int i = 0; i < size; ++i) {
                EList blist;
                ServiceRef cbsr = (ServiceRef)srefs.get(i);
                if (cbsr == null || (blist = cbsr.getPortQnameBindings()) == null || blist.isEmpty()) continue;
                int pqnbcount = cbsr.getPortQnameBindings().size();
                for (int j = 0; j < pqnbcount; ++j) {
                    EList eis;
                    SecurityResponseConsumerBindingConfig resConBnd;
                    SecurityRequestGeneratorBindingConfig reqGenBnd;
                    SecurityResponseReceiverBindingConfig resRecBnd;
                    SecurityRequestSenderBindingConfig reqSndBnd;
                    PortQnameBinding pqnb = (PortQnameBinding)cbsr.getPortQnameBindings().get(j);
                    if (pqnb == null) continue;
                    this._portName = pqnb.getPortQnameLocalNameLink();
                    if (this._portName == null) {
                        this._portName = "<null>";
                    }
                    if ((reqSndBnd = pqnb.getSecurityRequestSenderBindingConfig()) != null) {
                        EncryptionInfo ei;
                        SigningInfo si = reqSndBnd.getSigningInfo();
                        if (si != null) {
                            valid = this.validateSigningInfo(si);
                        }
                        if ((ei = reqSndBnd.getEncryptionInfo()) != null) {
                            valid = this.validateEncryptionInfo(ei);
                        }
                    }
                    if ((resRecBnd = pqnb.getSecurityResponseReceiverBindingConfig()) != null) {
                        EList eis2;
                        EList sis = resRecBnd.getSigningInfos();
                        if (sis != null && !sis.isEmpty()) {
                            valid = this.validateSigningInfos(sis);
                        }
                        if ((eis2 = resRecBnd.getEncryptionInfos()) != null && !eis2.isEmpty()) {
                            valid = this.validateEncryptionInfos(eis2);
                        }
                    }
                    if ((reqGenBnd = pqnb.getSecurityRequestGeneratorBindingConfig()) != null) {
                        EList eis3;
                        EList sis = reqGenBnd.getSigningInfo();
                        if (sis != null && !sis.isEmpty()) {
                            valid = this.validateSigningInfos(sis);
                        }
                        if ((eis3 = reqGenBnd.getEncryptionInfo()) != null && !eis3.isEmpty()) {
                            valid = this.validateEncryptionInfos(eis3);
                        }
                    }
                    if ((resConBnd = pqnb.getSecurityResponseConsumerBindingConfig()) == null) continue;
                    EList sis = resConBnd.getSigningInfo();
                    if (sis != null && !sis.isEmpty()) {
                        valid = this.validateSigningInfos(sis);
                    }
                    if ((eis = resConBnd.getEncryptionInfo()) == null || eis.isEmpty()) continue;
                    valid = this.validateEncryptionInfos(eis);
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validateServicesRefs: valid = " + valid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateServiceRefs(EList srefs)");
        }
    }

    private boolean validateSigningInfos(EList sis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSigningInfos(EList sis[" + sis + "])");
        }
        boolean valid = true;
        int sisNum = sis.size();
        for (int i = 0; i < sisNum; ++i) {
            SigningInfo si = (SigningInfo)sis.get(i);
            if (si == null) continue;
            valid = this.validateSigningInfo(si);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateSigningInfos(EList sis) returns " + valid);
        }
        return valid;
    }

    private boolean validateSigningInfo(SigningInfo si) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateSigningInfo(SigningInfo si[" + si + "])");
        }
        boolean valid = true;
        if (si != null) {
            EList prefs;
            SignatureMethod signatureMethod = si.getSignatureMethod();
            if (signatureMethod != null) {
                String signatureAlgorithm = signatureMethod.getAlgorithm();
                if (!this._fipsSignatureMethods.contains(signatureAlgorithm)) {
                    this.invalidAlgorithmNotification(signatureAlgorithm, "SignatureMethod");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid signature algorithm URI:" + signatureAlgorithm);
                }
            }
            if ((prefs = si.getPartReference()) != null) {
                int prefNum = prefs.size();
                for (int j = 0; j < prefNum; ++j) {
                    DigestMethod digest;
                    PartReference pref = (PartReference)prefs.get(j);
                    if (pref == null || (digest = pref.getDigestMethod()) == null) continue;
                    String digestAlgorithm = digest.getAlgorithm();
                    if (!this._fipsDigestMethods.contains(digestAlgorithm)) {
                        this.invalidAlgorithmNotification(digestAlgorithm, "DigestMethod");
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Valid digest algorithm URI:" + digestAlgorithm);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateSigningInfo(SigningInfo si) returns " + valid);
        }
        return valid;
    }

    private boolean validateEncryptionInfos(EList eis) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateEncryptionInfos(EList eis[" + eis + "])");
        }
        boolean valid = true;
        int eisNum = eis.size();
        for (int i = 0; i < eisNum; ++i) {
            EncryptionInfo ei = (EncryptionInfo)eis.get(i);
            if (ei == null) continue;
            valid = this.validateEncryptionInfo(ei);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateEncryptionInfos(EList eis) returns " + valid);
        }
        return valid;
    }

    private boolean validateEncryptionInfo(EncryptionInfo ei) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateEncryptionInfo(EncryptionInfo ei[" + ei + "])");
        }
        boolean valid = true;
        if (ei != null) {
            KeyEncryptionMethod keyEncryptionMethod;
            DataEncryptionMethod dataEncryptionMethod = ei.getEncryptionMethod();
            if (dataEncryptionMethod != null) {
                String dataEncryptionAlgorithm = dataEncryptionMethod.getAlgorithm();
                if (!this._fipsEncryptionMethods.contains(dataEncryptionAlgorithm)) {
                    this.invalidAlgorithmNotification(dataEncryptionAlgorithm, "DataEncryptionMethod");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid data encryption algorithm URI:" + dataEncryptionAlgorithm);
                }
            }
            if ((keyEncryptionMethod = ei.getKeyEncryptionMethod()) != null) {
                String keyEncryptionAlgorithm = keyEncryptionMethod.getAlgorithm();
                if (!this._fipsKeyEncryptionMethods.contains(keyEncryptionAlgorithm)) {
                    this.invalidAlgorithmNotification(keyEncryptionAlgorithm, "KeyEncryptionMethod");
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Valid key encryption algorithm URI:" + keyEncryptionAlgorithm);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateEncryptionInfo(EncryptionInfo ei) returns " + valid);
        }
        return valid;
    }

    private void invalidAlgorithmNotification(String uri, String description) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invalidAlgorithmNotification(String uri[" + uri + "], String description[" + description + "])");
        }
        InstallScheduler scheduler = (InstallScheduler)this.scheduler;
        Tr.warning(tc, "security.wssecurity.WSEC0149W", new Object[]{this._appName, this._moduleName, this._portName, description, uri});
        scheduler.propagateTaskEvent(this.createNotification("Completed", "security.wssecurity.WSEC0149W", new String[]{this._appName, this._moduleName, this._portName, description, uri}));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invalidAlgorithmNotification()");
        }
    }

    private static WSBinding loadWebServicesBindingXML(LoadStrategy loadStrategy, String xmlFilename) {
        if (loadStrategy.getContainer().containsFile(xmlFilename)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing IBM web services XML binding file:" + xmlFilename);
            }
            try {
                return WSModels.getWSBinding(loadStrategy, xmlFilename);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static ClientBinding loadWebServicesClientBindingXML(LoadStrategy loadStrategy, String xmlFilename) {
        if (loadStrategy.getContainer().containsFile(xmlFilename)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing IBM web services client XML binding file:" + xmlFilename);
            }
            try {
                return WSModels.getWSClientBinding(loadStrategy, xmlFilename);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

