/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.ws.webservices.wssecurity.config.CollectionCertStore;
import com.ibm.ws.webservices.wssecurity.config.LDAPCertStore;
import com.ibm.ws.webservices.wssecurity.config.WSSConsumerConfig;
import com.ibm.ws.webservices.wssecurity.config.WSSGeneratorConfig;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyLocatorProxy;
import com.ibm.wsspi.wssecurity.id.TrustedIDEvaluator;
import com.ibm.xml.soapsec.token.LoginMapping;
import java.security.KeyStore;
import java.security.cert.CertStore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WSSecurityDefaultConfiguration {
    private static final TraceComponent tc = Tr.register(WSSecurityDefaultConfiguration.class, "Web Services Security", "com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String clsName = com.ibm.etools.webservice.wscommonbnd.KeyStore.class.getName();
    private static final String comp = "security.wssecurity";
    private static final WebSphereRuntimePermission GETLOGINMAPPINGPERM = new WebSphereRuntimePermission("wssecurity.getLoginMapping");
    private static final WebSphereRuntimePermission GETTRUSTANCHORPERM = new WebSphereRuntimePermission("wssecurity.getTrustAnchor");
    private static final WebSphereRuntimePermission GETTRUSTEDIDEVALUATORPERM = new WebSphereRuntimePermission("wssecurity.getTrustedIDEvaluator");
    private static final WebSphereRuntimePermission GETKEYLOCATORPERM = new WebSphereRuntimePermission("wssecurity.getKeyLocator");
    private static final WebSphereRuntimePermission GETCERTSTOREPERM = new WebSphereRuntimePermission("wssecurity.getCertStore");
    private static final WebSphereRuntimePermission WSSECURITYCONFIGPERM = new WebSphereRuntimePermission("wssecurity.wssecurity.config");
    private static final WebSphereRuntimePermission GETAMAPPERM = new WebSphereRuntimePermission("wssecurity.getAlgorithmMappings");
    private static final WebSphereRuntimePermission GETNCDISTAPPERM = new WebSphereRuntimePermission("wssecurity.isNonceCacheDistributed");
    private static final WebSphereRuntimePermission GETDEFCONPERM = new WebSphereRuntimePermission("wssecurity.getDefaultConsumerBinding");
    private static final WebSphereRuntimePermission GETDEFGENPERM = new WebSphereRuntimePermission("wssecurity.getDefaultGeneratorBinding");
    protected Map loginMappings = new HashMap();
    protected Map trustAnchors = new HashMap();
    protected Map trustedIDEvaluators = new HashMap();
    protected Map keyLocators = new HashMap();
    protected Map certStores = new HashMap();
    protected Map certs = new HashMap();
    protected Map crls = new HashMap();
    protected Map keyStores = new HashMap();
    protected Map properties = new HashMap();
    protected Set algorithmMappings = new HashSet();
    protected boolean useNonceCache = true;
    protected String nonceCacheName = "NonceDistributionCacheMap";
    protected int nonceCacheSize = 1024;
    protected int nonceCacheTimeout = 600;
    protected int nonceLength = 128;
    protected int nonceMaxAge = 300;
    protected int nonceClockSkew = 0;
    protected boolean nonceCacheDistributed = false;
    protected boolean decoupleToken;
    protected boolean useCertCache = true;
    protected String certCacheName = "WSSCertCache";
    protected int certCacheSize = 128;
    protected int certCacheTimeOut = 900;
    protected boolean useConfigCache = true;
    protected String configCacheName = "WSSReqGeneratorConfigMap";
    protected int configCacheSize = 128;
    protected int configCacheTimeToLive = 900;
    protected boolean useHardwareAcceleration = false;
    protected String hardwareConfigName = null;
    protected String useOffloadAllCrypto = "false";
    protected boolean offloadRSAPublicKeyCrypto = true;
    protected int hardwareCacheSize = 1000;
    protected String hardwareKeyStoreName = null;
    protected boolean useTokenCache = true;
    protected String tokenCacheName = "WSSTokenCache";
    protected int tokenCacheSize = 128;
    protected int tokenCacheTimeOut = 900;
    protected long tokenCacheCushion = 600000L;
    protected WSSGeneratorConfig gconfig;
    protected WSSConsumerConfig cconfig;

    protected WSSecurityDefaultConfiguration() {
    }

    public LoginMapping getLoginMapping(String authMethod) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLoginMapping", authMethod);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETLOGINMAPPINGPERM);
        }
        LoginMapping retval = (LoginMapping)this.loginMappings.get(authMethod);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLoginMapping", retval);
        }
        return retval;
    }

    public KeyStore getTrustAnchor(String name) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAnchor", name);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETTRUSTANCHORPERM);
        }
        KeyStore retval = null;
        com.ibm.ws.webservices.wssecurity.config.KeyStore ks = (com.ibm.ws.webservices.wssecurity.config.KeyStore)this.trustAnchors.get(name);
        if (ks != null) {
            retval = ks.getInstance();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAnchor", retval);
        }
        return retval;
    }

    public com.ibm.ws.webservices.wssecurity.config.KeyStore getTrustAnchorKeyStoreConfig(String name) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustAnchorKeyStoreConfig", name);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETTRUSTANCHORPERM);
        }
        com.ibm.ws.webservices.wssecurity.config.KeyStore ks = (com.ibm.ws.webservices.wssecurity.config.KeyStore)this.trustAnchors.get(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustAnchorKeyStoreConfig", ks);
        }
        return ks;
    }

    public TrustedIDEvaluator getTrustedIDEvaluator(String name) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTrustedIDEvaluator", name);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETTRUSTEDIDEVALUATORPERM);
        }
        TrustedIDEvaluator ret = (TrustedIDEvaluator)this.trustedIDEvaluators.get(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTrustedIDEvaluator", ret);
        }
        return ret;
    }

    public KeyLocatorProxy getKeyLocator(String name) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getKeyLocator", name);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETKEYLOCATORPERM);
        }
        KeyLocatorProxy ret = (KeyLocatorProxy)this.keyLocators.get(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyLocator", ret);
        }
        return ret;
    }

    public CertStore getCertStore(String name) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertStore", name);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETCERTSTOREPERM);
        }
        CertStore ret = null;
        Object obj = this.certStores.get(name);
        if (obj != null) {
            if (obj instanceof CollectionCertStore) {
                CollectionCertStore ccs = (CollectionCertStore)obj;
                ret = ccs.getInstance();
            } else if (obj instanceof LDAPCertStore) {
                LDAPCertStore lcs = (LDAPCertStore)obj;
                ret = lcs.getInstance();
            } else {
                Tr.error(tc, "security.wssecurity.default.config.bad.certstore.class", new Object[]{name, obj.getClass().getName()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertStore", ret);
        }
        return ret;
    }

    public Object getWSCertStore(String name) {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWSCertStore", name);
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETCERTSTOREPERM);
        }
        Object obj = this.certStores.get(name);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWSCertStore", obj);
        }
        return obj;
    }

    public Set getAlgorithmMappings() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAlgorithmMappings");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAlgorithmMappings", this.algorithmMappings);
        }
        return this.algorithmMappings;
    }

    public boolean getNonceCacheDistributed() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheDistributed");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheDistributed", Boolean.toString(this.nonceCacheDistributed));
        }
        return this.nonceCacheDistributed;
    }

    public int getNonceCacheTimeout() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceCacheTimeout");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceCacheTimeout", new Integer(this.nonceCacheTimeout));
        }
        return this.nonceCacheTimeout;
    }

    public int getNonceMaxAge() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceMaxAge");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceMaxAge", new Integer(this.nonceMaxAge));
        }
        return this.nonceMaxAge;
    }

    public int getNonceClockSkew() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNonceClockSkew");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNonceClockSkew", new Integer(this.nonceClockSkew));
        }
        return this.nonceClockSkew;
    }

    public boolean getDecoupleToken() {
        return this.decoupleToken;
    }

    public WSSConsumerConfig getDefaultConsumerBinding() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultConsumerBinding");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultConsumerBinding", this.cconfig);
        }
        return this.cconfig;
    }

    public WSSGeneratorConfig getDefaultGeneratorBinding() {
        SecurityManager sm;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultGeneratorBinding");
        }
        if ((sm = System.getSecurityManager()) != null) {
            sm.checkPermission(GETAMAPPERM);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultGeneratorBinding", this.gconfig);
        }
        return this.gconfig;
    }

    public Map getProperties() {
        return this.properties;
    }

    public void addProperties(Map newMap) {
        HashMap tempMap = new HashMap();
        tempMap.putAll(newMap);
        tempMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheName");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheSize");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.cacheTimeout");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.length");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.maxAge");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.clockSkew");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.BasicAuth.Nonce.useCache");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.certificate.cacheName");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.certificate.cacheSize");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.certificate.cacheTimeout");
        tempMap.remove("com.ibm.ws.wssecurity.config.token.certificate.useCache");
        tempMap.remove("com.ibm.ws.wssecurity.handler.configCacheName");
        tempMap.remove("com.ibm.ws.wssecurity.handler.configCacheSize");
        tempMap.remove("com.ibm.ws.wssecurity.handler.configCacheTimeToLive");
        tempMap.remove("com.ibm.ws.wssecurity.handler.useConfigCache");
        tempMap.remove("com.ibm.ws.wssecurity.handler.token.useCache");
        tempMap.remove("com.ibm.ws.wssecurity.handler.token.cacheName");
        tempMap.remove("com.ibm.ws.wssecurity.handler.token.cacheSize");
        tempMap.remove("com.ibm.ws.wssecurity.handler.token.cacheTimeout");
        tempMap.remove("com.ibm.ws.wssecurity.handler.token.cushion");
        tempMap.remove("com.ibm.ws.wssecurity.handler.GenConfigCacheKey");
        tempMap.remove("com.ibm.ws.wssecurity.handler.ConConfigCacheKey");
        tempMap.remove("com.ibm.ws.wssecurity.handler.OffloadAllCryptography");
        tempMap.remove("com.ibm.ws.wssecurity.handler.OffloadRSAPublicKeyCryptography");
        tempMap.remove("com.ibm.ws.wssecurity.handler.hardwareCacheSize");
        tempMap.remove("com.ibm.ws.wssecurity.handler.hardwareCacheEntryRefreshHours");
        this.properties.putAll(tempMap);
    }

    public String toString() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(WSSECURITYCONFIGPERM);
        }
        return "Configuration( LoginMappings = " + this.loginMappings + " TrustAnchors = " + this.trustAnchors + " TrustedIDEvaluators = " + this.trustedIDEvaluators + " KeyLocators = " + this.keyLocators + " CertStores = " + this.certStores + " AlgorithmMapping = " + this.algorithmMappings + " NonceCacheName = " + this.nonceCacheName + " NonceCacheSize = " + this.nonceCacheSize + " NonceCacheTimeout = " + this.nonceCacheTimeout + " NonceLength = " + this.nonceLength + " NonceMaxAge = " + this.nonceMaxAge + " NonceClockSkew = " + this.nonceClockSkew + " NonceCacheDistributed = " + this.nonceCacheDistributed + " CertCacheName = " + this.certCacheName + " CertCacheSize = " + this.certCacheSize + " CertCacheTimeout = " + this.certCacheTimeOut + " TokenCacheName = " + this.tokenCacheName + " TokenCacheSize = " + this.tokenCacheSize + " TokenCacheTimeout = " + this.tokenCacheTimeOut + " TokenCacheCushion = " + this.tokenCacheCushion + " DefaultGeneratorBinding = " + this.gconfig + " DefaultConsumerBindig = " + this.cconfig + " Hardware Acceleration = " + this.useHardwareAcceleration + " HardwareConfigName = " + this.hardwareConfigName + " OffloadAllCrypto  = " + this.useOffloadAllCrypto + " HardwareCacheSize  = " + this.hardwareCacheSize + " OffloadRSAPublicKeyCrypto  = " + this.offloadRSAPublicKeyCrypto + " Properties = " + this.properties + ")";
    }

    public boolean getUseHardwareAcceleration() {
        return this.useHardwareAcceleration;
    }

    public String getHardwareConfigName() {
        return this.hardwareConfigName;
    }

    public String getHardwareKeyStoreName() {
        return this.hardwareKeyStoreName;
    }

    public String getUseOffloadAllCrypto() {
        return this.useOffloadAllCrypto;
    }

    public boolean getOffloadRSAPublicKeyCrypto() {
        return this.offloadRSAPublicKeyCrypto;
    }

    public int getHardwareCacheSize() {
        return this.hardwareCacheSize;
    }
}

