/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wssecurity.core;

import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.webservices.wssecurity.WSSComponent;
import com.ibm.ws.webservices.wssecurity.core.WSSFactory;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureConsumer;
import com.ibm.ws.webservices.wssecurity.dsig.SignatureGenerator;
import com.ibm.ws.webservices.wssecurity.enc.EncryptionConsumer;
import com.ibm.ws.webservices.wssecurity.enc.EncryptionGenerator;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoConsumer;
import com.ibm.ws.webservices.wssecurity.keyinfo.KeyInfoGenerator;
import com.ibm.ws.webservices.wssecurity.time.TimestampConsumer;
import com.ibm.ws.webservices.wssecurity.time.TimestampGenerator;
import com.ibm.wsspi.wssecurity.SoapSecurityException;
import com.ibm.xml.soapsec.util.ConfigUtil;
import com.ibm.xml.soapsec.util.Tr;
import com.ibm.xml.soapsec.util.TraceComponent;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;

public class WSSFactorySOAPImpl
extends WSSFactory {
    private static final TraceComponent tc = Tr.register(WSSFactorySOAPImpl.class, (String)"Web Services Security", (String)"com.ibm.ws.webservices.wssecurity.resources.was-wssecurity");
    private static final String comp = "security.wssecurity";

    protected WSSFactorySOAPImpl() {
    }

    public WSSComponent createGenerator(Map type, final Map properties) throws SoapSecurityException {
        ClassLoader appClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createGenerator(Map type,Map properties)");
        }
        Object t = type.get("com.ibm.wsspi.wssecurity.core.wssfactory.type");
        Object cp = type.get("com.ibm.wsspi.wssecurity.core.wssfactory.classname");
        ClassLoader classLoader = appClassLoader = type.containsKey("com.ibm.wsspi.wssecurity.core.wssfactory.classloader") ? (ClassLoader)type.get("com.ibm.wsspi.wssecurity.core.wssfactory.classloader") : null;
        if (tc.isDebugEnabled()) {
            if (appClassLoader != null) {
                Tr.debug((TraceComponent)tc, (String)("type [" + type + "], classname [" + cp + "], classloader [" + appClassLoader.getClass().getName() + "]."));
            } else {
                Tr.debug((TraceComponent)tc, (String)("type [" + type + "], classname [" + cp + "]."));
            }
        }
        WSSComponent component2 = null;
        if (t == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s01");
        }
        if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.timestamp")) {
            component2 = new TimestampGenerator();
        } else if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.signature")) {
            component2 = new SignatureGenerator();
        } else if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.encryption")) {
            component2 = new EncryptionGenerator();
        } else if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.keyinfo")) {
            component2 = new KeyInfoGenerator();
        } else if (!t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.custom")) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s02", t.toString());
        }
        if (component2 == null) {
            if (cp == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
            }
            final String classname = cp.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Instantiating the component [" + classname + "]..."));
            }
            try {
                component2 = (WSSComponent)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SoapSecurityException {
                        WSSComponent c = (WSSComponent)ConfigUtil.instantiate((String)classname, WSSComponent.class, (Map)properties, (ClassLoader)appClassLoader);
                        return c;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable th = e.getCause();
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s04", classname, th);
            }
        } else {
            component2.init(properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createGenerator(Map type,Map properties) returns " + component2));
        }
        return component2;
    }

    public WSSComponent createConsumer(Map type, final Map properties) throws SoapSecurityException {
        ClassLoader appClassLoader;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConsumer(Map type,Map properties)");
        }
        Object t = type.get("com.ibm.wsspi.wssecurity.core.wssfactory.type");
        Object cp = type.get("com.ibm.wsspi.wssecurity.core.wssfactory.classname");
        ClassLoader classLoader = appClassLoader = type.containsKey("com.ibm.wsspi.wssecurity.core.wssfactory.classloader") ? (ClassLoader)type.get("com.ibm.wsspi.wssecurity.core.wssfactory.classloader") : null;
        if (tc.isDebugEnabled()) {
            if (appClassLoader != null) {
                Tr.debug((TraceComponent)tc, (String)("type [" + type + "], classname [" + cp + "], classloader [" + appClassLoader.getClass().getName() + "]."));
            } else {
                Tr.debug((TraceComponent)tc, (String)("type [" + type + "], classname [" + cp + "]."));
            }
        }
        WSSComponent component2 = null;
        if (t == null) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s01");
        }
        if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.timestamp")) {
            component2 = new TimestampConsumer();
        } else if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.encryption")) {
            component2 = new EncryptionConsumer();
        } else if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.signature")) {
            component2 = new SignatureConsumer();
        } else if (t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.keyinfo")) {
            component2 = new KeyInfoConsumer();
        } else if (!t.equals("com.ibm.wsspi.wssecurity.core.wssfactory.custom")) {
            throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s02");
        }
        if (component2 == null) {
            if (cp == null) {
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s03");
            }
            final String classname = cp.toString();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Instantiating the component [" + classname + "]..."));
            }
            try {
                component2 = (WSSComponent)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws SoapSecurityException {
                        WSSComponent c = (WSSComponent)ConfigUtil.instantiate((String)classname, WSSComponent.class, (Map)properties, (ClassLoader)appClassLoader);
                        return c;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable th = e.getCause();
                if (th instanceof SoapSecurityException) {
                    throw (SoapSecurityException)th;
                }
                throw SoapSecurityException.format("security.wssecurity.WSSFactorySOAPImpl.s04", classname, th);
            }
        } else {
            component2.init(properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("createConsumer(Map type,Map properties) returns " + component2));
        }
        return component2;
    }
}

