/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.toJava;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Constants;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.URLHashSet;
import com.ibm.ws.webservices.engine.utils.XMLUtils;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import com.ibm.ws.webservices.wsdl.toJava.Emitter;
import com.ibm.ws.webservices.wsdl.toJava.JavaClassWriter;
import com.ibm.ws.webservices.wsdl.toJava.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class AIRWriter
extends JavaClassWriter {
    private Emitter emitter;
    private Definition definition;
    private SymbolTable symbolTable;
    private URLHashSet writtenFiles = new URLHashSet();

    protected AIRWriter(Emitter emitter, Definition definition, SymbolTable symbolTable) {
        super(emitter, AIRWriter.getName(emitter, definition), "importResolver");
        this.emitter = emitter;
        this.definition = definition;
        this.symbolTable = symbolTable;
    }

    private static String getName(Emitter emitter, Definition definition) {
        QName fileQName = QNameTable.createQName(definition.getTargetNamespace(), "_AbsoluteImportResolver");
        return emitter.getJavaName(fileQName);
    }

    protected String getImplementsText() {
        return "implements com.ibm.ws.webservices.wsdl.ImportResolver ";
    }

    protected void writeFileBody(PrintWriter pw) throws IOException {
        this.writeResolutions(pw);
        this.writeResolveMethod(pw);
    }

    private void writeResolutions(PrintWriter pw) throws IOException {
        try {
            pw.println("    private static java.util.Hashtable resolutions = new java.util.Hashtable();");
            String stringURL = this.symbolTable.getWSDLURI();
            URL url = Utils.getURL(null, stringURL);
            pw.println("    static {");
            pw.println("        String content;");
            Document doc = XMLUtils.newDocument(stringURL, null, null, this.emitter.getRetry(), this.emitter.getTimeout());
            this.writeWSDLResolutions(pw, url, this.definition, doc);
            pw.println("    }");
            pw.println();
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.webservices.wsdl.toJava.AIRWriter.writeResolutions", "115", this);
            t.printStackTrace();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException(t.getMessage());
        }
    }

    private void writeXSDResolutions(PrintWriter pw, URL context, Node node) throws IOException, ParserConfigurationException, SAXException {
        if (node != null) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if ("import".equals(child.getLocalName()) || "include".equals(child.getLocalName()) || "redefine".equals(child.getLocalName())) {
                    String location;
                    URL url;
                    NamedNodeMap attributes = child.getAttributes();
                    Node namespace = attributes.getNamedItem("namespace");
                    if (namespace != null && Constants.isSOAP_ENC(namespace.getNodeValue())) continue;
                    Node importFile = attributes.getNamedItem("schemaLocation");
                    if (importFile != null && !this.writtenFiles.contains(url = Utils.getURL(context, location = importFile.getNodeValue()))) {
                        this.writtenFiles.add(url);
                        if (this.isAbsolute(url)) {
                            this.writeFile(pw, url, location);
                        }
                        this.writeXSDResolutions(pw, url, XMLUtils.newDocument(url.toString(), null, null, this.emitter.getRetry(), this.emitter.getTimeout()));
                    }
                }
                this.writeXSDResolutions(pw, context, child);
            }
        }
    }

    private void writeWSDLResolutions(PrintWriter pw, URL context, Definition def, Document doc) throws IOException, ParserConfigurationException, SAXException {
        if (doc != null) {
            this.writeXSDResolutions(pw, context, doc);
        }
        if (def != null) {
            Map imports = def.getImports();
            Object[] importKeys = imports.keySet().toArray();
            for (int i = 0; i < importKeys.length; ++i) {
                Vector v = (Vector)imports.get(importKeys[i]);
                for (int j = 0; j < v.size(); ++j) {
                    Import imp2 = (Import)v.get(j);
                    String location = imp2.getLocationURI();
                    if (this.writtenFiles.contains(location)) continue;
                    this.writtenFiles.add(location);
                    URL url = Utils.getURL(context, location);
                    if (this.isAbsolute(url)) {
                        this.writeFile(pw, url, location);
                    }
                    this.writeWSDLResolutions(pw, url, imp2.getDefinition(), XMLUtils.newDocument(url.toString(), null, null, this.emitter.getRetry(), this.emitter.getTimeout()));
                }
            }
        }
    }

    private boolean isAbsolute(URL url) {
        String path = url.getPath();
        return path == null || path.startsWith("/");
    }

    private void writeFile(PrintWriter pw, URL url, String location) throws IOException {
        pw.print("        content = \"");
        InputStream is = url.openStream();
        int ret = is.read();
        while (ret != -1) {
            char ch = (char)ret;
            if (ch == '\"') {
                pw.print('\\');
                pw.print(ch);
            } else if (ch == '\n') {
                pw.println("\" +");
                pw.print("            \"");
            } else if (ch != '\r') {
                pw.print(ch);
            }
            ret = is.read();
        }
        pw.println("\";");
        pw.println("        resolutions.put(\"" + location + "\", content);");
        pw.println();
    }

    private void writeResolveMethod(PrintWriter pw) throws IOException {
        pw.println("    public java.io.InputStream resolve(java.lang.String location) {");
        pw.println("        java.lang.String contents = (String) resolutions.get(location);");
        pw.println("        java.io.InputStream is = null;");
        pw.println("        if (contents != null) {");
        pw.println("            is = new java.io.ByteArrayInputStream(contents.getBytes());");
        pw.println("        }");
        pw.println("        return is;");
        pw.println("    }");
        pw.println();
    }
}

