/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.tools.resource;

import com.ibm.etools.environment.common.Environment;
import com.ibm.etools.environment.common.ProgressMonitor;
import com.ibm.etools.environment.common.SimpleStatus;
import com.ibm.etools.environment.common.Status;
import com.ibm.etools.environment.console.ConsoleEnvironment;
import com.ibm.etools.environment.resource.ResourceException;
import com.ibm.etools.environment.resource.ResourceManager;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.tools.resource.FileWriteDenialException;
import com.ibm.ws.webservices.tools.resource.ToolEnv;
import com.ibm.ws.webservices.wsdl.toJava.JavaSearchCriteria;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.util.JavaContext;

public class WSADToolEnv
extends ToolEnv {
    private Environment env;
    private ResourceSet javaContext;
    private SimpleStatus status = new SimpleStatus("", "", 0);
    private URL[] classpathURLs;

    public WSADToolEnv() {
        this.javaContext = JavaContext.createJavaContext();
    }

    public void setEnvironment(Environment env) {
        this.env = env;
    }

    public SimpleStatus getStatus() {
        return this.status;
    }

    public void setStatus(SimpleStatus status) {
        this.status = status;
    }

    public boolean fileExists(String urlString) {
        this.checkEnv();
        JavaSearchCriteria javaSearch = this.getJavaSearch();
        if (javaSearch.equals(JavaSearchCriteria.BOTH) || javaSearch.equals(JavaSearchCriteria.FILE)) {
            try {
                URL url = new URL(urlString);
                ResourceManager rm = this.env.getResourceManager();
                if (rm.exists(url)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (javaSearch.equals(JavaSearchCriteria.BOTH) || javaSearch.equals(JavaSearchCriteria.CLASSPATH)) {
            if (this.javaOutputDir != null) {
                urlString = urlString.substring(this.javaOutputDir.length() + 1);
            }
            urlString = urlString.substring(0, urlString.lastIndexOf(46)).replace(this.getSeparatorChar(), '.');
            if (this.getClassFactory().forName(urlString) != null) {
                return true;
            }
        }
        return false;
    }

    public PrintWriter getPrintWriter(String urlString) throws IOException, FileWriteDenialException {
        this.checkEnv();
        OutputStream os2 = this.getOutputStream(urlString);
        OutputStreamWriter writer = new OutputStreamWriter(os2, "UTF-8");
        if (os2 != null) {
            return new PrintWriter(new BufferedWriter(writer));
        }
        throw new FileWriteDenialException(Messages.getMessage("FileWriteDenied", urlString), urlString);
    }

    public OutputStream getOutputStream(String urlString) throws IOException {
        OutputStream os2;
        this.checkEnv();
        try {
            URL url = new URL(urlString);
            ResourceManager rm = this.env.getResourceManager();
            os2 = rm.getOutputStream(url);
        }
        catch (ResourceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.tools.resource.WSADToolEnv.getOutputStream", "125", this);
            return null;
        }
        return os2;
    }

    public InputStream getInputStream(String urlString) throws IOException {
        InputStream is;
        this.checkEnv();
        try {
            URL url = new URL(urlString);
            ResourceManager rm = this.env.getResourceManager();
            is = rm.getInputStream(url);
        }
        catch (ResourceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.tools.resource.WSADToolEnv.getInputStream", "154", this);
            throw new IOException(e.getStatus().getMessage() + (urlString == null ? "" : ": " + urlString));
        }
        return is;
    }

    public void mkdir(String urlString) throws IOException {
        this.checkEnv();
        try {
            URL url = new URL(urlString);
            ResourceManager rm = this.env.getResourceManager();
            rm.createFolders(url);
        }
        catch (ResourceException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.tools.resource.WSADToolEnv.mkdir", "179", this);
            throw new IOException(e.getStatus().getMessage());
        }
    }

    private void checkEnv() {
        if (this.env == null) {
            this.setEnvironment((Environment)new ConsoleEnvironment());
        }
    }

    public char getSeparatorChar() {
        this.checkEnv();
        ResourceManager rm = this.env.getResourceManager();
        return rm.getSeparatorChar();
    }

    public void report(String progress) {
        this.checkEnv();
        ProgressMonitor printMon = this.env.getProgressMonitor();
        printMon.report(progress);
    }

    public void reportWarning(String warning) {
        this.checkEnv();
        ProgressMonitor printMon = this.env.getProgressMonitor();
        printMon.report(warning);
        this.updateStatus(2, warning, null);
    }

    public void reporterr(String error) {
        this.checkEnv();
        ProgressMonitor printMon = this.env.getProgressMonitor();
        printMon.report(error);
        this.updateStatus(4, error, null);
    }

    public void reportException(Throwable t) {
        this.checkEnv();
        String error = "Error: " + t.getMessage();
        ProgressMonitor printMon = this.env.getProgressMonitor();
        printMon.report(error);
        this.updateStatus(4, error, t);
    }

    public void updateStatus(int severity, String message, Throwable t) {
        if (severity > this.status.getSeverity()) {
            String topMessage = "Error messages were issued.";
            if (severity == 2) {
                topMessage = "Warning messages were issued.";
            }
            this.status = new SimpleStatus(this.status.getId(), topMessage, this.status.getChildren());
        }
        SimpleStatus childStatus = new SimpleStatus("", message, severity, t);
        this.status.addChild((Status)childStatus);
    }

    public boolean isJavaIntrospectionAllowed() {
        return this.isJavaIntrospectionAllowed;
    }

    public void setJavaContext(ResourceSet context) {
        this.javaContext = context;
    }

    public ResourceSet getJavaContext() {
        return this.javaContext;
    }

    public void setClasspathURLs(URL[] urls) {
        this.classpathURLs = urls;
    }

    public List getCustomBindingProviders(Object classpath) {
        return this.getCustomBindingProviders();
    }

    public List getCustomBindingProviders() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (this.classpathURLs != null && this.classpathURLs.length > 0) {
            loader = new URLClassLoader(this.classpathURLs, loader);
        }
        return this.loadCustomProviders(loader);
    }
}

