/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.multiprotocol.provider.ejb;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.multiprotocol.InvocationContext;
import com.ibm.ws.webservices.multiprotocol.ServiceContext;
import com.ibm.ws.webservices.multiprotocol.extensions.agnostic.AgnosticAddress;
import com.ibm.ws.webservices.multiprotocol.provider.ejb.stubless.EJBDII;
import com.ibm.ws.webservices.multiprotocol.provider.ejb.stubless.impl.EJBObjectFactory;
import com.ibm.ws.webservices.multiprotocol.provider.java.JavaTransport;
import com.ibm.ws.webservices.multiprotocol.resources.Messages;
import java.rmi.RemoteException;
import java.util.Map;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class EJBTransport
extends JavaTransport {
    private static final TraceComponent _tc = Tr.register(EJBTransport.class, "WebServices", "com.ibm.ws.webservices.multiprotocol.resources.mpMessages");
    public static final String PROTOCOL = "wsejb";
    public static final String ADDRESS_JNDI_NAME = "jndiName";
    public static final String ADDRESS_INITIAL_CONTEXT_FACTORY = "initialContextFactory";
    public static final String ADDRESS_JNDI_PROVIDER_URL = "jndiProviderURL";

    public EJBTransport(ServiceContext ctx) {
        super(ctx);
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "EJBTransport ctor(ServiceContext)", ctx);
        }
    }

    public Object getTargetKey(InvocationContext invContext) {
        return invContext.getEndpoint();
    }

    public void close(InvocationContext invContext, Object target) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "close", new Object[]{invContext, target});
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "close");
        }
    }

    public String getProtocol() {
        return PROTOCOL;
    }

    public Object makeTargetObject(InvocationContext invContext) throws RemoteException {
        Map props;
        String ejbStubClassName;
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "makeTargetObject", invContext);
        }
        String endpoint = invContext.getEndpoint();
        AgnosticAddress agnosticAddress = new AgnosticAddress();
        agnosticAddress.setLocationURI(endpoint);
        try {
            ejbStubClassName = agnosticAddress.getURLHost();
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "EJB stub classname: " + ejbStubClassName);
            }
        }
        catch (WSDLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.ejb.EJBTransport.makeTargetObject", "103", (Object)this);
            throw new JAXRPCException(Messages.getMessage((String)"errorGetEjbClass", (String)"WSDLException", (String)endpoint, (String)e.toString()));
        }
        try {
            props = agnosticAddress.getURLQueryProperties();
        }
        catch (WSDLException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.webservices.multiprotocol.provider.ejb.EJBTransport.makeTargetObject", "117", (Object)this);
            throw new JAXRPCException(Messages.getMessage((String)"errorGetQueryProps", (String)"WSDLException", (String)endpoint, (String)e.toString()));
        }
        if (!props.containsKey(ADDRESS_JNDI_NAME)) {
            throw new JAXRPCException(Messages.getMessage((String)"missingUrlProp", (String)ADDRESS_JNDI_NAME, (String)endpoint));
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Properties contained in endpoint URL string: " + props.toString());
        }
        String ejbJNDIName = (String)props.get(ADDRESS_JNDI_NAME);
        String icf = (String)props.get(ADDRESS_INITIAL_CONTEXT_FACTORY);
        String providerURL = (String)props.get(ADDRESS_JNDI_PROVIDER_URL);
        Class seiClass = invContext.getSeiClass();
        EJBObjectFactory ejbFactory = EJBObjectFactory.newInstance();
        Object ejbObject = seiClass != null ? ejbFactory.getStub(ejbStubClassName, ejbJNDIName, seiClass, icf, providerURL) : ejbFactory.getDII(ejbJNDIName, icf, providerURL);
        return ejbObject;
    }

    public Object invoke(InvocationContext invContext, Object target, QName operationName, Object[] inputParams, Class returnClass) throws RemoteException {
        Object response;
        if (target instanceof EJBDII) {
            EJBDII ejbDII = (EJBDII)target;
            ejbDII.setInputTypes(invContext.getInputParameterTypes());
            ejbDII.setReturnType(returnClass);
            response = ejbDII.invoke(JavaUtils.xmlNameToJava(operationName.getLocalPart()), inputParams);
        } else {
            response = super.invoke(invContext, target, operationName, inputParams, returnClass);
        }
        return response;
    }
}

