/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.utils;

import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.resources.Messages;
import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.logging.Log;

public class BeanPropertyDescriptor {
    protected static Log log = LogFactory.getLog(BeanPropertyDescriptor.class.getName());
    protected PropertyDescriptor myPD = null;

    public BeanPropertyDescriptor(PropertyDescriptor pd) {
        this.myPD = pd;
    }

    protected BeanPropertyDescriptor() {
    }

    public String getName() {
        return this.myPD.getName();
    }

    public boolean isReadable() {
        return this.myPD.getReadMethod() != null;
    }

    public boolean isWriteable() {
        return this.myPD.getWriteMethod() != null;
    }

    public boolean isIndexed() {
        return this.myPD instanceof IndexedPropertyDescriptor;
    }

    public Object get(Object obj) throws InvocationTargetException, IllegalAccessException {
        if (this.myPD.getReadMethod() != null) {
            return this.myPD.getReadMethod().invoke(obj, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("get() obj=" + obj.getClass().getName());
            log.debug("get() name=" + this.getName());
            log.debug("get() readable=" + this.isReadable());
            log.debug("get() writeable=" + this.isWriteable());
            log.debug("get() indexed=" + this.isIndexed());
            log.debug("get() type=" + this.getType());
        }
        throw new IllegalAccessException(Messages.getMessage("badGetter00"));
    }

    public void set(Object obj, Object newValue) throws InvocationTargetException, IllegalAccessException {
        if (this.myPD.getWriteMethod() == null) {
            if (log.isDebugEnabled()) {
                log.debug("set() obj=" + obj.getClass().getName());
                log.debug("set() newValue=" + newValue);
                log.debug("set() name=" + this.getName());
                log.debug("set() readable=" + this.isReadable());
                log.debug("set() writeable=" + this.isWriteable());
                log.debug("set() indexed=" + this.isIndexed());
                log.debug("set() type=" + this.getType());
            }
            throw new IllegalAccessException(Messages.getMessage("badSetter00"));
        }
        this.myPD.getWriteMethod().invoke(obj, newValue);
    }

    public Object get(Object obj, int i) throws InvocationTargetException, IllegalAccessException {
        if (!this.isIndexedReadable()) {
            return Array.get(this.get(obj), i);
        }
        IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)this.myPD;
        return id.getIndexedReadMethod().invoke(obj, new Integer(i));
    }

    public void set(Object obj, int i, Object newValue) throws InvocationTargetException, IllegalAccessException {
        if (this.isIndexedWriteable()) {
            IndexedPropertyDescriptor id = (IndexedPropertyDescriptor)this.myPD;
            this.growArrayToSize(obj, id.getIndexedPropertyType(), i);
            id.getIndexedWriteMethod().invoke(obj, new Integer(i), newValue);
        } else {
            Object array = this.get(obj);
            if (array == null) {
                array = this.growArrayToSize(obj, this.myPD.getPropertyType().getComponentType(), i);
            }
            Array.set(array, i, newValue);
        }
    }

    protected Object growArrayToSize(Object obj, Class componentType, int i) throws InvocationTargetException, IllegalAccessException {
        Object array = this.get(obj);
        if (array == null || Array.getLength(array) <= i) {
            Object newArray = Array.newInstance(componentType, i + 1);
            if (array != null) {
                System.arraycopy(array, 0, newArray, 0, Array.getLength(array));
            }
            this.set(obj, newArray);
            return newArray;
        }
        return array;
    }

    public Class getType() {
        if (this.isIndexed()) {
            return ((IndexedPropertyDescriptor)this.myPD).getIndexedPropertyType();
        }
        return this.myPD.getPropertyType();
    }

    public Class getFullType() {
        return this.myPD.getPropertyType();
    }

    public boolean isIndexedReadable() {
        if (this.isIndexed()) {
            return ((IndexedPropertyDescriptor)this.myPD).getIndexedReadMethod() != null;
        }
        return false;
    }

    public boolean isIndexedWriteable() {
        if (this.isIndexed()) {
            return ((IndexedPropertyDescriptor)this.myPD).getIndexedWriteMethod() != null;
        }
        return false;
    }
}

