/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.Message;
import com.ibm.ws.webservices.engine.Part;
import com.ibm.ws.webservices.engine.WebServicesFault;
import com.ibm.ws.webservices.engine.attachments.AttachmentUtils;
import com.ibm.ws.webservices.engine.attachments.Attachments;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.DeserializationContext;
import com.ibm.ws.webservices.engine.encoding.ser.SimpleDeserializer;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.AttributeUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.MappingScope;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class JAFDataHandlerDeserializer
extends SimpleDeserializer {
    protected static Log log = LogFactory.getLog(JAFDataHandlerDeserializer.class.getName());
    protected DeserializationContext context;

    public JAFDataHandlerDeserializer(Class javaType, QName xmlType) {
        super(javaType, xmlType);
    }

    public void startElement(String namespace, String localName, String prefixedName, Attributes attributes, MappingScope mappingScope, DeserializationContext context) throws SAXException {
        if (log.isDebugEnabled()) {
            QName type = AttributeUtils.getTypeFromAttributes(namespace, localName, attributes, mappingScope);
            log.debug(Messages.getMessage("gotType00", "Deser", "" + type));
        }
        this.context = context;
        String href = attributes.getValue("href");
        if (log.isDebugEnabled()) {
            log.debug("href=" + href);
        }
        if (href != null) {
            this.setValue(this.getDataHandler(href));
        } else {
            super.startElement(namespace, localName, prefixedName, attributes, mappingScope, context);
        }
    }

    public Object makeValue(String source) {
        return source == null ? this.getValue() : this.getDataHandler(source);
    }

    public Object makeValue(DataHandler dataHandler) {
        return dataHandler;
    }

    private DataHandler getDataHandler(String href) {
        Attachments atts;
        Message msg = this.context.getMessageContext().getCurrentMessage();
        if (msg != null && (atts = msg.getAttachmentsImpl()) != null) {
            try {
                Part part = atts.getAttachmentByReference(href);
                return AttachmentUtils.getActivationDataHandler((Part)part);
            }
            catch (WebServicesFault wsf) {
                FFDCFilter.processException((Throwable)wsf, "com.ibm.ws.webservices.engine.encoding.ser.JAFDataHandlerDeserializer", "117", this);
                throw new RuntimeException(wsf.toString() + JavaUtils.stackToString(wsf));
            }
        }
        return null;
    }
}

