/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.ser;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.encoding.Serializer;
import com.ibm.ws.webservices.engine.encoding.ser.BaseSerializerFactory;
import com.ibm.ws.webservices.engine.encoding.ser.BeanSerializer;
import com.ibm.ws.webservices.engine.encoding.ser.EnumSerializer;
import com.ibm.ws.webservices.engine.encoding.utils.BeanDesc;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.BeanPropertyDescriptor;
import com.ibm.ws.webservices.engine.utils.BeanUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;

public class BeanSerializerFactory
extends BaseSerializerFactory {
    protected BeanDesc beanDesc = null;
    protected BeanPropertyDescriptor[] propertyDescriptor = null;

    public BeanSerializerFactory(Class javaType, QName xmlType) {
        super(BeanSerializer.class, xmlType, javaType);
        if (JavaUtils.isEnumClass(javaType)) {
            this.serClass = EnumSerializer.class;
        }
    }

    public static BeanSerializerFactory create(Class javaType, QName xmlType, QName compQName, QName compTypeQName) {
        return new BeanSerializerFactory(javaType, xmlType);
    }

    protected void lazyInitialization() {
        super.lazyInitialization();
        this.beanDesc = BeanDesc.getBeanDescForClass(this.javaType);
        if (this.beanDesc == null) {
            this.propertyDescriptor = BeanUtils.getPd(this.javaType, null);
        }
    }

    public javax.xml.rpc.encoding.Serializer getSerializerAs(String mechanismType) throws JAXRPCException {
        return (Serializer)super.getSerializerAs(mechanismType);
    }

    protected Serializer getSpecialized(String mechanismType) {
        Serializer beanSer = super.getSpecialized(mechanismType);
        if (beanSer != null && beanSer instanceof BeanSerializer && this.beanDesc != null) {
            ((BeanSerializer)beanSer).setup(this.beanDesc, this.beanDesc.getPropertyDescriptors());
        }
        return beanSer;
    }

    protected Serializer getGeneralPurpose(String mechanismType) {
        if (this.javaType == null || this.xmlType == null) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.serClass == EnumSerializer.class) {
            return super.getGeneralPurpose(mechanismType);
        }
        if (this.beanDesc != null) {
            return new BeanSerializer(this.javaType, this.xmlType, this.beanDesc);
        }
        return new BeanSerializer(this.javaType, this.xmlType, null, this.propertyDescriptor);
    }

    protected Method getSerializerMethod(Class clazz) {
        Method method2 = super.getSerializerMethod(clazz);
        if (method2 == null && !this.serClass.equals(EnumSerializer.class)) {
            throw new InternalException(Messages.getMessage("missingHelper00", this.javaType.getName()));
        }
        return method2;
    }
}

