/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.encoding.custom;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.encoding.custom.CustomMapping;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.QName;

public class CustomProvider {
    public static final short SCOPE_SERVER = 1;
    public static final short SCOPE_APPLICATION = 2;
    public static final short SCOPE_MODULE = 3;
    private String path;
    private short scope;
    private ArrayList mappings = new ArrayList();
    private QName[] qnames;

    CustomProvider(String path, String providerScope) {
        this.path = path;
        if (providerScope.equals("application")) {
            this.scope = (short)2;
        } else if (providerScope.equals("module")) {
            this.scope = (short)3;
        } else if (providerScope.equals("server")) {
            this.scope = 1;
        } else {
            throw new IllegalArgumentException("Wrong scope: " + providerScope);
        }
    }

    public synchronized void addMapping(QName xmlName, String javaName, String scope, String binder, Properties initParams) {
        this.mappings.add(new CustomMapping(xmlName, javaName, scope, binder, initParams));
        this.qnames = null;
    }

    public synchronized QName[] getQNames() {
        if (this.qnames == null) {
            this.qnames = new QName[this.mappings.size()];
            int i = 0;
            Iterator it = this.mappings.iterator();
            while (it.hasNext()) {
                CustomMapping mapping = (CustomMapping)it.next();
                QName qname = mapping.getQName();
                this.qnames[i++] = QNameTable.createQName(qname.getNamespaceURI(), qname.getLocalPart());
            }
        }
        return this.qnames;
    }

    public String getPath() {
        return this.path;
    }

    public short getScope() {
        return this.scope;
    }

    public synchronized QName getQName(String javaName) {
        CustomMapping mapping = this.getMapping(null, javaName);
        return mapping == null ? null : mapping.getQName();
    }

    public synchronized String getJavaName(QName qname) {
        CustomMapping mapping = this.getMapping(qname, null);
        return mapping == null ? null : mapping.getJavaName();
    }

    public synchronized String getBinderName(QName qname, String javaName) {
        CustomMapping mapping = this.getMapping(qname, javaName);
        return mapping == null ? null : mapping.getBinder();
    }

    public synchronized Properties getMappingInitParams(QName qname, String javaName) {
        CustomMapping mapping = this.getMapping(qname, javaName);
        return mapping == null ? null : mapping.getInitParams();
    }

    private CustomMapping getMapping(QName qname, String javaName) {
        CustomMapping target = null;
        Iterator it = this.mappings.iterator();
        block2: while (it.hasNext()) {
            CustomMapping mapping = (CustomMapping)it.next();
            if (qname != null) {
                if (!mapping.getQName().equals(qname)) continue;
                if (javaName != null) {
                    String javaNameInMap = mapping.getJavaName();
                    if (javaNameInMap.equals(javaName)) {
                        target = mapping;
                        break;
                    }
                    try {
                        Class<?> javaClass = Class.forName(javaName, false, Thread.currentThread().getContextClassLoader());
                        Class<?>[] interfaces = javaClass.getInterfaces();
                        if (interfaces == null) continue;
                        for (int i = 0; i < interfaces.length; ++i) {
                            Class<?> iface = interfaces[i];
                            if (!iface.getName().equals(javaNameInMap)) continue;
                            target = mapping;
                            continue block2;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        FFDCFilter.processException((Throwable)ex, "com.ibm.ws.webservices.engine.encoding.custom.CustomProvider.getBinderName", "157", this);
                        continue;
                    }
                }
                target = mapping;
                break;
            }
            if (!mapping.getJavaName().equals(javaName)) continue;
            target = mapping;
            break;
        }
        return target;
    }
}

