/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.deployment.wsdd;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.Handler;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDConstants;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDException;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDOperation;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDPort;
import com.ibm.ws.webservices.engine.deployment.wsdd.dispatchers.WSDDGenericDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.dispatchers.WSDDJavaEJBDispatcher;
import com.ibm.ws.webservices.engine.deployment.wsdd.dispatchers.WSDDJavaRPCDispatcher;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import java.util.Hashtable;
import javax.xml.namespace.QName;

public abstract class WSDDDispatcher {
    private static Hashtable dispatchers = new Hashtable();

    public static void registerDispatcher(QName uri, WSDDDispatcher prov) {
        dispatchers.put(uri, prov);
    }

    public static void registerDispatcher(QName uri, String dispatcherClassname) throws WSDDException {
        Class _class;
        try {
            _class = ClassUtils.forName(dispatcherClassname, true, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher.registerDispatcher", "143");
            throw WSDDException.makeWSDDException(e);
        }
        if (WSDDDispatcher.class.isAssignableFrom(_class)) {
            try {
                WSDDDispatcher.registerDispatcher(uri, (WSDDDispatcher)_class.newInstance());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher.registerDispatcher", "152");
                throw WSDDException.makeWSDDException(e);
            }
        } else if (Handler.class.isAssignableFrom(_class)) {
            try {
                WSDDDispatcher.registerDispatcher(uri, new WSDDGenericDispatcher(_class));
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDispatcher.registerDispatcher", "159");
                throw WSDDException.makeWSDDException(e);
            }
        } else {
            throw new WSDDException(Messages.getMessage("namedArtifactDidntImplement03", "Dispatcher", dispatcherClassname, WSDDDispatcher.class.getName()));
        }
    }

    public WSDDOperation[] getOperations() {
        return null;
    }

    public WSDDOperation getOperation(String name) {
        return null;
    }

    public static Handler getInstance(QName dispatcherType, WSDDPort wsddPort, EngineConfiguration registry) throws Exception {
        if (dispatcherType == null) {
            throw new WSDDException(Messages.getMessage("nullProvider00"));
        }
        WSDDDispatcher dispatcher = (WSDDDispatcher)dispatchers.get(dispatcherType);
        if (dispatcher == null) {
            throw new WSDDException(Messages.getMessage("noMatchingProvider00", dispatcherType.toString()));
        }
        return dispatcher.newDispatcherInstance(wsddPort, registry);
    }

    public abstract Handler newDispatcherInstance(WSDDPort var1, EngineConfiguration var2) throws Exception;

    static {
        WSDDDispatcher.registerDispatcher(WSDDConstants.QNAME_JAVARPC_DISPATCHER, new WSDDJavaRPCDispatcher());
        WSDDDispatcher.registerDispatcher(WSDDConstants.QNAME_EJB_DISPATCHER, new WSDDJavaEJBDispatcher());
    }
}

